/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class VHostComponent
extends BaseComponent<VHostComponent>
implements MeasurementFacet {
    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(metrics.size());
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("_aliases")) {
                ReadAttribute op = new ReadAttribute(this.getAddress(), "alias");
                Result res = this.getASConnection().execute(op);
                if (res.isSuccess()) {
                    MeasurementDataTrait data;
                    List aliases = (List)res.getResult();
                    if (aliases != null) {
                        Collections.sort(aliases);
                        String trait = aliases.toString();
                        data = new MeasurementDataTrait(request, trait);
                    } else {
                        data = new MeasurementDataTrait(request, "-none-");
                    }
                    report.addData(data);
                    continue;
                }
                VHostComponent.getLog().warn((Object)("Could not get aliases for " + this.getAddress() + ": " + res.getFailureDescription()));
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }
}

