/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class WebConnectorComponent
extends BaseComponent<WebConnectorComponent>
implements MeasurementFacet {
    private static final String MAX_CONNECTIONS_METRIC_NAME = "_expr:max-connections";
    private static final String MAX_CONNECTIONS_CONFIG_ATTRIBUTE = "max-connections:expr";

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        super.getValues(report, metrics);
        MeasurementScheduleRequest maxConnectionMetricRequest = this.getMaxConnectionMetricRequest(metrics);
        if (maxConnectionMetricRequest != null && !this.hasMaxConnectionMetric(report)) {
            report.addData(new MeasurementDataNumeric(maxConnectionMetricRequest, Double.valueOf(this.computeMaxConnections())));
        }
    }

    private MeasurementScheduleRequest getMaxConnectionMetricRequest(Set<MeasurementScheduleRequest> metrics) {
        for (MeasurementScheduleRequest metric : metrics) {
            if (!MAX_CONNECTIONS_METRIC_NAME.equals(metric.getName())) continue;
            return metric;
        }
        return null;
    }

    private boolean hasMaxConnectionMetric(MeasurementReport report) {
        for (MeasurementDataNumeric metric : report.getNumericData()) {
            if (!MAX_CONNECTIONS_METRIC_NAME.equals(metric.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = super.loadResourceConfiguration();
        PropertySimple maxConnProp = configuration.getSimple(MAX_CONNECTIONS_CONFIG_ATTRIBUTE);
        if (maxConnProp.getStringValue() == null) {
            maxConnProp.setIntegerValue(Integer.valueOf(this.computeMaxConnections()));
        }
        return configuration;
    }

    private int computeMaxConnections() {
        int val = -1;
        String scheme = null;
        ReadAttribute op = new ReadAttribute(this.getAddress(), "scheme");
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            scheme = (String)res.getResult();
        }
        Address address1 = new Address(this.getAddress());
        address1 = address1.getParent();
        address1 = address1.getParent();
        address1.add("core-service", "platform-mbean");
        address1.add("type", "operating-system");
        op = new ReadAttribute(address1, "available-processors");
        res = this.getASConnection().execute(op);
        int cores = 1;
        if (res.isSuccess() && res.getResult() != null) {
            cores = (Integer)res.getResult();
        }
        if ("http".equals(scheme)) {
            val = cores * 512;
        } else if ("https".equals(scheme)) {
            val = cores * 512;
        } else if ("ajp".equals(scheme)) {
            val = 32 * cores;
        }
        return val;
    }
}

