/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class HibernatePersistenceUnitComponent
extends BaseComponent {
    private static final String[] QUERY_CACHE_ATTRIBUTE_NAMES = new String[]{"query-name", "query-execution-count", "query-execution-row-count", "query-execution-min-time", "query-execution-max-time", "query-execution-average-time", "query-cache-hit-count", "query-cache-miss-count", "query-cache-put-count"};
    private static final int BATCH_SIZE = 10;
    private static final int MANAGEMENT_QUERY_TIMEOUT = 60;

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("viewQueries".equals(name)) {
            return this.invokeViewQueriesOperation(parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult invokeViewQueriesOperation(Configuration parameters) throws InterruptedException {
        int timeoutSec;
        int batchSize;
        OperationResult operationResult = new OperationResult();
        PropertySimple batchSizeProp = parameters.getSimple("batchSize");
        if (batchSizeProp == null || batchSizeProp.getStringValue() == null) {
            batchSize = 10;
        } else {
            try {
                batchSize = Integer.parseInt(batchSizeProp.getStringValue());
                if (batchSize < 1) {
                    operationResult.setErrorMessage("batchSize property is less than 1");
                    return operationResult;
                }
            }
            catch (NumberFormatException e) {
                operationResult.setErrorMessage("batchSize property is not an integer");
                return operationResult;
            }
        }
        PropertySimple managementQueryTimeoutProp = parameters.getSimple("managementQueryTimeout");
        if (managementQueryTimeoutProp == null || managementQueryTimeoutProp.getStringValue() == null) {
            timeoutSec = 60;
        } else {
            try {
                timeoutSec = Integer.parseInt(managementQueryTimeoutProp.getStringValue());
                if (timeoutSec < 1) {
                    operationResult.setErrorMessage("managementQueryTimeout property is less than 1");
                    return operationResult;
                }
            }
            catch (NumberFormatException e) {
                operationResult.setErrorMessage("managementQueryTimeout property is not an integer");
                return operationResult;
            }
        }
        PropertyList queriesPropertyList = new PropertyList("queries");
        operationResult.getComplexResults().put((Property)queriesPropertyList);
        ReadChildrenNames readQueryCacheChildrenNames = new ReadChildrenNames(this.getAddress(), "query-cache");
        Result readQueryCacheChildrenNamesResult = this.getASConnection().execute((Operation)readQueryCacheChildrenNames, timeoutSec);
        if (!readQueryCacheChildrenNamesResult.isSuccess()) {
            operationResult.setErrorMessage("Could not read query-cache children names: " + readQueryCacheChildrenNamesResult.getFailureDescription());
            return operationResult;
        }
        List childrenNames = (List)readQueryCacheChildrenNamesResult.getResult();
        while (!childrenNames.isEmpty()) {
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            List childrenNamesSubList = childrenNames.subList(0, Math.min(batchSize, childrenNames.size()));
            CompositeOperation batchOperation = new CompositeOperation();
            for (String childrenName : childrenNamesSubList) {
                Address address = new Address(this.getAddress());
                address.add("query-cache", childrenName);
                ReadResource readQueryCacheResource = new ReadResource(address);
                readQueryCacheResource.includeRuntime(true);
                batchOperation.addStep(readQueryCacheResource);
            }
            Result batchResult = this.getASConnection().execute((Operation)batchOperation, timeoutSec);
            if (!batchResult.isSuccess()) {
                operationResult.setErrorMessage("Could not read query-cache attributes: " + batchResult.getFailureDescription());
                return operationResult;
            }
            Map mapResult = (Map)batchResult.getResult();
            for (Map stepResult : mapResult.values()) {
                PropertyMap queryPropertyMap = new PropertyMap("query");
                Map queryCacheAttributes = (Map)stepResult.get("result");
                for (String queryCacheAttributeName : QUERY_CACHE_ATTRIBUTE_NAMES) {
                    this.addAttributeToPropertyMap(queryCacheAttributeName, queryPropertyMap, queryCacheAttributes);
                }
                queriesPropertyList.add((Property)queryPropertyMap);
            }
            childrenNamesSubList.clear();
        }
        return operationResult;
    }

    private void addAttributeToPropertyMap(String attributeName, PropertyMap propertyMap, Map<String, String> queryCacheAttributes) {
        propertyMap.put((Property)new PropertySimple(attributeName, (Object)queryCacheAttributes.get(attributeName)));
    }
}

