/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.bundle.BundleHandoverFacet;
import org.rhq.core.pluginapi.bundle.BundleHandoverRequest;
import org.rhq.core.pluginapi.bundle.BundleHandoverResponse;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.modules.plugins.jbossas7.AS7CommandLine;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.ServerControl;
import org.rhq.modules.plugins.jbossas7.helper.HostConfiguration;
import org.rhq.modules.plugins.jbossas7.helper.HostPort;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.ResultFailedException;
import org.rhq.modules.plugins.jbossas7.json.SecurityRealmNotReadyException;
import org.rhq.modules.plugins.jbossas7.util.ProcessExecutionLogger;

public abstract class BaseServerComponent<T extends ResourceComponent<?>>
extends BaseComponent<T>
implements MeasurementFacet,
BundleHandoverFacet {
    private static final Log LOG = LogFactory.getLog(BaseServerComponent.class);
    protected static final long MAX_TIMEOUT_FAILURE_WAIT = 300000L;
    private ASConnection connection;
    private LogFileEventResourceComponentHelper logFileEventDelegate;
    private StartScriptConfiguration startScriptConfig;
    private ServerPluginConfiguration serverPluginConfig;
    private AvailabilityType previousAvailabilityType;
    private String releaseVersion;
    private String aSHostName;
    private long lastManagementInterfaceReply = 0L;

    @Override
    public void start(ResourceContext<T> resourceContext) throws Exception {
        super.start(resourceContext);
        this.serverPluginConfig = new ServerPluginConfiguration(this.pluginConfiguration);
        this.serverPluginConfig.validate();
        this.connection = new ASConnection(ASConnectionParams.createFrom(this.serverPluginConfig));
        this.setASHostName(this.findASDomainHostName());
        this.getAvailability();
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(this.context);
        this.logFileEventDelegate.startLogFileEventPollers();
        this.startScriptConfig = new StartScriptConfiguration(this.pluginConfiguration);
    }

    @Override
    public void stop() {
        this.connection.shutdown();
        this.logFileEventDelegate.stopLogFileEventPollers();
        this.previousAvailabilityType = null;
    }

    @Override
    public AvailabilityType getAvailability() {
        AvailabilityType availabilityType;
        boolean securityRealmReady = true;
        try {
            try {
                this.readAttribute(this.getHostAddress(), "name", 60);
                availabilityType = AvailabilityType.UP;
                this.lastManagementInterfaceReply = new Date().getTime();
            }
            catch (ResultFailedException e) {
                LOG.warn((Object)"Domain host name seems to be changed");
                this.setASHostName(this.findASDomainHostName());
                LOG.info((Object)("Detected domain host name [" + this.getASHostName() + "]"));
                this.readAttribute(this.getHostAddress(), "name");
                availabilityType = AvailabilityType.UP;
            }
            catch (SecurityRealmNotReadyException e) {
                this.previousAvailabilityType = AvailabilityType.DOWN;
                availabilityType = AvailabilityType.DOWN;
                securityRealmReady = false;
            }
        }
        catch (TimeoutException e) {
            ProcessInfo processInfo;
            long now = new Date().getTime();
            availabilityType = now - this.lastManagementInterfaceReply > 300000L ? AvailabilityType.DOWN : ((processInfo = this.context.getNativeProcess()) != null && processInfo.priorSnaphot().isRunning() ? this.previousAvailabilityType : AvailabilityType.DOWN);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getResourceDescription() + ": exception while checking availability"), (Throwable)e);
            }
            availabilityType = AvailabilityType.DOWN;
        }
        if (!securityRealmReady) {
            throw new InvalidPluginConfigurationException("The security realm of the HTTP management interface is not ready to process requests. This usually indicates that no user is configured");
        }
        if (availabilityType == AvailabilityType.DOWN) {
            this.releaseVersion = null;
        } else if (this.previousAvailabilityType != AvailabilityType.UP) {
            this.onAvailGoesUp();
        }
        this.previousAvailabilityType = availabilityType;
        return availabilityType;
    }

    protected void onAvailGoesUp() {
        this.validateServerAttributes();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getResourceDescription() + " has just come UP."));
        }
    }

    private void validateServerAttributes() throws InvalidPluginConfigurationException {
        String runtimeProductName;
        String mode;
        String runtimeMode;
        File runtimeConfigDir;
        File runtimeBaseDir;
        File baseDir = null;
        try {
            String runtimeBaseDirString = this.readAttribute(this.getEnvironmentAddress(), this.getBaseDirAttributeName());
            runtimeBaseDir = new File(runtimeBaseDirString).getCanonicalFile();
            File baseDirTmp = this.serverPluginConfig.getBaseDir();
            if (baseDirTmp != null) {
                baseDir = baseDirTmp.getCanonicalFile();
            }
        }
        catch (Exception e) {
            runtimeBaseDir = null;
            baseDir = null;
            LOG.error((Object)("Failed to validate base dir for " + this.getResourceDescription() + "."), (Throwable)e);
        }
        if (runtimeBaseDir != null && baseDir != null && !runtimeBaseDir.equals(baseDir)) {
            throw new InvalidPluginConfigurationException("The server listening on " + this.serverPluginConfig.getHostname() + ":" + this.serverPluginConfig.getPort() + " has base dir [" + runtimeBaseDir + "], but the base dir we expected was [" + baseDir + "]. Perhaps the management hostname or port has been changed for the server with base dir [" + baseDir + "].");
        }
        File configDir = null;
        try {
            String runtimeConfigDirString = this.readAttribute(this.getEnvironmentAddress(), this.getConfigDirAttributeName());
            runtimeConfigDir = new File(runtimeConfigDirString).getCanonicalFile();
            File configDirTmp = this.serverPluginConfig.getConfigDir();
            if (configDirTmp != null) {
                configDir = configDirTmp.getCanonicalFile();
            }
        }
        catch (Exception e) {
            runtimeConfigDir = null;
            configDir = null;
            LOG.error((Object)("Failed to validate config dir for " + this.getResourceDescription() + "."), (Throwable)e);
        }
        if (runtimeConfigDir != null && configDir != null && !runtimeConfigDir.equals(configDir)) {
            throw new InvalidPluginConfigurationException("The server listening on " + this.serverPluginConfig.getHostname() + ":" + this.serverPluginConfig.getPort() + " has config dir [" + runtimeConfigDir + "], but the config dir we expected was [" + configDir + "]. Perhaps the management hostname or port has been changed for the server with config dir [" + configDir + "].");
        }
        try {
            runtimeMode = this.readAttribute("launch-type");
        }
        catch (Exception e) {
            runtimeMode = null;
            LOG.error((Object)("Failed to validate mode for " + this.getResourceDescription() + "."), (Throwable)e);
        }
        if (runtimeMode != null && !runtimeMode.equals(mode = this.getMode().name())) {
            throw new InvalidPluginConfigurationException("The original mode discovered for this AS7 server was " + (Object)((Object)this.getMode()) + ", but the server is now reporting its mode is [" + runtimeMode + "].");
        }
        String expectedRuntimeProductName = this.pluginConfiguration.getSimpleValue("expectedRuntimeProductName");
        try {
            runtimeProductName = this.readAttribute(this.getHostAddress(), "product-name");
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException("Failed to validate product type for " + this.getResourceDescription(), (Throwable)e);
        }
        if (runtimeProductName == null || runtimeProductName.trim().isEmpty()) {
            String releaseVersionNumber;
            try {
                releaseVersionNumber = this.readAttribute(this.getHostAddress(), "release-version");
            }
            catch (Exception e) {
                throw new InvalidPluginConfigurationException("Failed to validate product type for " + this.getResourceDescription(), (Throwable)e);
            }
            runtimeProductName = releaseVersionNumber.startsWith("8.") ? JBossProductType.WILDFLY8.PRODUCT_NAME : JBossProductType.AS.PRODUCT_NAME;
        }
        if (!runtimeProductName.equals(expectedRuntimeProductName)) {
            throw new InvalidPluginConfigurationException("The original product type discovered for this server was " + expectedRuntimeProductName + ", but the server is now reporting its product type is [" + runtimeProductName + "]");
        }
    }

    public ServerPluginConfiguration getServerPluginConfiguration() {
        return this.serverPluginConfig;
    }

    public StartScriptConfiguration getStartScriptConfiguration() {
        return this.startScriptConfig;
    }

    @Override
    public ASConnection getASConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(ASConnection connection) {
        this.connection = connection;
    }

    @NotNull
    protected abstract AS7Mode getMode();

    protected OperationResult restartServer(Configuration parameters) throws Exception {
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Restarting")) {
            return operationResult;
        }
        List<String> errors = this.validateStartScriptPluginConfigProps();
        if (!errors.isEmpty()) {
            OperationResult result = new OperationResult();
            this.setErrorMessage(result, errors);
            return result;
        }
        OperationResult tmp = this.invokeOperation("shutdown", parameters);
        if (tmp.getErrorMessage() != null) {
            tmp.setErrorMessage("Restart failed while attempting to shut down: " + tmp.getErrorMessage());
            return tmp;
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return this.startServer();
    }

    protected boolean waitUntilDown() throws InterruptedException {
        boolean notAnswering = false;
        while (!notAnswering) {
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            try {
                Result res = this.getASConnection().execute(op);
                if (!res.isSuccess()) {
                    notAnswering = true;
                }
            }
            catch (Exception e) {
                notAnswering = true;
            }
            if (notAnswering) continue;
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        HostConfiguration hostConfig = this.getHostConfig();
        AS7CommandLine commandLine = new AS7CommandLine(new String[]{"java", "foo.Main", "org.jboss.as.host-controller"});
        HostPort hostPort = hostConfig.getDomainControllerHostPort(commandLine);
        if (hostPort.isLocal) {
            ProcessInfo processInfo = this.context.getNativeProcess();
            while (processInfo != null && processInfo.priorSnaphot().isRunning()) {
                if (this.context.getComponentInvocationContext().isInterrupted()) {
                    throw new InterruptedException();
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                processInfo = this.context.getNativeProcess();
            }
        }
        return true;
    }

    protected OperationResult startServer() throws InterruptedException {
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Starting")) {
            return operationResult;
        }
        List<String> errors = this.validateStartScriptPluginConfigProps();
        if (!errors.isEmpty()) {
            this.setErrorMessage(operationResult, errors);
            return operationResult;
        }
        ProcessExecutionResults results = ServerControl.onServer(this.context.getPluginConfiguration(), this.getMode(), this.context.getSystemInformation()).lifecycle().startServer();
        ProcessExecutionLogger.logExecutionResults(results);
        if (results.getError() != null) {
            operationResult.setErrorMessage(results.getError().getMessage());
        } else if (results.getExitCode() != null && results.getExitCode() != 0) {
            operationResult.setErrorMessage("Start failed with error code " + results.getExitCode() + ":\n" + results.getCapturedOutput());
        } else {
            boolean up = this.waitForServerToStart();
            if (up) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to start the server");
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    protected OperationResult runCliCommand(Configuration parameters) throws InterruptedException {
        ProcessExecutionResults results;
        OperationResult result = new OperationResult();
        if (this.isManuallyAddedServer(result, "Executing jboss-cli")) {
            return result;
        }
        long waitTime = Integer.parseInt(parameters.getSimpleValue("waitTime", "3600"));
        if (waitTime <= 0L) {
            result.setErrorMessage("waitTime parameter must be positive integer");
            return result;
        }
        ServerControl.Cli cli = ServerControl.onServer(this.context.getPluginConfiguration(), this.getMode(), this.context.getSystemInformation()).waitingFor(waitTime * 1000L).killingOnTimeout(Boolean.parseBoolean(parameters.getSimpleValue("killOnTimeout", "false"))).cli();
        String commands = parameters.getSimpleValue("commands");
        if (commands != null) {
            results = cli.executeCliCommand(commands);
        } else {
            File script = new File(parameters.getSimpleValue("file"));
            if (!script.isAbsolute()) {
                script = new File(this.serverPluginConfig.getHomeDir(), script.getPath()).getAbsoluteFile();
            }
            results = cli.executeCliScript(script);
        }
        ProcessExecutionLogger.logExecutionResults(results);
        result.setSimpleResult(results.getCapturedOutput());
        if (results.getError() != null) {
            result.setErrorMessage(results.getError().getMessage());
            return result;
        }
        if (results.getExitCode() == null) {
            result.setErrorMessage("jboss-cli execution timed out");
            return result;
        }
        if (results.getExitCode() != 0) {
            result.setErrorMessage("jboss-cli execution failed with error code " + results.getExitCode());
            return result;
        }
        if (Boolean.parseBoolean(parameters.getSimpleValue("triggerAvailability", null))) {
            this.context.getAvailabilityContext().requestAvailabilityCheck();
        }
        if (Boolean.parseBoolean(parameters.getSimpleValue("triggerDiscovery", null))) {
            this.context.getInventoryContext().requestDeferredChildResourcesDiscovery();
        }
        return result;
    }

    public boolean isManuallyAddedServer() {
        return this.pluginConfiguration.get("manuallyAdded") != null;
    }

    private boolean isManuallyAddedServer(OperationResult operationResult, String operation) {
        if (this.isManuallyAddedServer()) {
            operationResult.setErrorMessage(operation + " is not enabled for manually added servers");
            return true;
        }
        return false;
    }

    private void setErrorMessage(OperationResult operationResult, List<String> errors) {
        StringBuilder buffer = new StringBuilder("This Resource's connection properties contain errors: ");
        int errorsSize = errors.size();
        for (int i = 0; i < errorsSize; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            String error = errors.get(i);
            buffer.append('[').append(error).append(']');
        }
        operationResult.setErrorMessage(buffer.toString());
    }

    private List<String> validateStartScriptPluginConfigProps() {
        ArrayList<String> errors = new ArrayList<String>();
        File startScriptFile = this.getStartScriptFile();
        if (!startScriptFile.exists()) {
            errors.add("Start script '" + startScriptFile + "' does not exist.");
        } else if (!startScriptFile.isFile()) {
            errors.add("Start script '" + startScriptFile + "' is not a regular file.");
        } else {
            if (!startScriptFile.canRead()) {
                errors.add("Start script '" + startScriptFile + "' is not readable.");
            }
            if (!startScriptFile.canExecute()) {
                errors.add("Start script '" + startScriptFile + "' is not executable.");
            }
        }
        return errors;
    }

    private File getStartScriptFile() {
        File startScriptFile = this.startScriptConfig.getStartScript();
        File homeDir = this.serverPluginConfig.getHomeDir();
        if (startScriptFile != null) {
            if (!startScriptFile.isAbsolute()) {
                startScriptFile = new File(homeDir, startScriptFile.getPath());
            }
        } else {
            String startScriptFileName = this.getMode().getStartScriptFileName();
            File binDir = new File(homeDir, "bin");
            startScriptFile = new File(binDir, startScriptFileName);
        }
        return startScriptFile;
    }

    private boolean waitForServerToStart() throws InterruptedException {
        boolean up = false;
        while (!up) {
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            try {
                Result res = this.getASConnection().execute(op);
                if (res.isSuccess()) {
                    up = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (up) continue;
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return true;
    }

    protected OperationResult postProcessResult(String name, Result res) {
        OperationResult operationResult = new OperationResult();
        if (res == null) {
            operationResult.setErrorMessage("No result received from server");
            return operationResult;
        }
        if (name.equals("shutdown") || name.equals("restart") || name.equals("reload")) {
            if (!res.isSuccess()) {
                if (StringUtil.isNotBlank((String)res.getFailureDescription()) && res.getFailureDescription().startsWith("The server closed the connection before sending the response")) {
                    operationResult.setSimpleResult("Success");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Got no response for operation '" + name + "'. " + "This is considered ok, as the remote server sometimes closes the communications " + "channel before sending a reply"));
                    }
                } else {
                    operationResult.setErrorMessage(res.getFailureDescription());
                }
            } else {
                operationResult.setSimpleResult("Success");
            }
        } else if (res.isSuccess()) {
            if (res.getResult() != null) {
                operationResult.setSimpleResult(res.getResult().toString());
            } else {
                operationResult.setSimpleResult("-None provided by server-");
            }
        } else {
            operationResult.setErrorMessage(res.getFailureDescription());
        }
        return operationResult;
    }

    protected OperationResult installManagementUser(Configuration parameters, Configuration pluginConfig) {
        boolean userAlreadyExisted;
        String encryptedPassword;
        String realm;
        String user = parameters.getSimpleValue("user", "");
        String password = parameters.getSimpleValue("password", "");
        OperationResult result = new OperationResult();
        PropertySimple remoteProp = pluginConfig.getSimple("manuallyAdded");
        if (remoteProp != null && remoteProp.getBooleanValue() != null && remoteProp.getBooleanValue().booleanValue()) {
            result.setErrorMessage("This is a manually added server. This operation can not be used to install a management user. Use the server's 'bin/add-user.sh'");
            return result;
        }
        if (user.isEmpty() || password.isEmpty()) {
            result.setErrorMessage("User and Password must not be empty");
            return result;
        }
        File baseDir = this.serverPluginConfig.getBaseDir();
        if (baseDir == null) {
            result.setErrorMessage("'baseDir' plugin config prop is not set.");
            return result;
        }
        HostConfiguration hostConfig = this.getHostConfig();
        File propertiesFile = hostConfig.getSecurityPropertyFile(this.serverPluginConfig, realm = pluginConfig.getSimpleValue("realm", "ManagementRealm"));
        if (!propertiesFile.canWrite()) {
            result.setErrorMessage("Management users properties file [" + propertiesFile + "] is not writable.");
            return result;
        }
        try {
            UsernamePasswordHashUtil hashUtil = new UsernamePasswordHashUtil();
            encryptedPassword = hashUtil.generateHashedHexURP(user, realm, password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt password.", e);
        }
        try {
            PropertiesFileUpdate propsFileUpdate = new PropertiesFileUpdate(propertiesFile.getPath());
            userAlreadyExisted = propsFileUpdate.update(user, encryptedPassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update management users properties file [" + propertiesFile + "].", e);
        }
        String verb = userAlreadyExisted ? "updated" : "added";
        result.setSimpleResult("Management user [" + user + "] " + verb + ".");
        LOG.info((Object)("Management user [" + user + "] " + verb + " for " + this.context.getResourceType().getName() + " server with key [" + this.context.getResourceKey() + "]."));
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        this.context.getInventoryContext().requestDeferredChildResourcesDiscovery();
        return result;
    }

    public void requestDeferredChildResourcesDiscovery() {
        this.context.getInventoryContext().requestDeferredChildResourcesDiscovery();
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> skmRequests = new HashSet<MeasurementScheduleRequest>(requests.size());
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        String tempDirAttributeName = this.getTempDirAttributeName();
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            if (requestName.equals("startTime")) {
                this.collectStartTimeTrait(report, request);
                continue;
            }
            if ("active-patches".equals(requestName)) {
                String patches = this.collectPatches();
                if (patches == null) continue;
                report.addData(new MeasurementDataTrait(request, patches));
                continue;
            }
            if (tempDirAttributeName != null && requestName.equals(tempDirAttributeName)) {
                this.collectEnvironmentTrait(report, request);
                continue;
            }
            if (requestName.startsWith("_skm:")) {
                skmRequests.add(request);
                continue;
            }
            leftovers.add(request);
        }
        if (skmRequests.size() > 0) {
            this.collectServerKindTraits(report, skmRequests);
        }
        super.getValues(report, leftovers);
    }

    public String getReleaseVersion() {
        if (this.releaseVersion == null) {
            this.releaseVersion = (String)this.getASConnection().execute(new ReadAttribute(new Address(), "release-version")).getResult();
        }
        return this.releaseVersion;
    }

    private void collectStartTimeTrait(MeasurementReport report, MeasurementScheduleRequest request) {
        Long startTime;
        Address address = new Address(this.getHostAddress());
        address.add("core-service", "platform-mbean");
        address.add("type", "runtime");
        try {
            startTime = this.readAttribute(address, "start-time", Long.class);
        }
        catch (Exception e) {
            startTime = null;
        }
        if (startTime != null) {
            MeasurementDataTrait data = new MeasurementDataTrait(request, new Date(startTime).toString());
            report.addData(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleHandoverResponse handleExecuteScript(BundleHandoverRequest handoverRequest) throws IOException {
        long waitTime;
        Map params;
        block14: {
            params = handoverRequest.getParams();
            String waitTimeParam = (String)params.get("waitTime");
            if (waitTimeParam != null) {
                try {
                    waitTime = Long.parseLong(waitTimeParam);
                    if (waitTime <= 0L) {
                        return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.INVALID_PARAMETER, (String)"waitTime must greater than 0");
                    }
                    break block14;
                }
                catch (NumberFormatException e) {
                    return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.INVALID_PARAMETER, (String)"waitTime is not a number");
                }
            }
            waitTime = TimeUnit.HOURS.toMillis(1L);
        }
        boolean killOnTimeout = Boolean.parseBoolean((String)params.get("killOnTimeout"));
        File scriptFile = null;
        try {
            scriptFile = File.createTempFile(handoverRequest.getFilename(), ".tmp", this.context.getTemporaryDirectory());
            FileUtil.writeFile((InputStream)handoverRequest.getContent(), (File)scriptFile);
            ProcessExecutionResults results = ServerControl.onServer(this.getServerPluginConfiguration().getPluginConfig(), this.getMode(), this.context.getSystemInformation()).waitingFor(waitTime).killingOnTimeout(killOnTimeout).cli().executeCliScript(scriptFile.getAbsoluteFile());
            ProcessExecutionLogger.logExecutionResults(results);
            Throwable error = results.getError();
            if (error != null) {
                BundleHandoverResponse bundleHandoverResponse = BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)error.getMessage(), (Throwable)error);
                return bundleHandoverResponse;
            }
            Integer exitCode = results.getExitCode();
            if (exitCode == null) {
                BundleHandoverResponse bundleHandoverResponse = BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)"Timeout waiting for completion of the CLI process");
                return bundleHandoverResponse;
            }
            if (exitCode != 0) {
                BundleHandoverResponse bundleHandoverResponse = BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)("CLI process exit code is " + exitCode));
                return bundleHandoverResponse;
            }
            BundleHandoverResponse bundleHandoverResponse = BundleHandoverResponse.success();
            return bundleHandoverResponse;
        }
        finally {
            if (scriptFile != null) {
                scriptFile.delete();
            }
        }
    }

    @NotNull
    protected abstract Address getEnvironmentAddress();

    @NotNull
    protected abstract Address getHostAddress();

    @NotNull
    protected abstract String getBaseDirAttributeName();

    @NotNull
    protected abstract String getConfigDirAttributeName();

    protected String getTempDirAttributeName() {
        return null;
    }

    protected void collectConfigTrait(MeasurementReport report, MeasurementScheduleRequest request) {
        String value = this.readEnvironmentAttribute(request);
        if (value != null) {
            MeasurementDataTrait data = new MeasurementDataTrait(request, new File(value).getName());
            report.addData(data);
        }
    }

    protected void collectEnvironmentTrait(MeasurementReport report, MeasurementScheduleRequest request) {
        String value = this.readEnvironmentAttribute(request);
        if (value != null) {
            MeasurementDataTrait data = new MeasurementDataTrait(request, value);
            report.addData(data);
        }
    }

    private String readEnvironmentAttribute(MeasurementScheduleRequest request) {
        try {
            return this.readAttribute(this.getEnvironmentAddress(), request.getName(), String.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to read attribute [" + request.getName() + "]: " + e), (Throwable)e);
            return null;
        }
    }

    private synchronized void setASHostName(String aSHostName) {
        this.aSHostName = aSHostName;
    }

    protected synchronized String getASHostName() {
        return this.aSHostName;
    }

    protected String findASDomainHostName() {
        if (this.getMode().equals((Object)AS7Mode.STANDALONE)) {
            return null;
        }
        return BaseServerComponent.findASDomainHostName(this.getASConnection());
    }

    public static String findASDomainHostName(ASConnection connection) {
        ReadAttribute op = new ReadAttribute(new Address(), "local-host-name");
        op.includeDefaults(true);
        Result result = connection.execute(op);
        if (result.isSuccess()) {
            return result.getResult().toString();
        }
        return null;
    }

    private HostConfiguration getHostConfig() {
        HostConfiguration hostConfig;
        File configFile;
        block4: {
            try {
                String config = this.readAttribute(this.getEnvironmentAddress(), this.getMode().getHostConfigAttributeName());
                configFile = new File(config);
            }
            catch (Exception e) {
                configFile = this.serverPluginConfig.getHostConfigFile();
                if (configFile != null) break block4;
                throw new RuntimeException("Failed to determine config file path.", e);
            }
        }
        try {
            hostConfig = new HostConfiguration(configFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse configuration file [" + configFile + "].", e);
        }
        return hostConfig;
    }

    private void collectServerKindTraits(MeasurementReport report, Set<MeasurementScheduleRequest> skmRequests) {
        Address address = new Address();
        ReadResource op = new ReadResource(address);
        op.includeRuntime(true);
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (res.isSuccess()) {
            Object props = res.getResult();
            for (MeasurementScheduleRequest request : skmRequests) {
                String requestName = request.getName();
                String realName = requestName.substring(requestName.indexOf(58) + 1);
                String val = null;
                if (props.containsKey(realName)) {
                    val = this.getStringValue(props.get(realName));
                }
                if ("null".equals(val)) {
                    if (realName.equals("product-name")) {
                        val = "JBoss AS";
                    } else if (realName.equals("product-version")) {
                        val = this.getStringValue(props.get("release-version"));
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Value for " + realName + " was 'null' and no replacement found"));
                    }
                }
                MeasurementDataTrait data = new MeasurementDataTrait(request, val);
                report.addData(data);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getSKMRequests failed: " + res.getFailureDescription()));
        }
    }

    protected String collectPatches() {
        Result result;
        ProcessExecutionResults results = ServerControl.onServer(this.context.getPluginConfiguration(), this.getMode(), this.context.getSystemInformation()).cli().disconnected(true).executeCliCommand("patch info");
        if (results.getError() != null) {
            LOG.info((Object)("Failed to determine the list of installed patches on " + this.context.getResourceDetails() + ". The execution of JBoss CLI failed."), results.getError());
            return null;
        }
        if (results.getExitCode() == null) {
            LOG.info((Object)("Failed to determine the list of installed patches on " + this.context.getResourceDetails() + ". The execution of JBoss CLI timed out."));
            return null;
        }
        if (results.getExitCode() != 0) {
            LOG.info((Object)("Failed to determine the list of installed patches on " + this.context.getResourceDetails() + ". The execution of JBoss CLI exited with code " + results.getExitCode() + "."));
            return null;
        }
        String json = results.getCapturedOutput();
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = (Result)mapper.readValue(json, Result.class);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to parse the output of the 'patch info' command with message '" + e.getMessage() + "'."), (Throwable)e);
            return null;
        }
        if (!result.isSuccess()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("'patch info' command didn't succeed: " + result));
            }
            return null;
        }
        if (!(result.getResult() instanceof Map)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unexpected patch info results. Expected map but found " + (result.getResult() == null ? "null" : result.getResult().getClass().toString())));
            }
            return null;
        }
        Map info = (Map)result.getResult();
        if (info.isEmpty()) {
            return null;
        }
        String cp = (String)info.get("cumulative-patch-id");
        List oneOffs = (List)info.get("patches");
        StringBuilder ret = new StringBuilder(cp);
        for (String oneOff : oneOffs) {
            ret.append(", ").append(oneOff);
        }
        return ret.toString();
    }
}

