/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.CreateResourceDelegate;
import org.rhq.modules.plugins.jbossas7.DatasourceComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DatasourcesComponent
extends BaseComponent<BaseComponent<?>> {
    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        String keyName;
        String connPropPluginConfigPropertyName;
        String connPropAttributeNameOnServer;
        ResourceType resourceType = report.getResourceType();
        ConfigurationDefinition configDef = resourceType.getResourceConfigurationDefinition().copy();
        Configuration config = report.getResourceConfiguration().deepCopy(false);
        PropertySimple enabledProperty = config.getSimple("enabled");
        Boolean enableDatasource = enabledProperty == null ? Boolean.TRUE : enabledProperty.getBooleanValue();
        configDef.getPropertyDefinitions().remove("enabled");
        config.remove("enabled");
        List validationErrors = ConfigurationUtility.validateConfiguration((Configuration)config, (ConfigurationDefinition)configDef);
        if (!validationErrors.isEmpty()) {
            report.setErrorMessage(validationErrors.toString());
            report.setStatus(CreateResourceStatus.FAILURE);
            return report;
        }
        CreateResourceDelegate delegate = new CreateResourceDelegate(configDef, this.getASConnection(), this.getAddress());
        report = delegate.createResource(report);
        if (report.getStatus() != CreateResourceStatus.SUCCESS) {
            return report;
        }
        Address datasourceAddress = new Address(report.getResourceKey());
        if (DatasourceComponent.isXADatasourceResource(resourceType)) {
            connPropAttributeNameOnServer = "xa-datasource-properties";
            connPropPluginConfigPropertyName = "*2";
            keyName = "key";
        } else {
            connPropAttributeNameOnServer = "connection-properties";
            connPropPluginConfigPropertyName = "*1";
            keyName = "pname";
        }
        PropertyList listPropertyWrapper = config.getList(connPropPluginConfigPropertyName);
        Map<String, String> connectionPropertiesAsMap = DatasourceComponent.getConnectionPropertiesAsMap(listPropertyWrapper, keyName);
        if (!connectionPropertiesAsMap.isEmpty()) {
            CompositeOperation cop = new CompositeOperation();
            for (Map.Entry<String, String> connectionProperty : connectionPropertiesAsMap.entrySet()) {
                Address propertyAddress = new Address(datasourceAddress);
                propertyAddress.add(connPropAttributeNameOnServer, connectionProperty.getKey());
                Operation op = new Operation("add", propertyAddress);
                op.addAdditionalProperty("value", connectionProperty.getValue());
                cop.addStep(op);
            }
            Result res = this.getASConnection().execute(cop);
            if (!res.isSuccess()) {
                report.setErrorMessage("Datasource was added, but setting " + connPropAttributeNameOnServer + " failed: " + res.getFailureDescription());
                report.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                return report;
            }
        }
        ReadAttribute readEnabledAttribute = new ReadAttribute(datasourceAddress, "enabled");
        Result readEnabledAttributeResult = this.getASConnection().execute(readEnabledAttribute);
        if (!readEnabledAttributeResult.isSuccess()) {
            report.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
            report.setErrorMessage("Datasource was added but the agent could not read its configuration: " + readEnabledAttributeResult.getFailureDescription());
            return report;
        }
        Boolean enabledPropertyCurrentValue = (Boolean)readEnabledAttributeResult.getResult();
        if (enabledPropertyCurrentValue != enableDatasource) {
            Result result;
            Operation operation;
            if (enableDatasource == Boolean.TRUE) {
                operation = new Operation("enable", datasourceAddress);
                result = this.getASConnection().execute(operation);
                if (!result.isSuccess()) {
                    report.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                    report.setErrorMessage("Datasource was added but not enabled: " + result.getFailureDescription());
                }
            } else {
                operation = new Operation("disable", datasourceAddress);
                result = this.getASConnection().execute(operation);
                if (!result.isSuccess()) {
                    report.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                    report.setErrorMessage("Datasource was added but not disabled: " + result.getFailureDescription());
                }
            }
        }
        return report;
    }
}

