/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.content.FileContentDelegate;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.Base64;
import org.rhq.core.util.ByteUtil;
import org.rhq.core.util.file.JarContentFileInfo;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.DomainDeploymentComponent;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.Redeployer;
import org.rhq.modules.plugins.jbossas7.ServerGroupComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DeploymentComponent
extends BaseComponent<ResourceComponent<?>>
implements OperationFacet,
ContentFacet {
    private static final String DOMAIN_DATA_CONTENT_SUBDIR = "/data/content";
    private File deploymentFile;

    @Override
    public void start(ResourceContext<ResourceComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        super.start(context);
        this.deploymentFile = this.determineDeploymentFile();
    }

    @Override
    public AvailabilityType getAvailability() {
        ReadResource op = new ReadResource(this.getAddress());
        Result res = this.getASConnection().execute((Operation)op, 60);
        if (!res.isSuccess()) {
            if (res.isTimedout()) {
                return AvailabilityType.UNKNOWN;
            }
            if (res.getFailureDescription() != null && res.getFailureDescription().toLowerCase().contains("not found")) {
                DeploymentComponent.getLog().debug((Object)("Reporting MISSING resource: " + this.getPath()));
                return AvailabilityType.MISSING;
            }
            return AvailabilityType.DOWN;
        }
        if (res.getResult() == null) {
            return AvailabilityType.DOWN;
        }
        Map results = (Map)res.getResult();
        if (results.get("enabled") == null || !((Boolean)results.get("enabled")).booleanValue()) {
            return AvailabilityType.DOWN;
        }
        return AvailabilityType.UP;
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("enable")) {
            return this.invokeSimpleOperation("deploy");
        }
        if (name.equals("disable")) {
            return this.invokeSimpleOperation("undeploy");
        }
        if (name.equals("restart")) {
            OperationResult result = this.invokeSimpleOperation("undeploy");
            if (result.getErrorMessage() == null) {
                result = this.invokeSimpleOperation("deploy");
            }
            return result;
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult invokeSimpleOperation(String action) {
        Operation op = new Operation(action, this.getAddress());
        Result res = this.getASConnection().execute(op);
        OperationResult result = new OperationResult();
        if (res.isSuccess()) {
            result.setSimpleResult("Success");
            if ("enable".equals(action)) {
                this.context.getAvailabilityContext().enable();
            }
            if ("disable".equals(action)) {
                this.context.getAvailabilityContext().disable();
            }
        } else {
            result.setErrorMessage(res.getFailureDescription());
        }
        return result;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return new ArrayList<DeployPackageStep>();
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        DeploymentComponent.getLog().debug((Object)"Starting deployment..");
        DeployPackagesResponse response = new DeployPackagesResponse();
        if (packages.size() != 1) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Can only deploy one package at a time");
            DeploymentComponent.getLog().warn((Object)"deployPackages can only deploy one package at a time");
        }
        ResourcePackageDetails detail = packages.iterator().next();
        ASUploadConnection uploadConnection = new ASUploadConnection(this.getServerComponent().getASConnection(), detail.getKey().getName());
        OutputStream out = uploadConnection.getOutputStream();
        if (out == null) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("An error occured while the agent was preparing for content download");
            return response;
        }
        ResourceType resourceType = this.context.getResourceType();
        DeploymentComponent.getLog().info((Object)("Deploying " + resourceType.getName() + " Resource with key [" + detail.getKey() + "]..."));
        try {
            contentServices.downloadPackageBits(this.context.getContentContext(), detail.getKey(), out, true);
        }
        catch (Exception e) {
            uploadConnection.cancelUpload();
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("An error occured while the agent was downloading the content");
            return response;
        }
        JsonNode uploadResult = uploadConnection.finishUpload();
        if (ASConnection.verbose) {
            DeploymentComponent.getLog().info((Object)uploadResult);
        }
        if (ASUploadConnection.isErrorReply(uploadResult)) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage(ASUploadConnection.getFailureDescription(uploadResult));
            return response;
        }
        JsonNode resultNode = uploadResult.get("result");
        String hash = resultNode.get("BYTES_VALUE").getTextValue();
        try {
            Redeployer redeployer = new Redeployer(detail.getKey().getName(), hash, this.getASConnection());
            Result result = redeployer.redeployOnServer();
            if (result.isRolledBack()) {
                response.setOverallRequestResult(ContentResponseResult.FAILURE);
                response.setOverallRequestErrorMessage("Rolled Back: " + result.getFailureDescription());
            } else {
                response.setOverallRequestResult(ContentResponseResult.SUCCESS);
                this.deploymentFile = this.determineDeploymentFile();
                DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(detail.getKey(), ContentResponseResult.SUCCESS);
                response.addPackageResponse(packageResponse);
            }
        }
        catch (Exception e) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage(e.getMessage());
        }
        ContentResponseResult result = response.getOverallRequestResult();
        DeploymentComponent.getLog().info((Object)("Result of deployment of " + resourceType.getName() + " Resource with key [" + detail.getKey() + "]: " + (ContentResponseResult.SUCCESS == result ? result.name() : result.name() + ": " + response.getOverallRequestErrorMessage())));
        return response;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        RemovePackagesResponse response = new RemovePackagesResponse(ContentResponseResult.NOT_PERFORMED);
        response.setOverallRequestErrorMessage("Removal of packages backing the deployments is not supported.");
        return response;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        if (this.deploymentFile == null) {
            return Collections.emptySet();
        }
        String name = this.getDeploymentName();
        String sha256 = this.getSHA256(this.deploymentFile);
        String version = DeploymentComponent.getVersion(sha256);
        PackageDetailsKey key = new PackageDetailsKey(name, version, type.getName(), "noarch");
        ResourcePackageDetails details = new ResourcePackageDetails(key);
        details.setDisplayVersion(this.getDisplayVersion(this.deploymentFile));
        details.setFileCreatedDate(null);
        details.setFileName(name);
        details.setFileSize(Long.valueOf(this.deploymentFile.length()));
        details.setInstallationTimestamp(this.deploymentFile.lastModified());
        details.setLocation(this.deploymentFile.getAbsolutePath());
        details.setSHA256(sha256);
        return Collections.singleton(details);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        try {
            return this.deploymentFile == null ? new ByteArrayInputStream(new byte[0]) : new FileInputStream(this.deploymentFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Deployment file seems to have disappeared");
        }
    }

    private File determineDeploymentFile() {
        Boolean archive;
        Operation op = new ReadAttribute(this.getAddress(), "content");
        Result result = this.getASConnection().execute(op);
        List content = (List)result.getResult();
        if (content == null || content.isEmpty()) {
            if (this.path.startsWith("server-group=")) {
                String name = this.path.substring(this.path.lastIndexOf("=") + 1);
                op = new ReadResource(new Address("deployment", name));
                result = this.getASConnection().execute(op);
                if (result.isSuccess()) {
                    Map contentMap = (Map)result.getResult();
                    content = (List)contentMap.get("content");
                    if (((Map)content.get(0)).containsKey("path")) {
                        String path = (String)((Map)content.get(0)).get("path");
                        String relativeTo = (String)((Map)content.get(0)).get("relative-to");
                        this.deploymentFile = this.getDeploymentFileFromPath(relativeTo, path);
                    } else if (((Map)content.get(0)).containsKey("hash")) {
                        String base64Hash = (String)((Map)((Map)content.get(0)).get("hash")).get("BYTES_VALUE");
                        byte[] hash = Base64.decode((String)base64Hash);
                        ServerGroupComponent sgc = (ServerGroupComponent)this.context.getParentResourceComponent();
                        String baseDir = ((HostControllerComponent)sgc.context.getParentResourceComponent()).pluginConfiguration.getSimpleValue("baseDir");
                        String contentPath = new File(baseDir, DOMAIN_DATA_CONTENT_SUBDIR).getAbsolutePath();
                        this.deploymentFile = this.getDeploymentFileFromHash(hash, contentPath);
                    }
                    return this.deploymentFile;
                }
            } else {
                DeploymentComponent.getLog().warn((Object)("Could not determine the location of the deployment - the content descriptor wasn't found for deployment" + this.getAddress() + "."));
                return null;
            }
        }
        if ((archive = (Boolean)((Map)content.get(0)).get("archive")) != null && !archive.booleanValue()) {
            DeploymentComponent.getLog().debug((Object)"Exploded deployments not supported for retrieving the content.");
            return null;
        }
        File deploymentFile = null;
        if (((Map)content.get(0)).containsKey("path")) {
            String path = (String)((Map)content.get(0)).get("path");
            String relativeTo = (String)((Map)content.get(0)).get("relative-to");
            deploymentFile = this.getDeploymentFileFromPath(relativeTo, path);
        } else if (((Map)content.get(0)).containsKey("hash")) {
            String contentPath;
            Address contentPathAddress;
            String base64Hash = (String)((Map)((Map)content.get(0)).get("hash")).get("BYTES_VALUE");
            byte[] hash = Base64.decode((String)base64Hash);
            if (this.context.getParentResourceComponent() instanceof ManagedASComponent) {
                String p = ((ManagedASComponent)this.context.getParentResourceComponent()).getPath();
                p = p.replaceAll("server-config=", "server=");
                contentPathAddress = new Address(p);
                contentPathAddress.add("core-service", "server-environment");
            } else {
                contentPathAddress = new Address("core-service", "server-environment");
            }
            op = new ReadAttribute(contentPathAddress, "content-dir");
            result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                contentPath = (String)result.getResult();
            } else if (this instanceof DomainDeploymentComponent) {
                String baseDir = ((HostControllerComponent)this.context.getParentResourceComponent()).pluginConfiguration.getSimpleValue("baseDir");
                contentPath = new File(baseDir, DOMAIN_DATA_CONTENT_SUBDIR).getAbsolutePath();
            } else {
                contentPath = "-unknown-";
            }
            deploymentFile = this.getDeploymentFileFromHash(hash, contentPath);
        } else {
            DeploymentComponent.getLog().warn((Object)("Failed to determine the deployment file of " + this.getAddress() + " deployment. Neither path nor hash attributes were available."));
        }
        return deploymentFile;
    }

    private File getDeploymentFileFromPath(String relativeTo, String path) {
        if (relativeTo == null || relativeTo.trim().isEmpty()) {
            return new File(path);
        }
        if (relativeTo.startsWith("jboss.server")) {
            relativeTo = relativeTo.substring("jboss.server.".length());
            relativeTo = relativeTo.replace('.', '-');
            ReadAttribute op = new ReadAttribute(new Address("core-service", "server-environment"), relativeTo);
            Result res = this.getASConnection().execute(op);
            relativeTo = (String)res.getResult();
            return new File(relativeTo, path);
        }
        DeploymentComponent.getLog().warn((Object)("Unsupported property used as a base for deployment path specification: " + relativeTo));
        return null;
    }

    private File getDeploymentFileFromHash(byte[] hash, String contentPath) {
        String hashStr = ByteUtil.toHexString((byte[])hash);
        String head = hashStr.substring(0, 2);
        String tail = hashStr.substring(2);
        File hashPath = new File(new File(head, tail), "content");
        return new File(contentPath, hashPath.getPath());
    }

    private String getSHA256(File file) {
        String sha256;
        block2: {
            sha256 = null;
            try {
                FileContentDelegate fileContentDelegate = new FileContentDelegate();
                sha256 = fileContentDelegate.retrieveDeploymentSHA(file, this.context.getResourceDataDirectory());
            }
            catch (Exception iex) {
                if (!DeploymentComponent.getLog().isDebugEnabled()) break block2;
                DeploymentComponent.getLog().debug((Object)("Problem calculating digest of package [" + file.getPath() + "]." + iex.getMessage()));
            }
        }
        return sha256;
    }

    private static String getVersion(String sha256) {
        return "[sha256=" + sha256 + "]";
    }

    private String getDisplayVersion(File file) {
        JarContentFileInfo contentFileInfo = new JarContentFileInfo(file);
        return contentFileInfo.getVersion(null);
    }

    private String getDeploymentName() {
        ReadAttribute op = new ReadAttribute(this.getAddress(), "name");
        Result res = this.getASConnection().execute(op);
        return (String)res.getResult();
    }
}

