/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DomainDeploymentDiscovery
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        Address addr;
        Result result;
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        HostControllerComponent hostController = (HostControllerComponent)context.getParentResourceComponent();
        if (!hostController.isDomainController()) {
            return details;
        }
        ASConnection connection = hostController.getASConnection();
        Configuration config = context.getDefaultPluginConfiguration();
        String confPath = config.getSimpleValue("path", "");
        if (confPath == null || confPath.isEmpty()) {
            this.log.error((Object)("Path plugin config is null for ResourceType [" + context.getResourceType().getName() + "]."));
            return details;
        }
        String parentPath = hostController.getPath();
        if (parentPath == null || parentPath.isEmpty()) {
            parentPath = "";
        }
        String path = parentPath;
        if (ASConnection.verbose) {
            this.log.info((Object)("total path: [" + path + "]"));
        }
        if ((result = connection.execute(new ReadChildrenNames(addr = new Address(parentPath), confPath))).isSuccess()) {
            List deployments = (List)result.getResult();
            for (String val : deployments) {
                String resKey;
                String newPath = confPath + "=" + val;
                Configuration config2 = context.getDefaultPluginConfiguration();
                if (path == null || path.isEmpty()) {
                    resKey = newPath;
                } else {
                    if (path.startsWith(",")) {
                        path = path.substring(1);
                    }
                    resKey = path + "," + confPath + "=" + val;
                }
                PropertySimple pathProp = new PropertySimple("path", (Object)resKey);
                config2.put((Property)pathProp);
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), resKey, val, null, context.getResourceType().getDescription(), config2, null);
                details.add(detail);
            }
        }
        return details;
    }
}

