/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.util.OSGiVersion;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class Ejb3BeanRuntimeComponent
extends BaseComponent<BaseComponent<?>> {
    private static final String METHODS_ATTRIBUTE = "methods";
    private static final int CALLTIME_METRIC_NAME_PREFIX_LENGTH = "__calltime:".length();
    private static final Address RUNTIME_MBEAN_ADDRESS = new Address("core-service=platform-mbean,type=runtime");
    private static final String START_TIME_ATTRIBUTE = "start-time";
    private static final OSGiVersion FIRST_VERSION_SUPPORTING_METHOD_STATS = new OSGiVersion("7.2.1");
    private OSGiVersion asVersion = null;
    private Boolean ejb3StatisticsEnalbed = null;

    @Override
    public AvailabilityType getAvailability() {
        AvailabilityType avail = super.getAvailability();
        if (avail == AvailabilityType.DOWN) {
            this.asVersion = null;
        }
        return avail;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Set<MeasurementScheduleRequest> metricsToPassDown = metrics;
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getDataType() != DataType.CALLTIME) continue;
            this.ensureGlobalEJB3StatisticsEnabled();
            if (metricsToPassDown == metrics) {
                metricsToPassDown = new HashSet<MeasurementScheduleRequest>(metrics);
            }
            metricsToPassDown.remove(request);
            Result result = this.getASConnection().execute(new ReadAttribute(this.address, METHODS_ATTRIBUTE));
            Object value = result.getResult();
            if (value instanceof Map) {
                Map allMethodStats = (Map)value;
                if (allMethodStats.isEmpty()) continue;
                result = this.getASConnection().execute(new ReadAttribute(RUNTIME_MBEAN_ADDRESS, START_TIME_ATTRIBUTE));
                long serverStartTime = (Long)result.getResult();
                String requestedMetric = request.getName().substring(CALLTIME_METRIC_NAME_PREFIX_LENGTH);
                Stats lastCollection = this.getLastCallTimeCollection(requestedMetric, allMethodStats, serverStartTime);
                Stats thisCollection = Stats.fromMap(allMethodStats, requestedMetric, System.currentTimeMillis(), serverStartTime);
                CallTimeData callTime = new CallTimeData(request);
                this.fillCallTimeData(callTime, thisCollection, lastCollection);
                this.saveCallTimeCollection(requestedMetric, thisCollection);
                report.addData(callTime);
                continue;
            }
            OSGiVersion currentAsVersion = this.getASVersion();
            if (currentAsVersion == null) {
                Ejb3BeanRuntimeComponent.getLog().warn((Object)("Could not determine the AS version while reporting unexpected result of method stats. Request: " + request));
                continue;
            }
            if (FIRST_VERSION_SUPPORTING_METHOD_STATS.compareTo(currentAsVersion) > 0) continue;
            Ejb3BeanRuntimeComponent.getLog().error((Object)("Unexpected type of results when querying method stats for measurement request " + request + ". Expected map but got " + (value == null ? "null" : value.getClass().getName())));
        }
        super.getValues(report, metricsToPassDown);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stats getLastCallTimeCollection(String requestName, Map<String, Map<String, Number>> fallbackValues, long fallbackStartTime) throws IOException {
        Stats stats;
        File dataFile = new File(this.context.getResourceDataDirectory(), requestName);
        if (!dataFile.exists()) {
            return Stats.fromMap(fallbackValues, requestName, System.currentTimeMillis(), fallbackStartTime);
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(dataFile));
            Stats stats2 = (Stats)in.readObject();
            if (stats2.serverStartTime == 0L) {
                stats2.serverStartTime = fallbackStartTime;
            }
            stats = stats2;
        }
        catch (IOException e) {
            try {
                throw new IOException("Couldn't read the stored calltime data from file " + dataFile + ".", e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalStateException("Couldn't find plugin API classes. This is serious!", e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(in);
                throw throwable;
            }
        }
        StreamUtil.safeClose((Closeable)in);
        return stats;
    }

    private void saveCallTimeCollection(String requestName, Stats stats) throws IOException {
        File dataFile = new File(this.context.getResourceDataDirectory(), requestName);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(dataFile));
            out.writeObject(stats);
        }
        catch (IOException e) {
            try {
                throw new IOException("Couldn't write the last collected calltime data to file " + dataFile + ".", e);
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(out);
                throw throwable;
            }
        }
        StreamUtil.safeClose((Closeable)out);
    }

    private void fillCallTimeData(CallTimeData callTimeData, Stats stats, Stats previousStats) {
        Date startDate = new Date(previousStats.collectionTime);
        Date endDate = new Date(stats.collectionTime);
        boolean serverRestarted = stats.serverStartTime != previousStats.serverStartTime;
        for (Map.Entry<String, StatsRecord> entry : stats.data.entrySet()) {
            long total;
            long invocations;
            String methodName = entry.getKey();
            StatsRecord thisStatsRecord = entry.getValue();
            if (serverRestarted) {
                invocations = thisStatsRecord.invocations;
                total = thisStatsRecord.total;
            } else {
                StatsRecord previousStatsRecord = previousStats.data.get(methodName);
                long oldInvocations = previousStatsRecord != null ? previousStatsRecord.invocations : 0L;
                invocations = thisStatsRecord.invocations - oldInvocations;
                long oldTotal = previousStatsRecord != null ? previousStatsRecord.total : 0L;
                total = thisStatsRecord.total - oldTotal;
            }
            if (invocations == 0L) continue;
            double min = (double)total / (double)invocations;
            double max = (double)total / (double)invocations;
            callTimeData.addAggregatedCallData(methodName, startDate, endDate, min, max, (double)total, invocations);
        }
    }

    private OSGiVersion getASVersion() {
        if (this.asVersion == null) {
            ResourceComponent base = this.context.getParentResourceComponent();
            while (base != null && base instanceof BaseComponent && !(base instanceof BaseServerComponent)) {
                base = ((BaseComponent)base).context.getParentResourceComponent();
            }
            if (base != null && base instanceof BaseServerComponent) {
                String version = ((BaseServerComponent)base).getReleaseVersion();
                this.asVersion = new OSGiVersion(version);
            }
        }
        return this.asVersion;
    }

    private void ensureGlobalEJB3StatisticsEnabled() {
        if (this.ejb3StatisticsEnalbed != null && this.ejb3StatisticsEnalbed.booleanValue()) {
            return;
        }
        BaseServerComponent server = this.getServerComponent();
        Address ejbAddress = new Address(server.getServerAddress());
        ejbAddress.add("subsystem", "ejb3");
        try {
            this.ejb3StatisticsEnalbed = this.readAttribute(ejbAddress, "enable-statistics", Boolean.class);
            if (!Boolean.TRUE.equals(this.ejb3StatisticsEnalbed)) {
                Ejb3BeanRuntimeComponent.getLog().debug((Object)"Enabling global EJB3 statistics");
                WriteAttribute op = new WriteAttribute(ejbAddress, "enable-statistics", true);
                Result result = this.getASConnection().execute(op);
                if (result.isSuccess()) {
                    Ejb3BeanRuntimeComponent.getLog().info((Object)(server.context.getResourceDetails() + " Global EJB3 statistics is now enabled, because there is a request to collect EJB Calltime metrics."));
                } else {
                    Ejb3BeanRuntimeComponent.getLog().error((Object)("Failed to enable EJB3 statistics : " + result.getFailureDescription()));
                }
            }
        }
        catch (Exception e) {
            Ejb3BeanRuntimeComponent.getLog().error((Object)"Failed to read and enable EJB3 statistics", (Throwable)e);
        }
    }

    private static class Stats
    implements Serializable {
        private static final long serialVersionUID = 1L;
        long serverStartTime;
        long collectionTime;
        Map<String, StatsRecord> data;

        private Stats() {
        }

        static Stats fromMap(Map<String, Map<String, Number>> map, String collectedMetric, long collectionTime, long serverStartTime) {
            Stats ret = new Stats();
            ret.serverStartTime = serverStartTime;
            ret.collectionTime = collectionTime;
            ret.data = new HashMap<String, StatsRecord>(map.size());
            for (Map.Entry<String, Map<String, Number>> entry : map.entrySet()) {
                StatsRecord rec = new StatsRecord();
                String methodName = entry.getKey();
                rec.invocations = entry.getValue().get("invocations").longValue();
                rec.total = entry.getValue().get(collectedMetric).longValue();
                ret.data.put(methodName, rec);
            }
            return ret;
        }
    }

    private static class StatsRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        long invocations;
        long total;

        private StatsRecord() {
        }
    }
}

