/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.bundle.BundleHandoverRequest;
import org.rhq.core.pluginapi.bundle.BundleHandoverResponse;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.HandoverContentUploader;
import org.rhq.modules.plugins.jbossas7.ManagedASDiscovery;
import org.rhq.modules.plugins.jbossas7.Redeployer;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class HostControllerComponent<T extends ResourceComponent<?>>
extends BaseServerComponent<T>
implements MeasurementFacet,
OperationFacet {
    private static final Log LOG = LogFactory.getLog(HostControllerComponent.class);
    private static final String DOMAIN_CONFIG_TRAIT = "domain-config-file";
    private static final String HOST_CONFIG_TRAIT = "host-config-file";
    private static final String DOMAIN_HOST_TRAIT = "domain-host-name";
    private static final String DOMAIN_NAME_TRAIT = "domain-name";
    private static final String DOMAIN_TEMP_DIR_TRAIT = "domain-temp-dir";
    private static final String PROCESS_TYPE_DC = "Domain Controller";
    private boolean domainController;

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.DOMAIN;
    }

    @Override
    public void start(ResourceContext<T> resourceContext) throws Exception {
        super.start(resourceContext);
        this.setDomainController(PROCESS_TYPE_DC.equals(this.getProcessTypeAttrValue()));
    }

    @Override
    protected void onAvailGoesUp() {
        super.onAvailGoesUp();
        this.setDomainController(PROCESS_TYPE_DC.equals(this.getProcessTypeAttrValue()));
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            MeasurementDataTrait data;
            String requestName = request.getName();
            if (requestName.equals(DOMAIN_CONFIG_TRAIT) || requestName.equals(HOST_CONFIG_TRAIT)) {
                this.collectConfigTrait(report, request);
                continue;
            }
            if (requestName.equals(DOMAIN_HOST_TRAIT)) {
                data = new MeasurementDataTrait(request, this.findASDomainHostName());
                report.addData(data);
                continue;
            }
            if (requestName.equals(DOMAIN_NAME_TRAIT)) {
                data = new MeasurementDataTrait(request, this.readAttribute("name"));
                report.addData(data);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        OperationResult operationResult;
        if (name.equals("start")) {
            operationResult = this.startServer();
        } else if (name.equals("restart")) {
            operationResult = this.restartServer(parameters);
        } else {
            if (name.equals("executeCommands") || name.equals("executeScript")) {
                return this.runCliCommand(parameters);
            }
            if (name.equals("shutdown")) {
                String domainHost = this.getASHostName();
                if (domainHost.isEmpty()) {
                    OperationResult result = new OperationResult();
                    result.setErrorMessage("No domain host found - can not continue");
                    operationResult = result;
                }
                Operation op = new Operation("shutdown", "host", domainHost);
                Result res = this.getASConnection().execute(op);
                operationResult = this.postProcessResult(name, res);
                if (this.waitUntilDown()) {
                    operationResult.setSimpleResult("Success");
                } else {
                    operationResult.setErrorMessage("Was not able to shut down the server.");
                }
            } else {
                operationResult = name.equals("installRhqUser") ? this.installManagementUser(parameters, this.pluginConfiguration) : super.invokeOperation(name, parameters);
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        String socketBindingGroup;
        Operation op;
        Address targetAddress;
        if (report.getPackageDetails() != null) {
            return super.deployContent(report);
        }
        String targetTypeName = report.getResourceType().getName();
        String resourceName = report.getUserSpecifiedResourceName();
        Configuration rc = report.getResourceConfiguration();
        if (targetTypeName.equals("ServerGroup")) {
            PropertySimple jvm;
            targetAddress = new Address();
            targetAddress.add("server-group", resourceName);
            op = new Operation("add", targetAddress);
            String profile = rc.getSimpleValue("profile", "");
            if (profile.isEmpty()) {
                report.setErrorMessage("No profile given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("profile", profile);
            socketBindingGroup = rc.getSimpleValue("socket-binding-group", "");
            if (socketBindingGroup.isEmpty()) {
                report.setErrorMessage("No socket-binding-group given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("socket-binding-group", socketBindingGroup);
            PropertySimple offset = rc.getSimple("socket-binding-port-offset");
            if (offset != null && offset.getStringValue() != null) {
                op.addAdditionalProperty("socket-binding-port-offset", offset.getIntegerValue());
            }
            if ((jvm = rc.getSimple("jvm")) != null) {
                op.addAdditionalProperty("jvm", jvm.getStringValue());
            }
        } else if (targetTypeName.equals("Managed Server")) {
            String targetHost = rc.getSimpleValue("hostname", null);
            if (targetHost == null) {
                report.setErrorMessage("No domain host given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            targetAddress = new Address("host", targetHost);
            targetAddress.add("server-config", resourceName);
            op = new Operation("add", targetAddress);
            socketBindingGroup = rc.getSimpleValue("socket-binding-group", "");
            if (socketBindingGroup.isEmpty()) {
                report.setErrorMessage("No socket-binding-group given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("socket-binding-group", socketBindingGroup);
            String autostartS = rc.getSimpleValue("auto-start", "false");
            boolean autoStart = Boolean.valueOf(autostartS);
            op.addAdditionalProperty("auto-start", autoStart);
            String portS = rc.getSimpleValue("socket-binding-port-offset", "0");
            int portOffset = Integer.parseInt(portS);
            op.addAdditionalProperty("socket-binding-port-offset", portOffset);
            String serverGroup = rc.getSimpleValue("group", null);
            if (serverGroup == null) {
                report.setErrorMessage("No server group given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("group", serverGroup);
        } else {
            if (targetTypeName.equals("JVM-Definition")) {
                return super.createResource(report);
            }
            throw new IllegalArgumentException("Don't know yet how to create instances of " + targetTypeName);
        }
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            PropertyList sysProperties;
            if (targetTypeName.equals("Managed Server")) {
                report.setResourceKey(ManagedASDiscovery.createResourceKey(rc.getSimpleValue("hostname"), report.getUserSpecifiedResourceName()));
            } else {
                report.setResourceKey(targetAddress.getPath());
            }
            report.setResourceName(resourceName);
            report.setStatus(CreateResourceStatus.SUCCESS);
            if (targetTypeName.equals("ServerGroup") && (sysProperties = rc.getList("*2")) != null && !sysProperties.getList().isEmpty()) {
                ConfigurationUpdateReport rep = new ConfigurationUpdateReport(rc);
                ConfigurationDefinition configDef = report.getResourceType().getResourceConfigurationDefinition();
                ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.getASConnection(), targetAddress);
                delegate.updateResourceConfiguration(rep);
                if (ConfigurationUpdateStatus.FAILURE.equals((Object)rep.getStatus())) {
                    report.setStatus(CreateResourceStatus.FAILURE);
                    report.setErrorMessage("Failed to additionally configure server group: " + rep.getErrorMessage());
                }
            }
        } else {
            report.setErrorMessage(res.getFailureDescription());
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setException(res.getRhqThrowable());
        }
        return report;
    }

    public BundleHandoverResponse handleContent(BundleHandoverRequest handoverRequest) {
        try {
            if (handoverRequest.getAction().equals("deployment")) {
                return this.handleDeployment(handoverRequest);
            }
            if (handoverRequest.getAction().equals("execute-script")) {
                return this.handleExecuteScript(handoverRequest);
            }
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.INVALID_ACTION);
        }
        catch (Exception e) {
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)"Unexpected handover failure", (Throwable)e);
        }
    }

    private BundleHandoverResponse handleDeployment(BundleHandoverRequest handoverRequest) {
        String hash;
        String serverGroup = (String)handoverRequest.getParams().get("serverGroup");
        if (StringUtil.isBlank((String)serverGroup)) {
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.MISSING_PARAMETER, (String)"serverGroup parameter is missing");
        }
        HandoverContentUploader contentUploader = new HandoverContentUploader(handoverRequest, this.getASConnection());
        boolean uploaded = contentUploader.upload();
        if (!uploaded) {
            return contentUploader.getFailureResponse();
        }
        String filename = contentUploader.getFilename();
        String runtimeName = contentUploader.getRuntimeName();
        Redeployer redeployer = new Redeployer(runtimeName, hash = contentUploader.getHash(), this.getASConnection());
        if (redeployer.deploymentExists()) {
            Result result = redeployer.redeployOnServer();
            if (result.isRolledBack()) {
                return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)result.getFailureDescription());
            }
            return BundleHandoverResponse.success();
        }
        Operation addDeploymentStep = new Operation("add", "deployment", filename);
        ArrayList addDeploymentContentProperty = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
        addDeploymentContentProperty.add(contentValues);
        addDeploymentStep.addAdditionalProperty("content", addDeploymentContentProperty);
        addDeploymentStep.addAdditionalProperty("name", filename);
        addDeploymentStep.addAdditionalProperty("runtime-name", runtimeName);
        Address serverGroupDeploymentAddress = new Address();
        serverGroupDeploymentAddress.add("server-group", serverGroup);
        serverGroupDeploymentAddress.add("deployment", filename);
        Operation addToServerGroupStep = new Operation("add", serverGroupDeploymentAddress);
        addToServerGroupStep.addAdditionalProperty("runtime-name", runtimeName);
        addToServerGroupStep.addAdditionalProperty("enabled", true);
        CompositeOperation compositeOperation = new CompositeOperation();
        compositeOperation.addStep(addDeploymentStep);
        compositeOperation.addStep(addToServerGroupStep);
        Result result = this.getASConnection().execute((Operation)compositeOperation, 300);
        if (!result.isSuccess()) {
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)result.getFailureDescription());
        }
        return BundleHandoverResponse.success();
    }

    private String getProcessTypeAttrValue() {
        try {
            return this.readAttribute(new Address("/"), "process-type");
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to detect HostController's process-type", (Throwable)e);
            return null;
        }
    }

    public synchronized boolean isDomainController() {
        return this.domainController;
    }

    public synchronized void setDomainController(boolean domainController) {
        this.domainController = domainController;
    }

    @Override
    @NotNull
    protected Address getEnvironmentAddress() {
        return new Address("host=" + this.getASHostName() + ",core-service=host-environment");
    }

    @Override
    @NotNull
    protected Address getHostAddress() {
        return new Address("host=" + this.getASHostName());
    }

    @Override
    @NotNull
    protected String getBaseDirAttributeName() {
        return "domain-base-dir";
    }

    @Override
    @NotNull
    protected String getConfigDirAttributeName() {
        return "domain-config-dir";
    }

    @Override
    protected String getTempDirAttributeName() {
        return DOMAIN_TEMP_DIR_TRAIT;
    }
}

