/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ModuleOptionsComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ModuleOptionsDiscoveryComponent
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private static final Log LOG = LogFactory.getLog(ModuleOptionsDiscoveryComponent.class);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        ASConnection connection = parentComponent.getASConnection();
        Configuration config = context.getDefaultPluginConfiguration();
        String confPath = config.getSimpleValue("path", "");
        if (confPath == null || confPath.isEmpty()) {
            LOG.error((Object)("Path plugin config is null for ResourceType [" + context.getResourceType().getName() + "]."));
            return details;
        }
        Configuration configParent = parentComponent.pluginConfiguration;
        String parentConfPath = configParent.getSimpleValue("path", "");
        String path = confPath;
        if (parentConfPath != null && !parentConfPath.isEmpty()) {
            path = parentConfPath + "," + confPath;
        }
        Address address = new Address(path);
        if (path.endsWith("security-domain")) {
            Address typeAddress = new Address(path);
            String childType = "security-domain";
            Result result = connection.execute(new ReadChildrenNames(typeAddress, childType));
            if (result.isSuccess()) {
                List children = (List)result.getResult();
                Iterator i$ = children.iterator();
                while (i$.hasNext()) {
                    String child;
                    String name = child = (String)i$.next();
                    String currentChildPath = path + "=" + child;
                    address = new Address(currentChildPath);
                    this.addDiscoveredResource(context, details, connection, currentChildPath, name, address);
                }
            }
        } else if (this.ifResourceIsSupportedModuleType(path)) {
            String typeAddress = parentConfPath;
            String attribute = this.lookupAttributeType(path);
            ReadAttribute readModuleOptionType = new ReadAttribute(new Address(typeAddress), attribute);
            Result result = connection.execute(readModuleOptionType);
            if (result.isSuccess()) {
                List<ModuleOptionsComponent.Value> loadedLoginModuleTypes = ModuleOptionsComponent.populateSecurityDomainModuleOptions(result, ModuleOptionsComponent.loadModuleOptionType(attribute));
                for (int moduleIndex = 0; moduleIndex < loadedLoginModuleTypes.size(); ++moduleIndex) {
                    String name = ModuleOptionsComponent.ModuleOptionType.readableNameMap.get(attribute) + " " + moduleIndex;
                    String currentPath = path + ":" + moduleIndex;
                    this.addDiscoveredResource(context, details, connection, currentPath, name, address);
                }
            }
        } else if (path.endsWith("module-options")) {
            String name = "Module Options";
            this.addDiscoveredResource(context, details, connection, path, name, address);
        } else {
            String name = context.getResourceType().getName();
            this.addDiscoveredResource(context, details, connection, path, name, address);
        }
        return details;
    }

    private String lookupAttributeType(String path) {
        String[] segments;
        String attribute = null;
        if (path != null && !path.trim().isEmpty() && (segments = COMMA_PATTERN.split(path)).length > 1) {
            String last = segments[segments.length - 1];
            if (ModuleOptionsComponent.ModuleOptionType.typeMap.keySet().contains(last)) {
                attribute = last;
            }
        }
        return attribute;
    }

    private boolean ifResourceIsSupportedModuleType(String path) {
        String[] segments;
        boolean resourceIsSupported = false;
        if (path != null && !path.trim().isEmpty() && (segments = COMMA_PATTERN.split(path)).length > 1) {
            String last = segments[segments.length - 1];
            if (ModuleOptionsComponent.ModuleOptionType.typeMap.keySet().contains(last)) {
                resourceIsSupported = true;
            }
        }
        return resourceIsSupported;
    }

    private void addDiscoveredResource(ResourceDiscoveryContext context, Set<DiscoveredResourceDetails> details, ASConnection connection, String path, String name, Address address) {
        ReadResource op = new ReadResource(address);
        Result result = connection.execute(op);
        if (result.isSuccess()) {
            Configuration config2 = context.getDefaultPluginConfiguration();
            PropertySimple pathProp = new PropertySimple("path", (Object)path);
            config2.put((Property)pathProp);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), path, name, null, context.getResourceType().getDescription(), config2, null);
            details.add(detail);
        }
    }
}

