/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.Result;

class Redeployer {
    private final String runtimeName;
    private final String hash;
    private final ASConnection connection;

    Redeployer(String runtimeName, String hash, ASConnection connection) {
        this.runtimeName = runtimeName;
        this.hash = hash;
        this.connection = connection;
    }

    boolean deploymentExists() {
        Result deploymentResources = this.connection.execute(new ReadChildrenResources(new Address(), "deployment"));
        for (Map.Entry deploymentResource : ((Map)deploymentResources.getResult()).entrySet()) {
            Map deploymentResourceDetails = (Map)deploymentResource.getValue();
            if (!this.runtimeName.equals(deploymentResourceDetails.get("runtime-name"))) continue;
            return true;
        }
        return false;
    }

    Result redeployOnServer() {
        Operation op = new Operation("full-replace-deployment", new Address());
        op.addAdditionalProperty("name", this.runtimeName);
        ArrayList content = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", this.hash));
        content.add(contentValues);
        op.addAdditionalProperty("content", content);
        return this.connection.execute(op);
    }
}

