/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.bundle.BundleHandoverRequest;
import org.rhq.core.pluginapi.bundle.BundleHandoverResponse;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.support.SnapshotReportRequest;
import org.rhq.core.pluginapi.support.SnapshotReportResults;
import org.rhq.core.pluginapi.support.SupportFacet;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.HandoverContentUploader;
import org.rhq.modules.plugins.jbossas7.Redeployer;
import org.rhq.modules.plugins.jbossas7.helper.AdditionalJavaOpts;
import org.rhq.modules.plugins.jbossas7.helper.JdrReportRunner;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class StandaloneASComponent<T extends ResourceComponent<?>>
extends BaseServerComponent<T>
implements MeasurementFacet,
OperationFacet,
SupportFacet {
    private static final Log LOG = LogFactory.getLog(StandaloneASComponent.class);
    private static final String SERVER_CONFIG_TRAIT = "config-file";
    private static final String MULTICAST_ADDRESS_TRAIT = "multicastAddress";
    private static final String DEPLOY_DIR_TRAIT = "deployDir";
    private static final String TEMP_DIR_TRAIT = "temp-dir";
    private static final String JAVA_OPTS_ADDITIONAL_PROP = "javaOptsAdditional";
    private static final Address ENVIRONMENT_ADDRESS = new Address("core-service=server-environment");

    @Override
    public void start(ResourceContext<T> resourceContext) throws Exception {
        super.start(resourceContext);
        this.updateAdditionalJavaOpts(resourceContext);
    }

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.STANDALONE;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            if (requestName.equals(SERVER_CONFIG_TRAIT)) {
                this.collectConfigTrait(report, request);
                continue;
            }
            if (requestName.equals(MULTICAST_ADDRESS_TRAIT)) {
                this.collectMulticastAddressTrait(report, request);
                continue;
            }
            if (requestName.equals(DEPLOY_DIR_TRAIT)) {
                this.resolveDeployDir(report, request);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }

    private void resolveDeployDir(MeasurementReport report, MeasurementScheduleRequest request) {
        if ("JDG".equals(this.pluginConfiguration.getSimpleValue("productType", "AS7"))) {
            LOG.debug((Object)"This is a JDG server, so there is no deployDir");
            MeasurementDataTrait trait = new MeasurementDataTrait(request, "- not applicable to JDG -");
            report.addData(trait);
            return;
        }
        Address scanner = new Address("subsystem=deployment-scanner,scanner=default");
        ReadResource op = new ReadResource(scanner);
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            Map scannerMap = (Map)res.getResult();
            String path = (String)scannerMap.get("path");
            String relativeTo = (String)scannerMap.get("relative-to");
            File basePath = this.resolveRelativePath(relativeTo);
            String deployDir = new File(basePath, path).getAbsolutePath();
            MeasurementDataTrait trait = new MeasurementDataTrait(request, deployDir);
            report.addData(trait);
        } else {
            LOG.error((Object)"No default deployment scanner was found, returning no value");
        }
    }

    private File resolveRelativePath(String relativeTo) {
        Address addr = new Address("path", relativeTo);
        ReadResource op = new ReadResource(addr);
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            Map pathMap = (Map)res.getResult();
            String path = (String)pathMap.get("path");
            String relativeToProp = (String)pathMap.get("relative-to");
            if (relativeToProp == null) {
                return new File(path);
            }
            File basePath = this.resolveRelativePath(relativeToProp);
            return new File(basePath, path);
        }
        LOG.warn((Object)("The requested path property " + relativeTo + " is not registered in the server, so not resolving it."));
        return new File(relativeTo);
    }

    @Override
    protected Address getServerAddress() {
        return this.getAddress();
    }

    @Override
    protected String getSocketBindingGroup() {
        return "standard-sockets";
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("start")) {
            return this.startServer();
        }
        if (name.equals("restart")) {
            return this.restartServer(parameters);
        }
        if (name.equals("installRhqUser")) {
            return this.installManagementUser(parameters, this.pluginConfiguration);
        }
        if (name.equals("executeCommands") || name.equals("executeScript")) {
            return this.runCliCommand(parameters);
        }
        Operation op = new Operation(name, new Address());
        Result res = this.getASConnection().execute(op);
        OperationResult operationResult = this.postProcessResult(name, res);
        if (name.equals("shutdown")) {
            if (this.waitUntilDown()) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to shut down the server.");
            }
        }
        if (name.equals("reload")) {
            if (this.waitUntilReloaded()) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to reload the server.");
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    private boolean waitUntilReloaded() throws InterruptedException {
        boolean reloaded = false;
        while (!reloaded) {
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            try {
                Result res = this.getASConnection().execute(op);
                if (res.isSuccess() && !res.isReloadRequired()) {
                    reloaded = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (reloaded) continue;
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return reloaded;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration config = report.getConfiguration();
        PropertyList propertyList = config.getList("*3");
        for (Property property : propertyList.getList()) {
            PropertyMap map = (PropertyMap)property;
            String ro = map.getSimpleValue("read-only", "false");
            if (!Boolean.parseBoolean(ro)) continue;
            map.setErrorMessage("__logicalRemoved");
        }
        super.updateResourceConfiguration(report);
    }

    public BundleHandoverResponse handleContent(BundleHandoverRequest handoverRequest) {
        try {
            if (handoverRequest.getAction().equals("deployment")) {
                return this.handleDeployment(handoverRequest);
            }
            if (handoverRequest.getAction().equals("execute-script")) {
                return this.handleExecuteScript(handoverRequest);
            }
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.INVALID_ACTION);
        }
        catch (Exception e) {
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)"Unexpected handover failure", (Throwable)e);
        }
    }

    private BundleHandoverResponse handleDeployment(BundleHandoverRequest request) {
        String hash;
        HandoverContentUploader contentUploader = new HandoverContentUploader(request, this.getASConnection());
        boolean uploaded = contentUploader.upload();
        if (!uploaded) {
            return contentUploader.getFailureResponse();
        }
        String filename = contentUploader.getFilename();
        String runtimeName = contentUploader.getRuntimeName();
        Redeployer redeployer = new Redeployer(runtimeName, hash = contentUploader.getHash(), this.getASConnection());
        if (redeployer.deploymentExists()) {
            Result result = redeployer.redeployOnServer();
            if (result.isRolledBack()) {
                return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)result.getFailureDescription());
            }
            return BundleHandoverResponse.success();
        }
        Operation addDeploymentStep = new Operation("add", "deployment", filename);
        ArrayList addDeploymentContentProperty = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
        addDeploymentContentProperty.add(contentValues);
        addDeploymentStep.addAdditionalProperty("content", addDeploymentContentProperty);
        addDeploymentStep.addAdditionalProperty("name", filename);
        addDeploymentStep.addAdditionalProperty("runtime-name", runtimeName);
        Operation deployStep = new Operation("deploy", addDeploymentStep.getAddress());
        CompositeOperation compositeOperation = new CompositeOperation();
        compositeOperation.addStep(addDeploymentStep);
        compositeOperation.addStep(deployStep);
        Result result = this.getASConnection().execute((Operation)compositeOperation, 300);
        if (!result.isSuccess()) {
            return BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)result.getFailureDescription());
        }
        return BundleHandoverResponse.success();
    }

    @Override
    @NotNull
    protected Address getEnvironmentAddress() {
        return ENVIRONMENT_ADDRESS;
    }

    @Override
    @NotNull
    protected Address getHostAddress() {
        return this.getAddress();
    }

    @Override
    @NotNull
    protected String getBaseDirAttributeName() {
        return "base-dir";
    }

    @Override
    @NotNull
    protected String getConfigDirAttributeName() {
        return "config-dir";
    }

    @Override
    protected String getTempDirAttributeName() {
        return TEMP_DIR_TRAIT;
    }

    private void updateAdditionalJavaOpts(ResourceContext<T> resourceContext) {
        AdditionalJavaOpts additionalJavaOptsConfig;
        File configFile;
        if (resourceContext.getPluginConfiguration().getSimpleValue("homeDir") == null) {
            LOG.error((Object)"Additional JAVA_OPTS cannot be configured because homeDir property not set");
            return;
        }
        File baseDirectory = new File(resourceContext.getPluginConfiguration().getSimpleValue("homeDir"));
        File binDirectory = new File(baseDirectory, "bin");
        String additionalJavaOptsContent = resourceContext.getPluginConfiguration().getSimpleValue(JAVA_OPTS_ADDITIONAL_PROP);
        if (OperatingSystemType.WINDOWS.equals((Object)resourceContext.getSystemInformation().getOperatingSystemType())) {
            configFile = new File(binDirectory, "standalone.conf.bat");
            additionalJavaOptsConfig = new AdditionalJavaOpts.WindowsConfiguration();
        } else {
            configFile = new File(binDirectory, "standalone.conf");
            additionalJavaOptsConfig = new AdditionalJavaOpts.LinuxConfiguration();
        }
        try {
            if (additionalJavaOptsContent != null && !additionalJavaOptsContent.trim().isEmpty()) {
                additionalJavaOptsConfig.update(configFile, additionalJavaOptsContent);
            } else {
                additionalJavaOptsConfig.clean(configFile);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to update configuration file with additional JAVA_OPTS set via RHQ.", (Throwable)e);
        }
    }

    public SnapshotReportResults getSnapshotReport(SnapshotReportRequest request) throws Exception {
        if (AvailabilityType.UP.equals((Object)this.getAvailability())) {
            if ("jdr".equals(request.getName())) {
                InputStream is = new JdrReportRunner(this.getServerAddress(), this.getASConnection()).getReport();
                return new SnapshotReportResults(is);
            }
            return null;
        }
        throw new Exception("Cannot obtain report, resource is not UP");
    }
}

