/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseProcessDiscovery;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.helper.AdditionalJavaOpts;
import org.rhq.modules.plugins.jbossas7.helper.HostPort;

public class StandaloneASDiscovery
extends BaseProcessDiscovery {
    private static final Log log = LogFactory.getLog(StandaloneASDiscovery.class);
    private static final String SERVER_BASE_DIR_SYSPROP = "jboss.server.base.dir";
    private static final String SERVER_CONFIG_DIR_SYSPROP = "jboss.server.config.dir";
    private static final String SERVER_LOG_DIR_SYSPROP = "jboss.server.log.dir";
    private static final String JAVA_OPTS_ADDITIONAL_PROP = "javaOptsAdditional";

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.STANDALONE;
    }

    @Override
    protected String getBaseDirSystemPropertyName() {
        return SERVER_BASE_DIR_SYSPROP;
    }

    @Override
    protected String getConfigDirSystemPropertyName() {
        return SERVER_CONFIG_DIR_SYSPROP;
    }

    @Override
    protected String getLogDirSystemPropertyName() {
        return SERVER_LOG_DIR_SYSPROP;
    }

    @Override
    protected String getDefaultBaseDirName() {
        return "standalone";
    }

    @Override
    protected String getLogFileName() {
        return "server.log";
    }

    @Override
    protected String buildDefaultResourceName(HostPort hostPort, HostPort managementHostPort, JBossProductType productType, String serverName) {
        if (serverName != null && !serverName.trim().isEmpty()) {
            return String.format("%s (%s %s:%d)", productType.SHORT_NAME, serverName, managementHostPort.host, managementHostPort.port);
        }
        return String.format("%s (%s:%d)", productType.SHORT_NAME, managementHostPort.host, managementHostPort.port);
    }

    @Override
    protected String buildDefaultResourceDescription(HostPort hostPort, JBossProductType productType) {
        return String.format("Standalone %s server", productType.FULL_NAME);
    }

    @Override
    protected ProcessInfo getPotentialStartScriptProcess(ProcessInfo process) {
        return process.getParentProcess();
    }

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        Set<DiscoveredResourceDetails> discoveredResources = super.discoverResources(discoveryContext);
        for (DiscoveredResourceDetails discoveredResource : discoveredResources) {
            this.discoverAdditionalJavaOpts(discoveredResource, discoveryContext);
        }
        return discoveredResources;
    }

    @Override
    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext context) throws InvalidPluginConfigurationException {
        DiscoveredResourceDetails discoveredResource = super.discoverResource(pluginConfig, context);
        this.discoverAdditionalJavaOpts(discoveredResource, context);
        return discoveredResource;
    }

    private void discoverAdditionalJavaOpts(DiscoveredResourceDetails discoveredResource, ResourceDiscoveryContext context) {
        if (discoveredResource.getPluginConfiguration().getSimpleValue("homeDir") == null) {
            log.error((Object)"Additional JAVA_OPTS cannot be discovered because homeDir property not set");
            return;
        }
        File baseDirectory = new File(discoveredResource.getPluginConfiguration().getSimpleValue("homeDir"));
        File binDirectory = new File(baseDirectory, "bin");
        String javaOptsAdditionalValue = null;
        File configFile = null;
        AdditionalJavaOpts additionalJavaOptsConfig = null;
        if (OperatingSystemType.WINDOWS.equals((Object)context.getSystemInformation().getOperatingSystemType())) {
            configFile = new File(binDirectory, "standalone.conf.bat");
            additionalJavaOptsConfig = new AdditionalJavaOpts.WindowsConfiguration();
        } else {
            configFile = new File(binDirectory, "standalone.conf");
            additionalJavaOptsConfig = new AdditionalJavaOpts.LinuxConfiguration();
        }
        try {
            javaOptsAdditionalValue = additionalJavaOptsConfig.discover(configFile);
        }
        catch (Exception e) {
            log.error((Object)"Unable to discover additional JAVA_OPTS set via RHQ from configuration file.", (Throwable)e);
        }
        discoveredResource.getPluginConfiguration().setSimpleValue(JAVA_OPTS_ADDITIONAL_PROP, javaOptsAdditionalValue);
    }
}

