/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashMap;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class TemplatedComponent
extends BaseComponent<ResourceComponent<?>> {
    private static final String TYPE_CONFIGURATION = "__type";
    private static final String NAME_CONFIGURATION = "__name";

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        if (configDef.getDefaultTemplate().getConfiguration().get(TYPE_CONFIGURATION) != null) {
            configDef.getPropertyDefinitions().remove(TYPE_CONFIGURATION);
            ConfigurationLoadDelegate delegate = new ConfigurationLoadDelegate(configDef, this.getASConnection(), this.address);
            Configuration configuration = delegate.loadResourceConfiguration();
            PropertySimple pathProperty = (PropertySimple)this.context.getPluginConfiguration().get("path");
            String type = pathProperty.getStringValue();
            type = type.substring(type.lastIndexOf(44) + 1, type.lastIndexOf(61));
            configuration.put((Property)new PropertySimple(TYPE_CONFIGURATION, (Object)type));
            return configuration;
        }
        if (configDef.getDefaultTemplate().getConfiguration().get(NAME_CONFIGURATION) != null) {
            configDef.getPropertyDefinitions().remove(NAME_CONFIGURATION);
            ConfigurationLoadDelegate delegate = new ConfigurationLoadDelegate(configDef, this.getASConnection(), this.address);
            Configuration configuration = delegate.loadResourceConfiguration();
            PropertySimple pathProperty = (PropertySimple)this.context.getPluginConfiguration().get("path");
            String name = pathProperty.getStringValue();
            name = name.substring(name.lastIndexOf(61) + 1);
            configuration.put((Property)new PropertySimple(NAME_CONFIGURATION, (Object)name));
            return configuration;
        }
        return super.loadResourceConfiguration();
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ConfigurationDefinition configDefCopy = this.context.getResourceType().getResourceConfigurationDefinition().copy();
        Map propDefs = configDefCopy.getPropertyDefinitions();
        boolean templatedComponentUpdate = false;
        if (configDefCopy.getDefaultTemplate().getConfiguration().get(TYPE_CONFIGURATION) != null) {
            propDefs.remove(TYPE_CONFIGURATION);
            report.getConfiguration().remove(TYPE_CONFIGURATION);
            templatedComponentUpdate = true;
        } else if (configDefCopy.getDefaultTemplate().getConfiguration().get(NAME_CONFIGURATION) != null) {
            propDefs.remove(NAME_CONFIGURATION);
            report.getConfiguration().remove(NAME_CONFIGURATION);
            templatedComponentUpdate = true;
        }
        if (templatedComponentUpdate) {
            Map currentAttributeList = null;
            ReadResource currentAttributesOp = new ReadResource(this.address);
            HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
            additionalProperties.put("proxies", "true");
            additionalProperties.put("include-runtime", "true");
            additionalProperties.put("include-defaults", "true");
            additionalProperties.put("attributes-only", "true");
            currentAttributesOp.setAdditionalProperties(additionalProperties);
            Result currentAttributes = this.getASConnection().execute(currentAttributesOp);
            if (currentAttributes.isSuccess()) {
                currentAttributeList = (Map)currentAttributes.getResult();
            }
            for (PropertyDefinition propDef : configDefCopy.getNonGroupedProperties()) {
                if (currentAttributeList == null) continue;
                String name = this.removeAttributeMarkup(propDef.getName());
                if (!currentAttributeList.containsKey(name)) {
                    propDefs.remove(propDef.getName());
                    report.getConfiguration().remove(propDef.getName());
                    continue;
                }
                Object current = currentAttributeList.get(name);
                Property update = (Property)report.getConfiguration().getAllProperties().get(propDef.getName());
                if (null != current || !this.isUndefined(update)) continue;
                propDefs.remove(propDef.getName());
                report.getConfiguration().remove(propDef.getName());
            }
        }
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDefCopy, this.getASConnection(), this.address);
        delegate.updateResourceConfiguration(report);
    }

    private boolean isUndefined(Property property) {
        if (null == property) {
            return true;
        }
        if (property instanceof PropertySimple) {
            return ((PropertySimple)property).getStringValue() == null;
        }
        if (property instanceof PropertyMap) {
            for (Property p : ((PropertyMap)property).getMap().values()) {
                if (this.isUndefined(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String removeAttributeMarkup(String name) {
        int index = -1;
        index = name.indexOf(":");
        if (index > -1) {
            name = name.substring(0, index);
        }
        return name;
    }
}

