/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.helper;

import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.helper.HostnameVerification;
import org.rhq.modules.plugins.jbossas7.helper.TrustStrategy;
import org.rhq.modules.plugins.jbossas7.util.SecurityUtil;

public class ServerPluginConfiguration {
    private final Configuration pluginConfig;

    public ServerPluginConfiguration(Configuration pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public Configuration getPluginConfig() {
        return this.pluginConfig;
    }

    public File getPath(String pathName) {
        if ("jboss.home.dir".equals(pathName)) {
            return this.getHomeDir();
        }
        if ("jboss.server.base.dir".equals(pathName) || "jboss.domain.base.dir".equals(pathName)) {
            return this.getBaseDir();
        }
        if ("jboss.server.config.dir".equals(pathName) || "jboss.domain.config.dir".equals(pathName)) {
            return this.getConfigDir();
        }
        if ("jboss.server.log.dir".equals(pathName) || "jboss.domain.log.dir".equals(pathName)) {
            return this.getLogDir();
        }
        return null;
    }

    public String getHostname() {
        return this.pluginConfig.getSimpleValue("hostname");
    }

    public void setHostname(String hostname) {
        this.pluginConfig.setSimpleValue("hostname", hostname);
    }

    public Integer getPort() {
        String stringValue = this.pluginConfig.getSimpleValue("port");
        return stringValue != null ? Integer.valueOf(stringValue) : null;
    }

    public void setPort(int port) {
        this.pluginConfig.setSimpleValue("port", String.valueOf(port));
    }

    public boolean isSecure() {
        String stringValue = this.pluginConfig.getSimpleValue("secure");
        return stringValue != null && Boolean.parseBoolean(stringValue);
    }

    public void setSecure(boolean secure) {
        this.pluginConfig.setSimpleValue("secure", String.valueOf(secure));
    }

    public Integer getNativePort() {
        String stringValue = this.pluginConfig.getSimpleValue("nativePort");
        return stringValue != null ? Integer.valueOf(stringValue) : null;
    }

    public void setNativeHost(String host) {
        this.pluginConfig.setSimpleValue("nativeHost", host);
    }

    public String getNativeHost() {
        return this.pluginConfig.getSimpleValue("nativeHost");
    }

    public void setNativePort(int port) {
        this.pluginConfig.setSimpleValue("nativePort", String.valueOf(port));
    }

    public String getUser() {
        return this.pluginConfig.getSimpleValue("user");
    }

    public void setUser(String user) {
        this.pluginConfig.setSimpleValue("user", user);
    }

    public String getPassword() {
        return this.pluginConfig.getSimpleValue("password");
    }

    public void setPassword(String password) {
        this.pluginConfig.setSimpleValue("password", password);
    }

    public Long getManagementConnectionTimeout() {
        return this.pluginConfig.getSimple("managementConnectionTimeout").getLongValue();
    }

    public File getHomeDir() {
        String stringValue = this.pluginConfig.getSimpleValue("homeDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setHomeDir(File homeDir) {
        this.pluginConfig.setSimpleValue("homeDir", homeDir != null ? homeDir.toString() : null);
    }

    public File getBaseDir() {
        String stringValue = this.pluginConfig.getSimpleValue("baseDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setBaseDir(File homeDir) {
        this.pluginConfig.setSimpleValue("baseDir", homeDir != null ? homeDir.toString() : null);
    }

    public File getConfigDir() {
        String stringValue = this.pluginConfig.getSimpleValue("configDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setConfigDir(File configDir) {
        this.pluginConfig.setSimpleValue("configDir", configDir != null ? configDir.toString() : null);
    }

    public File getLogDir() {
        String stringValue = this.pluginConfig.getSimpleValue("logDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setLogDir(File logDir) {
        this.pluginConfig.setSimpleValue("logDir", logDir != null ? logDir.toString() : null);
    }

    public JBossProductType getProductType() {
        String stringValue = this.pluginConfig.getSimpleValue("productType");
        return stringValue != null && !stringValue.isEmpty() ? JBossProductType.valueOf(stringValue) : null;
    }

    public void setProductType(JBossProductType productType) {
        this.pluginConfig.setSimpleValue("productType", productType != null ? productType.name() : null);
    }

    public File getHostConfigFile() {
        String stringValue = this.pluginConfig.getSimpleValue("hostConfigFile");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setHostConfigFile(File hostConfigFile) {
        this.pluginConfig.setSimpleValue("hostConfigFile", hostConfigFile != null ? hostConfigFile.toString() : null);
    }

    @Deprecated
    public Integer getAvailabilityCheckPeriod() {
        return 0;
    }

    @Deprecated
    public void setAvailabilityCheckPeriod(Integer availabilityCheckPeriod) {
    }

    public TrustStrategy getTrustStrategy() {
        return TrustStrategy.findByName(this.pluginConfig.getSimpleValue("trustStrategy", TrustStrategy.STANDARD.name));
    }

    public HostnameVerification getHostnameVerification() {
        return HostnameVerification.findByName(this.pluginConfig.getSimpleValue("hostnameVerification", HostnameVerification.STRICT.name));
    }

    public String getTruststoreType() {
        return this.pluginConfig.getSimpleValue("truststoreType");
    }

    public String getTruststore() {
        return this.pluginConfig.getSimpleValue("truststore");
    }

    public String getTruststorePassword() {
        return this.pluginConfig.getSimpleValue("truststorePassword");
    }

    public boolean isClientcertAuthentication() {
        String stringValue = this.pluginConfig.getSimpleValue("clientcertAuthentication");
        return stringValue != null && Boolean.parseBoolean(stringValue);
    }

    public String getKeystoreType() {
        return this.pluginConfig.getSimpleValue("keystoreType");
    }

    public String getKeystore() {
        return this.pluginConfig.getSimpleValue("keystore");
    }

    public String getKeystorePassword() {
        return this.pluginConfig.getSimpleValue("keystorePassword");
    }

    public String getKeyPassword() {
        return this.pluginConfig.getSimpleValue("keyPassword");
    }

    public void validate() {
        if (this.getPort() == null || this.getPort() <= 0) {
            throw new InvalidPluginConfigurationException("Unable to detect management port. Please enable management HTTP interface on and then set correct port number in Connection Settings of this resource");
        }
        if (this.isSecure()) {
            String truststore = this.getTruststore();
            if (truststore != null) {
                if (!new File(truststore).isFile()) {
                    throw new InvalidPluginConfigurationException("Truststore file does not exist");
                }
                String truststoreType = this.getTruststoreType();
                if (truststoreType == null) {
                    throw new InvalidPluginConfigurationException("Truststore type is required when using a custom truststore file");
                }
                try {
                    KeyStore.getInstance(truststoreType);
                }
                catch (KeyStoreException e) {
                    throw new InvalidPluginConfigurationException("Truststore type not supported: " + e.getMessage());
                }
                try {
                    SecurityUtil.loadKeystore(truststoreType, truststore, this.getTruststorePassword());
                }
                catch (Exception e) {
                    throw new InvalidPluginConfigurationException("Cannot read the truststore: " + e.getMessage());
                }
            }
            if (this.isClientcertAuthentication()) {
                String keystore = this.getKeystore();
                if (keystore == null) {
                    throw new InvalidPluginConfigurationException("Keystore is required when using client certificate authentication");
                }
                if (!new File(keystore).isFile()) {
                    throw new InvalidPluginConfigurationException("Keystore file does not exist");
                }
                String keystoreType = this.getKeystoreType();
                if (keystoreType == null) {
                    throw new InvalidPluginConfigurationException("Keystore type is required when using a custom keystore file");
                }
                try {
                    KeyStore.getInstance(keystoreType);
                }
                catch (KeyStoreException e) {
                    throw new InvalidPluginConfigurationException("Keystore type not supported: " + e.getMessage());
                }
                try {
                    SecurityUtil.loadKeystore(keystoreType, keystore, this.getKeystorePassword());
                }
                catch (Exception e) {
                    throw new InvalidPluginConfigurationException("Cannot read the keystore: " + e.getMessage());
                }
            }
        }
    }

    public abstract class Property {
        public static final String HOSTNAME = "hostname";
        public static final String PORT = "port";
        public static final String SECURE = "secure";
        public static final String NATIVE_HOST = "nativeHost";
        public static final String NATIVE_PORT = "nativePort";
        public static final String USER = "user";
        public static final String PASSWORD = "password";
        public static final String MANAGEMENT_CONNECTION_TIMEOUT = "managementConnectionTimeout";
        public static final String HOME_DIR = "homeDir";
        public static final String BASE_DIR = "baseDir";
        public static final String CONFIG_DIR = "configDir";
        public static final String LOG_DIR = "logDir";
        public static final String PRODUCT_TYPE = "productType";
        public static final String HOST_CONFIG_FILE = "hostConfigFile";
        @Deprecated
        public static final String AVAIL_CHECK_PERIOD_CONFIG_PROP = "availabilityCheckPeriod";
        public static final String TRUST_STRATEGY = "trustStrategy";
        public static final String HOSTNAME_VERIFICATION = "hostnameVerification";
        public static final String TRUSTSTORE_TYPE = "truststoreType";
        public static final String TRUSTSTORE = "truststore";
        public static final String TRUSTSTORE_PASSWORD = "truststorePassword";
        public static final String CLIENTCERT_AUTHENTICATION = "clientcertAuthentication";
        public static final String KEYSTORE_TYPE = "keystoreType";
        public static final String KEYSTORE = "keystore";
        public static final String KEYSTORE_PASSWORD = "keystorePassword";
        public static final String KEY_PASSWORD = "keyPassword";
    }
}

