/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.patching;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.pluginapi.bundle.BundlePurgeRequest;
import org.rhq.core.pluginapi.bundle.BundlePurgeResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;
import org.rhq.modules.plugins.jbossas7.ServerControl;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.patching.BundleMetadata;
import org.rhq.modules.plugins.jbossas7.patching.MetadataFiles;
import org.rhq.modules.plugins.jbossas7.patching.Result;
import org.rhq.modules.plugins.jbossas7.util.PatchDetails;

public final class PatchHandlerComponent
implements ResourceComponent<ResourceComponent<?>>,
BundleFacet {
    private static final Log LOG = LogFactory.getLog(PatchHandlerComponent.class);
    private static final String PATCH_ROLLBACK_COMMAND = "patch rollback --reset-configuration=false --patch-id=";
    private ResourceContext<ResourceComponent<?>> context;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDeployResult deployBundle(BundleDeployRequest request) {
        ServerControl control = this.onServer(request);
        Result<Void> check = this.sanityCheck(control, request.getReferencedConfiguration(), request.getBundleManagerProvider(), request.getResourceDeployment(), !this.isTakeOver(request.getResourceDeployment().getBundleDeployment().getConfiguration()));
        if (check.failed()) {
            BundleDeployResult result = new BundleDeployResult();
            result.setErrorMessage(check.errorMessage);
            return result;
        }
        if (request.isRevert()) {
            return this.handleRevert(request);
        }
        BundleDeployResult result = new BundleDeployResult();
        ASConnection connection = new ASConnection(ASConnectionParams.createFrom(new ServerPluginConfiguration(request.getReferencedConfiguration())));
        BundleManagerProvider bmp = request.getBundleManagerProvider();
        BundleResourceDeployment rd = request.getResourceDeployment();
        Result<Boolean> stop = this.stopIfNeeded(connection, control, request.getResourceDeployment().getBundleDeployment().getConfiguration(), bmp, rd);
        if (stop.failed()) {
            result.setErrorMessage(stop.errorMessage);
            return result;
        }
        boolean startUp = (Boolean)stop.result;
        try {
            Result<List<PatchDetails>> historyBeforeDeployment;
            StringBuilder command = new StringBuilder("patch apply --path=").append(((File)request.getPackageVersionFiles().values().iterator().next()).getAbsolutePath());
            Configuration bundleConfig = request.getResourceDeployment().getBundleDeployment().getConfiguration();
            String override = bundleConfig.getSimpleValue("override");
            String overrideAll = bundleConfig.getSimpleValue("override-all");
            String preserve = bundleConfig.getSimpleValue("preserve");
            String overrideModules = bundleConfig.getSimpleValue("override-modules");
            if (override != null) {
                command.append(" --override=").append(override);
            }
            if (overrideAll != null) {
                command.append(" --override-all=").append(Boolean.valueOf(overrideAll));
            }
            if (preserve != null) {
                command.append(" --preserve=").append(preserve);
            }
            if (overrideModules != null) {
                command.append(" --override-modules=").append(overrideModules);
            }
            if ((historyBeforeDeployment = this.getPatchHistory(control, "deploy")).failed()) {
                result.setErrorMessage(historyBeforeDeployment.errorMessage);
                BundleDeployResult bundleDeployResult = result;
                return bundleDeployResult;
            }
            ProcessExecutionResults results = control.cli().disconnected(true).executeCliCommand(command.toString());
            switch (this.handleExecutionResults(results, bmp, rd, true)) {
                case EXECUTION_ERROR: {
                    result.setErrorMessage("Error while trying to execute patch command: " + results.getError().getMessage());
                    BundleDeployResult bundleDeployResult = result;
                    return bundleDeployResult;
                }
                case TIMEOUT: {
                    result.setErrorMessage("Patch application timed out. Output was: " + results.getCapturedOutput());
                    BundleDeployResult bundleDeployResult = result;
                    return bundleDeployResult;
                }
                case ERROR: {
                    result.setErrorMessage("Patch application failed with error code " + results.getExitCode() + ".");
                    BundleDeployResult bundleDeployResult = result;
                    return bundleDeployResult;
                }
            }
            String errorMessage = this.storeState(control, request.getResourceDeployment(), request.getReferencedConfiguration(), (List)historyBeforeDeployment.result);
            if (errorMessage != null) {
                result.setErrorMessage(errorMessage);
                BundleDeployResult bundleDeployResult = result;
                return bundleDeployResult;
            }
        }
        finally {
            String errorMessage;
            if (startUp && (errorMessage = this.startServer(connection, control, bmp, rd)) != null) {
                result.setErrorMessage(errorMessage);
            }
        }
        return result;
    }

    public BundlePurgeResult purgeBundle(BundlePurgeRequest request) {
        BundlePurgeResult result = new BundlePurgeResult();
        ServerControl control = ServerControl.onServer(request.getReferencedConfiguration(), AS7Mode.valueOf(request.getDestinationTarget().getPath()), this.context.getSystemInformation());
        Result<Void> check = this.sanityCheck(control, request.getReferencedConfiguration(), request.getBundleManagerProvider(), request.getLiveResourceDeployment(), false);
        if (check.failed()) {
            result.setErrorMessage(check.errorMessage);
            return result;
        }
        Result<BundleMetadata> metadata = BundleMetadata.forDeployment(request.getLiveResourceDeployment(), request.getReferencedConfiguration());
        if (metadata.failed()) {
            result.setErrorMessage(metadata.errorMessage);
            return result;
        }
        LinkedHashSet<String> pidsToRollback = new LinkedHashSet<String>();
        for (BundleMetadata.DeploymentMetadata dm : ((BundleMetadata)metadata.result).deployments) {
            for (PatchDetails pd : dm.applied) {
                pidsToRollback.add(pd.getId());
            }
        }
        ASConnection connection = new ASConnection(ASConnectionParams.createFrom(new ServerPluginConfiguration(request.getReferencedConfiguration())));
        String errorMessage = this.rollbackPatches(control, request.getBundleManagerProvider(), request.getLiveResourceDeployment(), connection, "purge", new ArrayList<String>(pidsToRollback));
        if (errorMessage != null) {
            result.setErrorMessage(errorMessage);
            return result;
        }
        this.forgetState(request.getLiveResourceDeployment(), request.getReferencedConfiguration());
        return result;
    }

    private BundleDeployResult handleRevert(BundleDeployRequest request) {
        BundleDeployResult result = new BundleDeployResult();
        Result<BundleMetadata> latestDeploymentMetadata = BundleMetadata.forDeployment(request.getResourceDeployment(), request.getReferencedConfiguration());
        if (latestDeploymentMetadata.failed()) {
            result.setErrorMessage(latestDeploymentMetadata.errorMessage);
            return result;
        }
        Result<String[]> pids = this.getPids(request.getResourceDeployment(), "revert");
        if (pids.failed()) {
            result.setErrorMessage(pids.errorMessage);
            return result;
        }
        LinkedHashSet<String> pidsToRollback = new LinkedHashSet<String>();
        ArrayList<BundleMetadata.DeploymentMetadata> deploymentsToForget = new ArrayList<BundleMetadata.DeploymentMetadata>();
        String stopPid = ((String[])pids.result)[0];
        boolean stopPidFound = false;
        block0: for (BundleMetadata.DeploymentMetadata dm : ((BundleMetadata)latestDeploymentMetadata.result).deployments) {
            for (PatchDetails pd : dm.applied) {
                String pid = pd.getId();
                if (pid.equals(stopPid)) {
                    stopPidFound = true;
                    break block0;
                }
                pidsToRollback.add(pid);
            }
            deploymentsToForget.add(dm);
        }
        if (!stopPidFound) {
            result.setErrorMessage("The patch to revert to (" + stopPid + ") was not previously deployed by RHQ. This means that this server joined the resource group '" + request.getResourceDeployment().getBundleDeployment().getDestination().getGroup().getName() + "' after this patch was already deployed. To prevent accidental damage no changes will be made to the server.");
            return result;
        }
        ASConnection connection = new ASConnection(ASConnectionParams.createFrom(new ServerPluginConfiguration(request.getReferencedConfiguration())));
        ServerControl control = this.onServer(request);
        String errorMessage = this.rollbackPatches(control, request.getBundleManagerProvider(), request.getResourceDeployment(), connection, "revert", new ArrayList<String>(pidsToRollback));
        if (errorMessage != null) {
            result.setErrorMessage(errorMessage);
            return result;
        }
        for (BundleMetadata.DeploymentMetadata dm : deploymentsToForget) {
            dm.forget(request.getResourceDeployment(), request.getReferencedConfiguration());
        }
        return result;
    }

    public void start(ResourceContext<ResourceComponent<?>> context) {
        this.context = context;
    }

    public void stop() {
    }

    private boolean waitForServerToStart(ASConnection connection) throws InterruptedException {
        boolean up = false;
        while (!up) {
            up = this.isServerUp(connection);
            if (up) continue;
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return true;
    }

    private ExecutionResult handleExecutionResults(ProcessExecutionResults results, BundleManagerProvider bmp, BundleResourceDeployment resourceDeployment, boolean doAudit) {
        ExecutionResult ret = ExecutionResult.OK;
        if (results.getError() != null) {
            ret = ExecutionResult.EXECUTION_ERROR;
        } else if (results.getExitCode() == null) {
            ret = ExecutionResult.TIMEOUT;
        } else if (results.getExitCode() != 0) {
            ret = ExecutionResult.ERROR;
        }
        if (doAudit) {
            this.audit(bmp, resourceDeployment, "Output", ret == ExecutionResult.OK ? "Standard" : "Error", ret.status(), results.getCapturedOutput());
        }
        return ret;
    }

    private void audit(BundleManagerProvider bmp, BundleResourceDeployment resourceDeployment, String action, String info, BundleResourceDeploymentHistory.Status status, String message) {
        block2: {
            try {
                bmp.auditDeployment(resourceDeployment, action, info, BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, status, message, null);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Failed to report audit deployment.", (Throwable)e);
            }
        }
    }

    private String fullErrorMessage(String basicMessage, List<String> patchIds, int attemptedPatchIdIndex, String action) {
        String message = basicMessage;
        if (attemptedPatchIdIndex > 0) {
            message = message + " The following patches were successfully " + action + ": " + StringUtil.collectionToString(patchIds.subList(0, attemptedPatchIdIndex)) + ".";
        }
        if (attemptedPatchIdIndex < patchIds.size() - 1) {
            message = message + " The following patches were NOT " + action + ": " + StringUtil.collectionToString(patchIds.subList(attemptedPatchIdIndex + 1, patchIds.size())) + ".";
        }
        return message;
    }

    private ServerControl onServer(BundleDeployRequest request) {
        return ServerControl.onServer(request.getReferencedConfiguration(), AS7Mode.valueOf(request.getDestinationTarget().getPath()), this.context.getSystemInformation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String rollbackPatches(ServerControl control, BundleManagerProvider bmp, BundleResourceDeployment rd, ASConnection connection, String operation, List<String> pids) {
        Configuration deploymentConfiguration;
        Result<Boolean> stop;
        int installedPidIdx;
        if (pids.isEmpty()) {
            return null;
        }
        ServerControl.Cli cli = control.cli().disconnected(true);
        Result<List<PatchDetails>> history = this.getPatchHistory(control, operation);
        if (history.failed()) {
            return history.errorMessage;
        }
        List installedPatches = (List)history.result;
        ArrayList<String> pidsToRollback = new ArrayList<String>(pids);
        ArrayList noLongerRemovablePids = new ArrayList();
        HashSet<String> installedPids = new HashSet<String>();
        int lastPidToRollback = 0;
        for (installedPidIdx = 0; installedPidIdx < installedPatches.size() && lastPidToRollback < pidsToRollback.size(); ++installedPidIdx) {
            PatchDetails installed = (PatchDetails)installedPatches.get(installedPidIdx);
            String pidToRollback = (String)pidsToRollback.get(lastPidToRollback);
            String installedId = installed.getId();
            if (installedId.equals(pidToRollback)) {
                ++lastPidToRollback;
            } else {
                while (!installedId.equals(pidToRollback) && lastPidToRollback < pidsToRollback.size()) {
                    pidToRollback = (String)pidsToRollback.get(lastPidToRollback);
                    noLongerRemovablePids.add(pidsToRollback.remove(lastPidToRollback));
                }
                if (installedId.equals(pidToRollback)) {
                    ++lastPidToRollback;
                }
            }
            installedPids.add(installedId);
        }
        while (installedPidIdx < installedPatches.size()) {
            installedPids.add(((PatchDetails)installedPatches.get(installedPidIdx)).getId());
            ++installedPidIdx;
        }
        if (lastPidToRollback < pidsToRollback.size()) {
            List uninstalledPids = pidsToRollback.subList(lastPidToRollback, pidsToRollback.size());
            noLongerRemovablePids.addAll(uninstalledPids);
            uninstalledPids.clear();
        }
        boolean inconsistent = false;
        for (String pid : noLongerRemovablePids) {
            if (!installedPids.contains(pid)) continue;
            inconsistent = true;
            break;
        }
        if (pidsToRollback.isEmpty()) {
            if (noLongerRemovablePids.isEmpty()) {
                this.audit(bmp, rd, "Rollback", "Nothing To Do", BundleResourceDeploymentHistory.Status.WARN, "None of the patches " + pids + " is installed anymore.");
                return null;
            }
            String message = "The following patches were not rolled back due to other patches having been applied in the meantime: " + noLongerRemovablePids + ". No other patches can be rolled back.";
            if (inconsistent) {
                return message;
            }
            this.audit(bmp, rd, "Rollback", "Missing patches", BundleResourceDeploymentHistory.Status.WARN, "The following patches were to be rolled back but they aren't installed anymore: " + noLongerRemovablePids + ".");
        }
        if ((stop = this.stopIfNeeded(connection, control, deploymentConfiguration = rd.getBundleDeployment().getConfiguration(), bmp, rd)).failed()) {
            return stop.errorMessage;
        }
        boolean serverWasUp = (Boolean)stop.result;
        ArrayList<String> patchCommands = new ArrayList<String>();
        for (String pid : pidsToRollback) {
            patchCommands.add(PATCH_ROLLBACK_COMMAND + pid);
        }
        String errorMessage = null;
        try {
            int i = 0;
            for (String command : patchCommands) {
                ProcessExecutionResults results = cli.executeCliCommand(command);
                switch (this.handleExecutionResults(results, bmp, rd, true)) {
                    case EXECUTION_ERROR: {
                        String string = this.fullErrorMessage("Error trying to run patch rollback: " + results.getError().getMessage(), pids, i - 1, "rolled back");
                        return string;
                    }
                    case TIMEOUT: {
                        String string = this.fullErrorMessage("Patch rollback timed out. Captured output: " + results.getCapturedOutput(), pids, i - 1, "rolled back");
                        return string;
                    }
                    case ERROR: {
                        String string = this.fullErrorMessage("Patch rollback failed with error code " + results.getExitCode() + ".", pids, i - 1, "rolled back");
                        return string;
                    }
                }
                ++i;
            }
        }
        finally {
            String startError;
            if (!noLongerRemovablePids.isEmpty()) {
                if (inconsistent) {
                    errorMessage = "The following patches were not rolled back due to other patches having been applied in the meantime: " + noLongerRemovablePids;
                } else {
                    this.audit(bmp, rd, "Rollback", "Missing patches", BundleResourceDeploymentHistory.Status.WARN, "The following patches were to be rolled back but they aren't installed anymore: " + noLongerRemovablePids + ".");
                }
            }
            if (serverWasUp && (startError = this.startServer(connection, control, bmp, rd)) != null) {
                if (errorMessage != null) {
                    this.audit(bmp, rd, "Restart", "Failure", BundleResourceDeploymentHistory.Status.FAILURE, startError);
                } else {
                    errorMessage = startError;
                }
            }
        }
        return errorMessage;
    }

    private boolean isServerUp(ASConnection connection) {
        ReadAttribute op = new ReadAttribute(new Address(), "release-version");
        try {
            org.rhq.modules.plugins.jbossas7.json.Result res = connection.execute(op);
            if (res.isSuccess()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Result<Boolean> stopIfNeeded(ASConnection connection, ServerControl control, Configuration bundleDeploymentConfiguration, BundleManagerProvider bmp, BundleResourceDeployment resourceDeployment) {
        boolean doRestart = Boolean.valueOf(bundleDeploymentConfiguration.getSimpleValue("restart", "true"));
        if (doRestart && this.isServerUp(connection)) {
            this.audit(bmp, resourceDeployment, "Stop", "Stop", null, "The server is running. Stopping it before any operation on patches.");
            ProcessExecutionResults results = control.lifecycle().shutdownServer();
            switch (this.handleExecutionResults(results, bmp, resourceDeployment, true)) {
                case EXECUTION_ERROR: {
                    return new Result<Boolean>(false, "Error trying to shutdown the server: " + results.getError().getMessage());
                }
                case TIMEOUT: {
                    return new Result<Boolean>(false, "Stopping the server timed out. Captured output: " + results.getCapturedOutput());
                }
                case ERROR: {
                    return new Result<Boolean>(false, "Stopping the server failed with error code " + results.getExitCode() + " and output: " + results.getCapturedOutput());
                }
            }
            return new Result<Boolean>(true, null);
        }
        return new Result<Boolean>(false, null);
    }

    private String startServer(ASConnection connection, ServerControl control, BundleManagerProvider bmp, BundleResourceDeployment resourceDeployment) {
        this.audit(bmp, resourceDeployment, "Start", "Start", null, "Starting the server back up.");
        ProcessExecutionResults results = control.lifecycle().startServer();
        switch (this.handleExecutionResults(results, bmp, resourceDeployment, false)) {
            case EXECUTION_ERROR: {
                return "Error trying to start the server. " + results.getError().getMessage();
            }
            case ERROR: {
                return "Starting the server failed with error code " + results.getExitCode() + " and output: " + results.getCapturedOutput();
            }
        }
        try {
            this.waitForServerToStart(connection);
        }
        catch (InterruptedException e) {
            String message = "Interrupted while waiting for the server to start up after applying the patch";
            Thread.currentThread().interrupt();
            return message;
        }
        return null;
    }

    private Result<Void> sanityCheck(ServerControl serverControl, Configuration referencedConfiguration, BundleManagerProvider bmp, BundleResourceDeployment resourceDeployment, boolean uniqueDeploymentRequired) {
        int activeDestinationId;
        PropertySimple supportsPatching = referencedConfiguration.getSimple("supportsPatching");
        if (supportsPatching == null) {
            return Result.error("Target resource doesn't contain the 'Supports Patching' property in its connection settings. Using an old version of the JBossAS7 plugin?");
        }
        if (supportsPatching.getBooleanValue() == null || !supportsPatching.getBooleanValue().booleanValue()) {
            return Result.error("The target resource does not support patching.");
        }
        ProcessExecutionResults results = serverControl.cli().disconnected(true).executeCliCommand("help --commands");
        switch (this.handleExecutionResults(results, bmp, resourceDeployment, false)) {
            case EXECUTION_ERROR: {
                return Result.error("Failed to check availability of patch command using the 'help --commands' command. The error was: " + results.getError().getMessage());
            }
            case ERROR: {
                return Result.error("Failed to check availability of patch command using the 'help --commands' command. The execution failed with an exit code " + results.getExitCode());
            }
            case TIMEOUT: {
                return Result.error("Failed to check availability of patch command using the 'help --commands' command. The execution timed out with the output: " + results.getCapturedOutput());
            }
            case OK: {
                if (results.getCapturedOutput() != null && (results.getCapturedOutput().contains(" patch ") || results.getCapturedOutput().contains("\npatch"))) break;
                return Result.error("The underlying server does not support the patch command. Cannot perform the patch operation.");
            }
        }
        if (!uniqueDeploymentRequired) {
            return Result.with(null);
        }
        Result<MetadataFiles> metadata = MetadataFiles.getActive(referencedConfiguration);
        if (metadata.failed()) {
            return Result.error(metadata.errorMessage);
        }
        if (metadata.result == null) {
            return Result.with(null);
        }
        int destinationId = resourceDeployment.getBundleDeployment().getDestination().getId();
        if (destinationId != (activeDestinationId = ((MetadataFiles)metadata.result).getDestinationId())) {
            try {
                String destName = ((MetadataFiles)metadata.result).getDestinationName();
                return Result.error("The destination \"" + destName + "\" already deployed one or more patches to this server. You can deploy to a server using only a single destination.");
            }
            catch (Exception e) {
                return Result.error("The destination with id " + destinationId + " already handles patch deployments to this server. You can deploy to a server using only a single destination.");
            }
        }
        return Result.with(null);
    }

    private String storeState(ServerControl control, BundleResourceDeployment rd, Configuration referencedConfiguration, List<PatchDetails> historyBeforeDeployment) {
        Result<List<PatchDetails>> history = this.getPatchHistory(control, "deployment");
        if (history.failed()) {
            return history.errorMessage;
        }
        Result<MetadataFiles> metadataFiles = MetadataFiles.forDeployment(rd, referencedConfiguration);
        if (metadataFiles.failed()) {
            return metadataFiles.errorMessage;
        }
        Result<Void> saveDestinationName = ((MetadataFiles)metadataFiles.result).saveDestinationName(rd.getBundleDeployment().getDestination().getName());
        if (saveDestinationName.failed()) {
            return saveDestinationName.errorMessage;
        }
        Result<Void> saveAsActive = ((MetadataFiles)metadataFiles.result).saveAsActive();
        if (saveAsActive.failed()) {
            return saveAsActive.errorMessage;
        }
        BundleMetadata.DeploymentMetadata deploymentMetadata = BundleMetadata.DeploymentMetadata.from(historyBeforeDeployment, (List)history.result);
        Result<Void> write = deploymentMetadata.persistAsNewState(rd, referencedConfiguration);
        if (write.failed()) {
            return write.errorMessage;
        }
        return null;
    }

    private String forgetState(BundleResourceDeployment rd, Configuration referencedConfiguration) {
        Result<MetadataFiles> metadata = MetadataFiles.forDeployment(rd, referencedConfiguration);
        if (metadata.failed()) {
            return metadata.errorMessage;
        }
        ((MetadataFiles)metadata.result).delete();
        return null;
    }

    private Result<List<PatchDetails>> getPatchHistory(ServerControl control, String operation) {
        Result<String> json = this.getPatchHistoryJSON(control, operation);
        if (json.errorMessage != null) {
            return new Result<Object>(null, json.errorMessage);
        }
        List<PatchDetails> installedPatches = PatchDetails.fromHistory((String)json.result);
        return new Result<List<PatchDetails>>(installedPatches, null);
    }

    private Result<String> getPatchHistoryJSON(ServerControl control, String operation) {
        ProcessExecutionResults results = control.cli().disconnected(true).executeCliCommand("patch history");
        switch (this.handleExecutionResults(results, null, null, false)) {
            case EXECUTION_ERROR: {
                return new Result<Object>(null, "Failed to determine the patch history while doing a " + operation + ": " + results.getError().getMessage());
            }
            case TIMEOUT: {
                return new Result<Object>(null, "Timed out while determining patch history for a " + operation + ". Output was: " + results.getCapturedOutput());
            }
            case ERROR: {
                return new Result<Object>(null, "Failed to determine the patch history for a " + operation + ". Returned error code was: " + results.getExitCode() + "\nOutput was: " + results.getCapturedOutput());
            }
        }
        return new Result<String>(results.getCapturedOutput(), null);
    }

    private Result<String[]> getPids(BundleResourceDeployment rd, String operation) {
        String[] pids;
        PropertySimple patchType = rd.getBundleDeployment().getConfiguration().getSimple("patchType");
        boolean isBundle = patchType != null && "patch-bundle".equals(patchType.getStringValue());
        PropertySimple patchIdProp = rd.getBundleDeployment().getConfiguration().getSimple("patchId");
        PropertySimple allPatchIdsProp = rd.getBundleDeployment().getConfiguration().getSimple("allPatchIds");
        if (isBundle) {
            if (allPatchIdsProp == null || allPatchIdsProp.getStringValue() == null) {
                return new Result<Object>(null, "Could not determine the list of patch ids from the bundle configuration while performing " + operation);
            }
            pids = allPatchIdsProp.getStringValue().split("#");
            Collections.reverse(Arrays.asList(pids));
        } else {
            if (patchIdProp == null || patchIdProp.getStringValue() == null) {
                return new Result<Object>(null, "Could not determine the list of patch ids from the bundle configuration while performing " + operation);
            }
            pids = new String[]{patchIdProp.getStringValue()};
        }
        return new Result<String[]>(pids, null);
    }

    private boolean isTakeOver(Configuration deploymentConfiguration) {
        PropertySimple takeOver = deploymentConfiguration.getSimple("takeOver");
        if (takeOver == null) {
            return false;
        }
        Boolean value = takeOver.getBooleanValue();
        return value != null && value != false;
    }

    private static enum ExecutionResult {
        EXECUTION_ERROR,
        TIMEOUT,
        ERROR,
        OK;


        public BundleResourceDeploymentHistory.Status status() {
            return this == OK ? BundleResourceDeploymentHistory.Status.SUCCESS : BundleResourceDeploymentHistory.Status.FAILURE;
        }
    }
}

