/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ASConnection {
    public static final String MANAGEMENT = "/management";
    private final Log log = LogFactory.getLog(ASConnection.class);
    URL url;
    String urlString;
    private ObjectMapper mapper;
    public static boolean verbose = false;
    private HttpURLConnection conn;

    public ASConnection(String host, int port) {
        try {
            this.url = new URL("http", host, port, MANAGEMENT);
            this.urlString = this.url.toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        verbose = Boolean.getBoolean("as7plugin.verbose");
        this.mapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode executeRaw(Operation operation) {
        InputStream inputStream = null;
        BufferedReader br = null;
        InputStream es = null;
        long t1 = System.currentTimeMillis();
        try {
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setDoOutput(true);
            this.conn.setRequestMethod("POST");
            OutputStream out = this.conn.getOutputStream();
            String result = this.mapper.writeValueAsString((Object)operation);
            if (verbose) {
                this.log.info((Object)("Json to send: " + result));
            }
            this.mapper.writeValue(out, (Object)operation);
            out.flush();
            out.close();
            int responseCode = this.conn.getResponseCode();
            inputStream = responseCode == 200 ? this.conn.getInputStream() : this.conn.getErrorStream();
            if (inputStream != null) {
                String line;
                br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                JsonNode operationResult = null;
                if (builder.length() > 0) {
                    String outcome = builder.toString();
                    operationResult = this.mapper.readTree(outcome);
                    if (verbose) {
                        ObjectMapper om2 = new ObjectMapper();
                        om2.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                        String tmp = om2.writeValueAsString((Object)operationResult);
                        this.log.info((Object)tmp);
                    }
                } else {
                    String outcome = "- no response from server -";
                    Result noResult = new Result();
                    noResult.setFailureDescription(outcome);
                    noResult.setOutcome("failure");
                    operationResult = this.mapper.valueToTree((Object)noResult);
                }
                JsonNode jsonNode = operationResult;
                return jsonNode;
            }
            this.log.error((Object)("IS was null and code was " + responseCode));
        }
        catch (IOException e) {
            JsonNode ret;
            this.log.error((Object)("Failed to get data: " + e.getMessage()));
            if (this.conn != null && (es = this.conn.getErrorStream()) != null) {
                BufferedReader dr = new BufferedReader(new InputStreamReader(es));
                String ignore = null;
                try {
                    while ((ignore = dr.readLine()) != null) {
                    }
                    es.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            Result failure = new Result();
            failure.setFailureDescription(e.getMessage());
            failure.setOutcome("failure");
            failure.setThrowable(e);
            JsonNode jsonNode = ret = this.mapper.valueToTree((Object)failure);
            return jsonNode;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            long t2 = System.currentTimeMillis();
            PluginStats stats = PluginStats.getInstance();
            stats.incrementRequestCount();
            stats.addRequestTime(t2 - t1);
        }
        return null;
    }

    public Result execute(Operation op) {
        return this.execute(op, false);
    }

    public ComplexResult executeComplex(Operation op) {
        return (ComplexResult)this.execute(op, true);
    }

    public Result execute(Operation op, boolean isComplex) {
        JsonNode node = this.executeRaw(op);
        if (node == null) {
            this.log.warn((Object)("Operation [" + op + "] returned null"));
        }
        try {
            Result res = isComplex ? (Result)this.mapper.readValue(node, ComplexResult.class) : (Result)this.mapper.readValue(node, Result.class);
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException, JsonMappingException {
    }
}

