/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.net.ConnectException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class BaseServerComponent
extends BaseComponent {
    private static final String SEPARATOR = "\n-----------------------\n";
    final Log log = LogFactory.getLog(BaseServerComponent.class);

    protected OperationResult restartServer(Configuration parameters, AS7Mode mode) throws Exception {
        OperationResult tmp = this.invokeOperation("shutdown", parameters);
        if (tmp.getErrorMessage() != null) {
            tmp.setErrorMessage("Restart failed while failing to shut down: " + tmp.getErrorMessage());
            return tmp;
        }
        Thread.sleep(500L);
        return this.startServer(mode);
    }

    protected OperationResult startServer(AS7Mode mode) {
        OperationResult operationResult = new OperationResult();
        String startScript = this.pluginConfiguration.getSimpleValue("startScript", mode.getStartScript());
        String baseDir = this.pluginConfiguration.getSimpleValue("baseDir", "");
        if (baseDir.isEmpty()) {
            operationResult.setErrorMessage("No base directory provided");
            return operationResult;
        }
        String script = baseDir + File.separator + startScript;
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)new File(script));
        String config = this.pluginConfiguration.getSimpleValue(mode.getConfigPropertyName(), mode.getDefaultXmlFile());
        ArrayList<String> arguments = processExecution.getArguments();
        if (arguments == null) {
            arguments = new ArrayList<String>();
            processExecution.setArguments(arguments);
        }
        if (!config.equals(mode.getDefaultXmlFile())) {
            arguments.add(mode.getConfigArg());
            arguments.add(config);
        }
        if (mode == AS7Mode.DOMAIN && !(config = this.pluginConfiguration.getSimpleValue(AS7Mode.HOST.getConfigPropertyName(), AS7Mode.HOST.getDefaultXmlFile())).equals(AS7Mode.HOST.getDefaultXmlFile())) {
            arguments.add(AS7Mode.HOST.getConfigArg());
            arguments.add(config);
        }
        processExecution.setWorkingDirectory(baseDir);
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(2000L);
        processExecution.setKillOnTimeout(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.context.getSystemInformation().executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            operationResult.setErrorMessage(results.getError().getMessage());
        } else {
            operationResult.setSimpleResult("Success");
        }
        return operationResult;
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        this.log.info((Object)("Exit code from process execution: " + results.getExitCode()));
        this.log.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    protected OperationResult postProcessResult(String name, Result res) {
        OperationResult operationResult = new OperationResult();
        if (name.equals("shutdown") || name.equals("reload")) {
            if (!res.isSuccess()) {
                if (res.getThrowable() != null && (res.getThrowable() instanceof ConnectException || res.getThrowable().getMessage().equals("Connection refused"))) {
                    operationResult.setSimpleResult("Success");
                    this.log.debug((Object)("Got a ConnectionRefused for operation " + name + " this is considered ok, as the remote server sometimes closes the communications channel before sending a reply"));
                } else {
                    operationResult.setErrorMessage(res.getFailureDescription());
                }
            } else {
                operationResult.setSimpleResult("Success");
            }
        } else if (res.isSuccess()) {
            if (res.getResult() != null) {
                operationResult.setSimpleResult(res.getResult().toString());
            } else {
                operationResult.setSimpleResult("-None provided by server-");
            }
        } else {
            operationResult.setErrorMessage(res.getFailureDescription());
        }
        return operationResult;
    }
}

