/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class HostControllerComponent
extends BaseServerComponent
implements OperationFacet {
    private final Log log = LogFactory.getLog(HostControllerComponent.class);

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("start")) {
            return this.startServer(AS7Mode.DOMAIN);
        }
        if (name.equals("restart")) {
            return this.restartServer(parameters, AS7Mode.DOMAIN);
        }
        if (name.equals("shutdown")) {
            String domainHost = this.pluginConfiguration.getSimpleValue("domainHost", "");
            if (domainHost.isEmpty()) {
                OperationResult result = new OperationResult();
                result.setErrorMessage("No domain host found - can not continue");
                return result;
            }
            Operation op = new Operation("shutdown", "host", domainHost);
            Result res = this.getASConnection().execute(op);
            return this.postProcessResult(name, res);
        }
        return super.invokeOperation(name, parameters);
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        Result res;
        if (report.getPackageDetails() != null) {
            return super.deployContent(report);
        }
        String name = report.getUserSpecifiedResourceName();
        Address address = new Address(this.path);
        address.add("server-group", name);
        Operation op = new Operation("add", address);
        Configuration rc = report.getResourceConfiguration();
        String profile = rc.getSimpleValue("profile", "");
        if (profile.isEmpty()) {
            report.setErrorMessage("No profile given");
            report.setStatus(CreateResourceStatus.FAILURE);
            return report;
        }
        op.addAdditionalProperty("profile", profile);
        String socketBindingGroup = rc.getSimpleValue("socket-binding-group", "");
        if (socketBindingGroup.isEmpty()) {
            report.setErrorMessage("No socket-binding-group given");
            report.setStatus(CreateResourceStatus.FAILURE);
            return report;
        }
        op.addAdditionalProperty("socket-binding-group", socketBindingGroup);
        PropertySimple offset = rc.getSimple("socket-binding-port-offset");
        if (offset != null && offset.getStringValue() != null) {
            op.addAdditionalProperty("socket-binding-port-offset", offset.getIntegerValue());
        }
        if ((res = this.getASConnection().execute(op)).isSuccess()) {
            report.setResourceKey(address.getPath());
            report.setResourceName(name);
            report.setStatus(CreateResourceStatus.SUCCESS);
        } else {
            report.setErrorMessage(res.getFailureDescription());
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setException(res.getThrowable());
        }
        return report;
    }
}

