/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ManagedASComponent
extends BaseComponent {
    @Override
    public AvailabilityType getAvailability() {
        if (this.context.getResourceType().getName().equals("JBossAS-Managed")) {
            Address theAddress = new Address();
            String host = this.pluginConfiguration.getSimpleValue("domainHost", "local");
            theAddress.add("host", host);
            theAddress.add("server-config", this.myServerName);
            ReadAttribute getStatus = new ReadAttribute(theAddress, "status");
            Result result = null;
            try {
                result = this.connection.execute(getStatus);
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage());
                return AvailabilityType.DOWN;
            }
            if (!result.isSuccess()) {
                return AvailabilityType.DOWN;
            }
            String msg = result.getResult().toString();
            if (msg.contains("STARTED")) {
                return AvailabilityType.UP;
            }
            return AvailabilityType.DOWN;
        }
        return super.getAvailability();
    }
}

