/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.w3c.dom.Document;

public class AbstractBaseDiscovery {
    static final String DORG_JBOSS_BOOT_LOG_FILE = "-Dorg.jboss.boot.log.file=";
    private static final String DJBOSS_SERVER_HOME_DIR = "-Djboss.home.dir";
    static final int DEFAULT_MGMT_PORT = 9990;
    private static final String JBOSS_AS_PREFIX = "jboss-as-";
    static final String CALL_READ_STANDALONE_OR_HOST_XML_FIRST = "hostXml is null. You need to call 'readStandaloneOrHostXml' first.";
    protected Document hostXml;
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final String JBOSS_EAP_PREFIX = "jboss-eap-";
    private XPathFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBaseDiscovery() {
        AbstractBaseDiscovery abstractBaseDiscovery = this;
        synchronized (abstractBaseDiscovery) {
            this.factory = XPathFactory.newInstance();
        }
    }

    protected void readStandaloneOrHostXml(ProcessInfo processInfo, boolean isDomainMode) {
        String hostXmlFile = this.getHostXmlFileLocation(processInfo, isDomainMode);
        this.readStandaloneOrHostXmlFromFile(hostXmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readStandaloneOrHostXmlFromFile(String hostXmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream is = new FileInputStream(hostXmlFile);
            try {
                this.hostXml = builder.parse(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    String getHomeDirFromCommandLine(String[] commandLine) {
        for (String line : commandLine) {
            if (!line.startsWith(DJBOSS_SERVER_HOME_DIR)) continue;
            return line.substring(DJBOSS_SERVER_HOME_DIR.length() + 1);
        }
        return "";
    }

    String getLogFileFromCommandLine(String[] commandLine) {
        for (String line : commandLine) {
            if (!line.startsWith(DORG_JBOSS_BOOT_LOG_FILE)) continue;
            return line.substring(DORG_JBOSS_BOOT_LOG_FILE.length());
        }
        return "";
    }

    protected HostPort getManagementPortFromHostXml(String[] commandLine) {
        String interfaceName;
        String portString;
        String interfaceExpession;
        if (this.hostXml == null) {
            throw new IllegalArgumentException(CALL_READ_STANDALONE_OR_HOST_XML_FIRST);
        }
        String socketBindingName = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/socket-binding/@http");
        String socketInterface = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/socket/@interface");
        if (!socketInterface.isEmpty()) {
            interfaceExpession = this.obtainXmlPropertyViaXPath("//interfaces/interface[@name='" + socketInterface + "']/inet-address/@value");
            portString = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/socket/@port");
        } else if (socketBindingName.isEmpty()) {
            portString = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/@port");
            interfaceName = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/@interface");
            interfaceExpession = this.obtainXmlPropertyViaXPath("/server/interfaces/interface[@name='" + interfaceName + "']/inet-address/@value");
        } else {
            portString = this.obtainXmlPropertyViaXPath("/server/socket-binding-group/socket-binding[@name='" + socketBindingName + "']/@port");
            interfaceName = this.obtainXmlPropertyViaXPath("/server/socket-binding-group/socket-binding[@name='" + socketBindingName + "']/@interface");
            interfaceExpession = this.obtainXmlPropertyViaXPath("/server/interfaces/interface[@name='" + interfaceName + "']/inet-address/@value");
        }
        HostPort hp = new HostPort();
        hp.host = !interfaceExpession.isEmpty() ? this.replaceDollarExpression(interfaceExpession, commandLine, "localhost") : "localhost";
        if (portString != null && !portString.isEmpty()) {
            String tmp = this.replaceDollarExpression(portString, commandLine, "9990");
            hp.port = Integer.valueOf(tmp);
        } else {
            hp.port = 9990;
        }
        return hp;
    }

    private String replaceDollarExpression(String value, String[] commandLine, String lastResort) {
        String expression;
        if (!value.contains("${")) {
            return value;
        }
        value = value.substring(2, value.length() - 1);
        String fallback = lastResort;
        if (value.contains(":")) {
            int i = value.indexOf(":");
            expression = value.substring(0, i);
            fallback = value.substring(i + 1);
        } else {
            expression = value;
        }
        String ret = null;
        int commandLineLength = commandLine.length;
        for (int i = 0; i < commandLineLength; ++i) {
            String line = commandLine[i];
            if (expression.contains("address")) {
                if (!line.contains("-bmanagement") && !line.contains("jboss.bind.address.management")) continue;
                if (line.contains("=")) {
                    ret = line.substring(line.indexOf("=") + 1);
                    break;
                }
                ret = commandLine[i + 1];
                break;
            }
            if (!expression.contains("port") || !line.contains(expression)) continue;
            ret = line.substring(line.indexOf("=") + 1);
            break;
        }
        if (ret == null) {
            ret = fallback;
        }
        return ret;
    }

    protected String findHostName() {
        if (this.hostXml == null) {
            throw new IllegalArgumentException(CALL_READ_STANDALONE_OR_HOST_XML_FIRST);
        }
        String hostName = this.hostXml.getDocumentElement().getAttribute("name");
        return hostName;
    }

    protected HostPort getDomainControllerFromHostXml() {
        HostPort hp;
        if (this.hostXml == null) {
            throw new IllegalArgumentException(CALL_READ_STANDALONE_OR_HOST_XML_FIRST);
        }
        String remoteHost = this.obtainXmlPropertyViaXPath("/host/domain-controller/remote/@host");
        String portString = this.obtainXmlPropertyViaXPath("/host/domain-controller/remote/@port");
        if (!remoteHost.isEmpty() && !portString.isEmpty()) {
            hp = new HostPort(false);
            hp.host = remoteHost;
            hp.port = Integer.parseInt(portString);
        } else {
            hp = new HostPort(true);
            hp.port = 9999;
        }
        return hp;
    }

    String getManagementSecurtiyRealmFromHostXml() {
        if (this.hostXml == null) {
            throw new IllegalArgumentException(CALL_READ_STANDALONE_OR_HOST_XML_FIRST);
        }
        String realm = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/@security-realm");
        return realm;
    }

    String getSecurityPropertyFileFromHostXml(String baseDir, AS7Mode mode, String realm) {
        if (this.hostXml == null) {
            throw new IllegalArgumentException(CALL_READ_STANDALONE_OR_HOST_XML_FIRST);
        }
        String fileName = this.obtainXmlPropertyViaXPath("//security-realms/security-realm[@name='" + realm + "']/authentication/properties/@path");
        String relDir = this.obtainXmlPropertyViaXPath("//security-realms/security-realm[@name='" + realm + "']/authentication/properties/@relative-to");
        String dmode = mode == AS7Mode.STANDALONE ? "server" : "domain";
        String fullName = relDir.equals("jboss." + dmode + ".config.dir") ? baseDir + File.separator + mode.getBaseDir() + File.separator + "configuration" + File.separator + fileName : relDir + File.separator + fileName;
        return fullName;
    }

    protected String getHostXmlFileLocation(ProcessInfo processInfo, boolean isDomain) {
        String home = processInfo.getEnvironmentVariable("jboss.home.dir");
        if (home == null) {
            home = this.getHomeDirFromCommandLine(processInfo.getCommandLine());
        }
        StringBuilder builder = new StringBuilder(home);
        if (isDomain) {
            builder.append(File.separator).append(AS7Mode.DOMAIN.getBaseDir());
        } else {
            builder.append(File.separator).append(AS7Mode.STANDALONE.getBaseDir());
        }
        builder.append(File.separator).append("configuration");
        if (isDomain) {
            builder.append(File.separator).append(AS7Mode.HOST.getDefaultXmlFile());
        } else {
            builder.append(File.separator).append(AS7Mode.STANDALONE.getDefaultXmlFile());
        }
        return builder.toString();
    }

    protected String determineServerVersionFromHomeDir(String homeDir) {
        String tmp = homeDir.substring(homeDir.lastIndexOf("/") + 1);
        String version = tmp.startsWith(JBOSS_AS_PREFIX) ? tmp.substring(JBOSS_AS_PREFIX.length()) : (tmp.startsWith(JBOSS_EAP_PREFIX) ? tmp.substring(JBOSS_EAP_PREFIX.length()) : homeDir.substring(homeDir.lastIndexOf("-") + 1));
        return version;
    }

    protected String obtainXmlPropertyViaXPath(String xpathExpression) {
        if (this.hostXml == null) {
            throw new IllegalArgumentException(CALL_READ_STANDALONE_OR_HOST_XML_FIRST);
        }
        XPath xpath = this.factory.newXPath();
        try {
            XPathExpression expr = xpath.compile(xpathExpression);
            Object result = expr.evaluate(this.hostXml, XPathConstants.STRING);
            return result.toString();
        }
        catch (XPathExpressionException e) {
            this.log.error((Object)("Evaluation XPath expression failed: " + e.getMessage()));
            return null;
        }
    }

    protected static class HostPort {
        String host = "localhost";
        int port = 9990;
        boolean isLocal = true;

        public HostPort() {
        }

        public HostPort(boolean local) {
            this();
            this.isLocal = local;
        }

        public String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + ", isLocal=" + this.isLocal + '}';
        }
    }
}

