/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.modules.plugins.jbossas7.AS7Authenticator;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ASConnection {
    public static final String MANAGEMENT = "/management";
    private static final String FAILURE_DESCRIPTION = "\"failure-description\"";
    public static boolean verbose = false;
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private final Log log = LogFactory.getLog(ASConnection.class);
    private URL url;
    private String urlString;
    private ObjectMapper mapper;
    private Authenticator passwordAuthenticator;
    private String host;
    private int port;

    public ASConnection(String host, int port, String user, String password) {
        if (host == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.host = host;
        this.port = port;
        try {
            this.url = new URL("http", host, port, MANAGEMENT);
            this.urlString = this.url.toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.passwordAuthenticator = new AS7Authenticator(user, password);
        Authenticator.setDefault(this.passwordAuthenticator);
        verbose = Boolean.getBoolean("as7plugin.verbose");
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JsonNode executeRaw(Operation operation) {
        return this.executeRaw(operation, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode executeRaw(Operation operation, int timeoutSec) {
        OutputStream out;
        HttpURLConnection conn;
        long requestStartTime = System.currentTimeMillis();
        try {
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Content-Type", "application/json");
            conn.addRequestProperty("Accept", "application/json");
            conn.setInstanceFollowRedirects(false);
            int timeoutMillis = timeoutSec * 1000;
            conn.setConnectTimeout(timeoutMillis);
            conn.setReadTimeout(timeoutMillis);
            if (conn.getReadTimeout() != timeoutMillis) {
                this.log.warn((Object)"Read timeout did not get set on HTTP connection - the JRE uses a broken timeout mechanism - nothing we can do.");
            }
            out = conn.getOutputStream();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Failed to open connection to [" + this.urlString + "] in order to invoke [" + operation + "]: " + e));
            }
            Result failure = new Result();
            failure.setFailureDescription(e.toString());
            failure.setOutcome("failure");
            failure.setRhqThrowable(e);
            JsonNode ret = this.mapper.valueToTree((Object)failure);
            return ret;
        }
        try {
            InputStream inputStream;
            String json_to_send = this.mapper.writeValueAsString((Object)operation);
            if (operation != null && operation.getAddress() != null && operation.getAddress().getPath() != null && this.containsSpaces(operation.getAddress().getPath())) {
                JsonNode invalidPathResult;
                Result noResult = new Result();
                String outcome = "- Path '" + operation.getAddress().getPath() + "' is invalid as it contains spaces -";
                if (verbose) {
                    this.log.error((Object)outcome);
                }
                noResult.setFailureDescription(outcome);
                noResult.setOutcome("failure");
                JsonNode jsonNode = invalidPathResult = this.mapper.valueToTree((Object)noResult);
                return jsonNode;
            }
            if (verbose) {
                this.log.info((Object)("JSON to send: " + json_to_send));
            }
            this.mapper.writeValue(out, (Object)operation);
            out.flush();
            out.close();
            InputStream inputStream2 = inputStream = conn.getInputStream() != null ? conn.getInputStream() : conn.getErrorStream();
            if (inputStream != null) {
                JsonNode operationResult;
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
                String responseBody = StreamUtil.slurp((Reader)inputReader);
                if (!responseBody.isEmpty()) {
                    String outcome = responseBody;
                    operationResult = this.mapper.readTree(outcome);
                    if (verbose) {
                        ObjectMapper om2 = new ObjectMapper();
                        om2.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                        String tmp = om2.writeValueAsString((Object)operationResult);
                        this.log.info((Object)tmp);
                    }
                } else {
                    int responseCode = conn.getResponseCode();
                    if (this.isAuthorizationFailureResponse(responseCode)) {
                        this.handleAuthorizationFailureResponse(operation, conn);
                    }
                    Result noResult = new Result();
                    noResult.setOutcome("failure");
                    String responseCodeString = conn.getResponseCode() + " (" + this.getResponseMessage(conn) + ")";
                    noResult.setFailureDescription("- empty response body with HTTP status code " + responseCodeString + " -");
                    operationResult = this.mapper.valueToTree((Object)noResult);
                }
                JsonNode responseCode = operationResult;
                return responseCode;
            }
        }
        catch (IllegalArgumentException iae) {
            this.log.error((Object)("Illegal argument for input " + operation + ": " + iae.getMessage()));
        }
        catch (SocketTimeoutException ste) {
            JsonNode ret;
            this.log.error((Object)(operation + " timed out: " + ste.getMessage()));
            conn.disconnect();
            Result failure = new Result();
            failure.setFailureDescription(ste.getMessage());
            failure.setOutcome("failure");
            failure.setRhqThrowable(ste);
            JsonNode responseBody = ret = this.mapper.valueToTree((Object)failure);
            return responseBody;
        }
        catch (IOException e) {
            String responseCodeString;
            String responseBody;
            if (conn.getErrorStream() != null) {
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                responseBody = StreamUtil.slurp((Reader)errorReader);
            } else {
                responseBody = "";
            }
            try {
                int responseCode = conn.getResponseCode();
                responseCodeString = responseCode + " (" + this.getResponseMessage(conn) + ")";
                if (this.isAuthorizationFailureResponse(responseCode)) {
                    this.handleAuthorizationFailureResponse(operation, conn);
                } else if (responseBody == null || responseBody.isEmpty()) {
                    this.log.warn((Object)("Response body for " + operation + " was empty and response code was " + responseCodeString + "."));
                } else if (responseBody.contains("JBAS014807") || responseBody.contains("JBAS010850") || responseBody.contains("JBAS014793")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Requested management resource not found: " + operation.getAddress().getPath()));
                    }
                } else {
                    this.log.warn((Object)("We got a " + responseCode + " with the following response body back: " + responseBody));
                }
            }
            catch (IOException ioe) {
                responseCodeString = "unknown response code";
            }
            String failureDescription = operation + " failed with " + responseCodeString + " - response body was [" + responseBody + "].";
            if (verbose) {
                this.log.debug((Object)failureDescription);
            }
            JsonNode operationResult = null;
            if (!responseBody.isEmpty()) {
                try {
                    operationResult = this.mapper.readTree(responseBody);
                }
                catch (IOException ioe) {
                    this.log.error((Object)("Failed to deserialize response body [" + responseBody + "] to JsonNode: " + ioe));
                }
            }
            if (operationResult == null) {
                Result result = new Result();
                result.setOutcome("failure");
                result.setFailureDescription(failureDescription);
                result.setRolledBack(responseBody.contains("rolled-back=true"));
                result.setRhqThrowable(e);
                operationResult = this.mapper.valueToTree((Object)result);
            }
            JsonNode jsonNode = operationResult;
            return jsonNode;
        }
        finally {
            long requestEndTime = System.currentTimeMillis();
            PluginStats stats = PluginStats.getInstance();
            stats.incrementRequestCount();
            stats.addRequestTime(requestEndTime - requestStartTime);
        }
        return null;
    }

    private boolean isAuthorizationFailureResponse(int responseCode) {
        return responseCode == 401 || responseCode == 307;
    }

    private void handleAuthorizationFailureResponse(Operation operation, HttpURLConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            String responseCodeString = conn.getResponseCode() + " (" + this.getResponseMessage(conn) + ")";
            this.log.debug((Object)("Response to " + operation + " was " + responseCodeString + " - throwing InvalidPluginConfigurationException..."));
        }
        String message = conn.getResponseCode() == 401 ? "Credentials for plugin to connect to AS7 management interface are invalid - update Connection Settings with valid credentials." : "Authorization to AS7 failed - did you install a management user?";
        throw new InvalidPluginConfigurationException(message);
    }

    private String getResponseMessage(HttpURLConnection conn) throws IOException {
        String responseMessage = conn.getResponseMessage();
        if (responseMessage == null && conn.getResponseCode() == 307) {
            responseMessage = "Temporary Redirect";
        }
        return responseMessage;
    }

    private boolean containsSpaces(String path) {
        boolean includesSpaces = false;
        StringTokenizer components = new StringTokenizer(path, " ");
        if (components.countTokens() > 1) {
            includesSpaces = true;
        }
        return includesSpaces;
    }

    public Result execute(Operation op) {
        return this.execute(op, false, 10);
    }

    public Result execute(Operation op, int timeoutSec) {
        return this.execute(op, false, timeoutSec);
    }

    public ComplexResult executeComplex(Operation op) {
        return (ComplexResult)this.execute(op, true, 10);
    }

    public ComplexResult executeComplex(Operation op, int timeoutSec) {
        return (ComplexResult)this.execute(op, true, timeoutSec);
    }

    public Result execute(Operation op, boolean isComplex) {
        return this.execute(op, isComplex, 10);
    }

    public Result execute(Operation op, boolean isComplex, int timeoutSec) {
        JsonNode node = this.executeRaw(op, timeoutSec);
        if (node == null) {
            this.log.warn((Object)("Operation [" + op + "] returned null"));
            Result failure = new Result();
            failure.setFailureDescription("Operation [" + op + "] returned null");
            return failure;
        }
        try {
            String as7ResultSerialization = node.toString();
            if (as7ResultSerialization.indexOf(FAILURE_DESCRIPTION) > -1 && verbose) {
                this.log.warn((Object)("------ Detected 'failure-description' when communicating with server." + as7ResultSerialization));
            }
            Result res = isComplex ? (Result)this.mapper.readValue(node, ComplexResult.class) : (Result)this.mapper.readValue(node, Result.class);
            return res;
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            if (verbose) {
                this.log.error((Object)("----------- Operation execution unparsable. Request :[" + op + "] Response:<" + node + ">"));
            }
            Result failure = new Result();
            failure.setFailureDescription("Operation <" + op + "> returned unparsable JSON, <" + node + ">.");
            return failure;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

