/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.modules.plugins.jbossas7.AS7Authenticator;
import org.rhq.modules.plugins.jbossas7.ASConnection;

public class ASUploadConnection {
    private static final String BOUNDARY_PARAM = "NeAG1QNIHHOyB5joAS7Rox!!";
    private static final String BOUNDARY = "--NeAG1QNIHHOyB5joAS7Rox!!";
    private static final String CRLF = "\r\n";
    private static final String POST_REQUEST_METHOD = "POST";
    private static final String UPLOAD_URL_PATH = "/management/add-content";
    private static final Log log = LogFactory.getLog(ASUploadConnection.class);
    Authenticator passwordAuthenticator;
    BufferedOutputStream os = null;
    InputStream is = null;
    private HttpURLConnection connection;
    private String host;
    private int port;
    private int timeout;
    private static final int DEFAULT_TIMEOUT = 60;

    public ASUploadConnection(String dcHost, int port, String user, String password) {
        if (dcHost == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.host = dcHost;
        this.port = port;
        if (user != null) {
            this.passwordAuthenticator = new AS7Authenticator(user, password);
            Authenticator.setDefault(this.passwordAuthenticator);
        }
        this.timeout = 60;
    }

    public ASUploadConnection(ASConnection asConnection) {
        this.host = asConnection.getHost();
        this.port = asConnection.getPort();
        this.timeout = 60;
    }

    public OutputStream getOutputStream(String fileName) {
        String url = "http://" + this.host + ":" + this.port + UPLOAD_URL_PATH;
        try {
            this.connection = (HttpURLConnection)new URL(url).openConnection();
            this.connection.setConnectTimeout(30000);
            this.connection.setReadTimeout(this.timeout * 1000);
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setRequestMethod(POST_REQUEST_METHOD);
            this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=NeAG1QNIHHOyB5joAS7Rox!!");
            this.os = new BufferedOutputStream(this.connection.getOutputStream());
            this.os.write(this.buildPostRequestHeader(fileName));
            return this.os;
        }
        catch (Exception e) {
            log.error((Object)("Failed to open output stream to URL [" + url + "]: " + e), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode finishUpload() {
        JsonNode tree = null;
        try {
            this.os.write(this.buildPostRequestFooter());
            this.os.flush();
            int code = this.connection.getResponseCode();
            if (code != 200) {
                log.warn((Object)("Response code for file upload: " + code + " " + this.connection.getResponseMessage()));
            }
            this.is = code == 500 ? this.connection.getErrorStream() : this.connection.getInputStream();
            if (this.is != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.is));
                StringBuilder builder = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    builder.append(line);
                }
                ObjectMapper mapper = new ObjectMapper();
                String s = builder.toString();
                if (s != null) {
                    tree = mapper.readTree(s);
                } else {
                    log.warn((Object)"- no result received from InputStream -");
                }
            } else {
                log.warn((Object)"- no InputStream available -");
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            this.closeQuietly(this.is);
            this.closeQuietly(this.os);
        }
        return tree;
    }

    private byte[] buildPostRequestHeader(String fileName) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)this.buildPostRequestHeaderSection("form-data; name=\"file\"; filename=\"" + fileName + "\"", "application/octet-stream", ""));
        return builder.toString().getBytes("US-ASCII");
    }

    private StringBuilder buildPostRequestHeaderSection(String contentDisposition, String contentType, String content) {
        StringBuilder builder = new StringBuilder();
        builder.append(BOUNDARY);
        builder.append(CRLF);
        if (contentDisposition != null && contentDisposition.length() > 0) {
            builder.append(String.format("Content-Disposition: %s", contentDisposition));
        }
        builder.append(CRLF);
        if (contentType != null && contentType.length() > 0) {
            builder.append(String.format("Content-Type: %s", contentType));
        }
        builder.append(CRLF);
        if (content != null && content.length() > 0) {
            builder.append(content);
        }
        builder.append(CRLF);
        return builder;
    }

    private byte[] buildPostRequestFooter() throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(CRLF);
        builder.append(BOUNDARY);
        builder.append("--");
        builder.append(CRLF);
        return builder.toString().getBytes("US-ASCII");
    }

    public static String getFailureDescription(JsonNode jsonNode) {
        if (jsonNode == null) {
            return "getFailureDescription: -input was null-";
        }
        JsonNode node = jsonNode.findValue("failure-description");
        return node.getValueAsText();
    }

    static boolean isErrorReply(JsonNode in) {
        if (in == null) {
            return true;
        }
        if (in.has("outcome")) {
            String outcome = null;
            try {
                JsonNode outcomeNode = in.findValue("outcome");
                outcome = outcomeNode.getTextValue();
                if (outcome.equals("failed")) {
                    JsonNode reasonNode = in.findValue("failure-description");
                    String reason = reasonNode.getTextValue();
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                return true;
            }
        }
        return false;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

