/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.AS7Component;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.CreateResourceDelegate;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Remove;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class BaseComponent<T extends ResourceComponent<?>>
implements AS7Component<T>,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet,
CreateChildResourceFacet,
OperationFacet {
    private static final String INTERNAL = "_internal:";
    private static final int INTERNAL_SIZE = "_internal:".length();
    public static final String MANAGED_SERVER = "Managed Server";
    final Log log = LogFactory.getLog(this.getClass());
    ResourceContext<T> context;
    Configuration pluginConfiguration;
    String myServerName;
    String path;
    Address address;
    String key;
    private boolean verbose = ASConnection.verbose;
    private BaseServerComponent serverComponent;
    protected ASConnection testConnection;

    public void start(ResourceContext<T> context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        this.pluginConfiguration = context.getPluginConfiguration();
        this.serverComponent = this.findServerComponent();
        this.path = this.pluginConfiguration.getSimpleValue("path");
        this.address = new Address(this.path);
        this.key = context.getResourceKey();
        this.myServerName = context.getResourceKey().substring(context.getResourceKey().lastIndexOf("/") + 1);
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        ReadResource op = new ReadResource(this.address);
        Result res = this.getASConnection().execute(op);
        return res != null && res.isSuccess() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    private BaseServerComponent findServerComponent() {
        BaseComponent component = this;
        while (component != null && !(component instanceof BaseServerComponent)) {
            component = (BaseComponent)component.context.getParentResourceComponent();
        }
        return (BaseServerComponent)component;
    }

    public BaseServerComponent getServerComponent() {
        return this.serverComponent;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            ReadAttribute op;
            if (req.getName().startsWith(INTERNAL)) {
                this.processPluginStats(req, report);
                continue;
            }
            String reqName = req.getName();
            ComplexRequest request = null;
            if (reqName.contains(":")) {
                request = ComplexRequest.create(reqName);
                op = new ReadAttribute(this.address, request.getProp());
            } else {
                op = new ReadAttribute(this.address, reqName);
            }
            Result res = this.getASConnection().execute(op);
            if (!res.isSuccess()) {
                this.log.warn((Object)("Getting metric [" + req.getName() + "] at [ " + this.address + "] failed: " + res.getFailureDescription()));
                continue;
            }
            Object val = res.getResult();
            if (val == null) continue;
            if (req.getDataType() == DataType.MEASUREMENT) {
                if (val.equals("no metrics available")) continue;
                try {
                    if (request != null) {
                        HashMap myValues = (HashMap)val;
                        for (String key : myValues.keySet()) {
                            String sub;
                            if (!key.equals(sub = request.getSub())) continue;
                            this.addMetric2Report(report, req, myValues.get(key));
                        }
                        continue;
                    }
                    this.addMetric2Report(report, req, val);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Non numeric input for [" + req.getName() + "] : [" + val + "]"));
                }
                continue;
            }
            if (req.getDataType() != DataType.TRAIT) continue;
            String realVal = this.getStringValue(val);
            MeasurementDataTrait data = new MeasurementDataTrait(req, realVal);
            report.addData(data);
        }
    }

    private void addMetric2Report(MeasurementReport report, MeasurementScheduleRequest req, Object val) {
        Double d = Double.parseDouble(this.getStringValue(val));
        MeasurementDataNumeric data = new MeasurementDataNumeric(req, d);
        report.addData(data);
    }

    protected String getStringValue(Object val) {
        String realVal = "";
        realVal = val instanceof String ? (String)val : String.valueOf(val);
        return realVal;
    }

    private void processPluginStats(MeasurementScheduleRequest req, MeasurementReport report) {
        String name = req.getName();
        if (!name.startsWith(INTERNAL)) {
            return;
        }
        name = name.substring(INTERNAL_SIZE);
        PluginStats stats = PluginStats.getInstance();
        Double val = name.equals("mgmtRequests") ? Double.valueOf(stats.getRequestCount()) : (name.equals("requestTime") ? Double.valueOf(stats.getRequestTime()) : (name.equals("maxTime") ? Double.valueOf(stats.getMaxTime()) : Double.valueOf(Double.NaN)));
        MeasurementDataNumeric data = new MeasurementDataNumeric(req, val);
        report.addData(data);
    }

    @Override
    public ASConnection getASConnection() {
        return this.testConnection != null ? this.testConnection : this.getServerComponent().getASConnection();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        ConfigurationLoadDelegate delegate = new ConfigurationLoadDelegate(configDef, this.getASConnection(), this.address);
        return delegate.loadResourceConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.getASConnection(), this.address);
        delegate.updateResourceConfiguration(report);
    }

    public void deleteResource() throws Exception {
        Result res;
        this.log.info((Object)("delete resource: " + this.path + " ..."));
        if (this.context.getResourceType().getName().equals(MANAGED_SERVER)) {
            Operation stop = new Operation("stop", this.getAddress());
            res = this.getASConnection().execute(stop);
            if (!res.isSuccess()) {
                throw new IllegalStateException("Managed server @ " + this.path + " is still running and can't be stopped. Can't remove it");
            }
        }
        Remove op = new Remove(this.address);
        res = this.getASConnection().execute(op);
        if (!res.isSuccess()) {
            throw new IllegalArgumentException("Delete for [" + this.path + "] failed: " + res.getFailureDescription());
        }
        if (this.path.contains("server-group")) {
            // empty if block
        }
        this.log.info((Object)"   ... done");
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        if (report.getPackageDetails() != null) {
            return this.deployContent(report);
        }
        ASConnection connection = this.getASConnection();
        ConfigurationDefinition configDef = report.getResourceType().getResourceConfigurationDefinition();
        boolean isSingleton = report.getResourceType().isSingleton();
        if (isSingleton) {
            List entries;
            Configuration pluginConfig = report.getPluginConfiguration();
            PropertySimple pathProperty = pluginConfig.getSimple("path");
            if (this.path == null || this.path.isEmpty()) {
                report.setErrorMessage("No path property found in plugin configuration");
                report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
                return report;
            }
            ReadChildrenNames op = new ReadChildrenNames(this.address, pathProperty.getStringValue());
            Result res = connection.execute(op);
            if (res.isSuccess() && !(entries = (List)res.getResult()).isEmpty()) {
                report.setErrorMessage("Resource is a singleton, but there are already children " + entries + " please remove them and retry");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
        }
        CreateResourceDelegate delegate = new CreateResourceDelegate(configDef, connection, this.address);
        return delegate.createResource(report);
    }

    protected CreateResourceReport deployContent(CreateResourceReport report) {
        String runtimeName;
        ContentContext cctx = this.context.getContentContext();
        ResourcePackageDetails details = report.getPackageDetails();
        ContentServices contentServices = cctx.getContentServices();
        String resourceTypeName = report.getResourceType().getName();
        ServerPluginConfiguration serverPluginConfig = this.getServerComponent().getServerPluginConfiguration();
        ASUploadConnection uploadConnection = new ASUploadConnection(serverPluginConfig.getHostname(), serverPluginConfig.getPort(), serverPluginConfig.getUser(), serverPluginConfig.getPassword());
        OutputStream out = uploadConnection.getOutputStream(details.getFileName());
        contentServices.downloadPackageBitsForChildResource(cctx, resourceTypeName, details.getKey(), out);
        JsonNode uploadResult = uploadConnection.finishUpload();
        if (this.verbose) {
            this.log.info((Object)uploadResult);
        }
        if (ASUploadConnection.isErrorReply(uploadResult)) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage(ASUploadConnection.getFailureDescription(uploadResult));
            return report;
        }
        String fileName = details.getFileName();
        if (fileName.startsWith("C:\\fakepath\\")) {
            fileName = fileName.substring("C:\\fakepath\\".length());
        }
        if ((runtimeName = report.getPackageDetails().getDeploymentTimeConfiguration().getSimpleValue("runtimeName")) == null || runtimeName.isEmpty()) {
            runtimeName = fileName;
        }
        JsonNode resultNode = uploadResult.get("result");
        String hash = resultNode.get("BYTES_VALUE").getTextValue();
        return this.runDeploymentMagicOnServer(report, runtimeName, fileName, hash);
    }

    public CreateResourceReport runDeploymentMagicOnServer(CreateResourceReport report, String runtimeName, String deploymentName, String hash) {
        String resourceKey;
        Result result;
        boolean toServerGroup = this.context.getResourceKey().contains("server-group=");
        this.log.info((Object)("Deploying [" + runtimeName + "] to domain only= " + !toServerGroup + " ..."));
        ASConnection connection = this.getASConnection();
        Operation step1 = new Operation("add", "deployment", runtimeName);
        ArrayList content = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
        content.add(contentValues);
        step1.addAdditionalProperty("content", content);
        step1.addAdditionalProperty("name", deploymentName);
        step1.addAdditionalProperty("runtime-name", runtimeName);
        CompositeOperation cop = new CompositeOperation();
        cop.addStep(step1);
        if (!toServerGroup) {
            if (this.context.getResourceType().getName().contains("Standalone")) {
                Operation step2 = new Operation("deploy", step1.getAddress());
                cop.addStep(step2);
            }
            result = connection.execute(cop);
            resourceKey = step1.getAddress().getPath();
        } else {
            Address serverGroupAddress = new Address(this.context.getResourceKey());
            serverGroupAddress.add("deployment", deploymentName);
            Operation step2 = new Operation("add", serverGroupAddress);
            cop.addStep(step2);
            Operation step3 = new Operation("deploy", serverGroupAddress);
            cop.addStep(step3);
            resourceKey = serverGroupAddress.getPath();
            if (this.verbose) {
                this.log.info((Object)("Deploy operation: " + cop));
            }
            result = connection.execute(cop);
        }
        if (!result.isSuccess()) {
            String failureDescription = result.getFailureDescription();
            report.setErrorMessage(failureDescription);
            report.setStatus(CreateResourceStatus.FAILURE);
            this.log.warn((Object)(" ... done with failure: " + failureDescription));
        } else {
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceName(runtimeName);
            report.setResourceKey(resourceKey);
            report.getPackageDetails().setSHA256(hash);
            report.getPackageDetails().setInstallationTimestamp(System.currentTimeMillis());
            this.log.info((Object)(" ... with success and key [" + resourceKey + "]"));
        }
        return report;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        Operation operation;
        block17: {
            String op;
            String what;
            block18: {
                String selector;
                Address theAddress;
                block16: {
                    if (name.contains(":")) {
                        int colonPos = name.indexOf(58);
                        what = name.substring(0, colonPos);
                        op = name.substring(colonPos + 1);
                    } else {
                        what = "";
                        op = name;
                    }
                    operation = null;
                    theAddress = new Address();
                    if (!what.equals("server-group")) break block16;
                    String groupName = parameters.getSimpleValue("name", "");
                    String profile = parameters.getSimpleValue("profile", "default");
                    theAddress.add("server-group", groupName);
                    operation = new Operation(op, theAddress);
                    operation.addAdditionalProperty("profile", profile);
                    break block17;
                }
                if (!what.equals("destination")) break block18;
                theAddress.add(this.address);
                String newName = parameters.getSimpleValue("name", "");
                String type = parameters.getSimpleValue("type", "jms-queue").toLowerCase();
                theAddress.add(type, newName);
                PropertyList jndiNamesProp = parameters.getList("entries");
                if (jndiNamesProp == null || jndiNamesProp.getList().isEmpty()) {
                    OperationResult fail = new OperationResult();
                    fail.setErrorMessage("No jndi bindings given");
                    return fail;
                }
                ArrayList<String> jndiNames = new ArrayList<String>();
                for (Property p : jndiNamesProp.getList()) {
                    PropertySimple ps = (PropertySimple)p;
                    jndiNames.add(ps.getStringValue());
                }
                operation = new Operation(op, theAddress);
                operation.addAdditionalProperty("entries", jndiNames);
                if (!type.equals("jms-queue")) break block17;
                PropertySimple ps = (PropertySimple)parameters.get("durable");
                if (ps != null) {
                    boolean durable = ps.getBooleanValue();
                    operation.addAdditionalProperty("durable", durable);
                }
                if ((selector = parameters.getSimpleValue("selector", "")).isEmpty()) break block17;
                operation.addAdditionalProperty("selector", selector);
                break block17;
            }
            if (what.equals("domain")) {
                operation = new Operation(op, new Address());
            } else if (what.equals("subsystem")) {
                operation = new Operation(op, new Address(this.path));
            } else {
                operation = new Operation(op, new Address(this.path));
                for (Property prop : parameters.getProperties()) {
                    if (prop instanceof PropertySimple) {
                        PropertySimple ps = (PropertySimple)prop;
                        if (ps.getStringValue() == null) continue;
                        Object val = this.getObjectForProperty(ps, op);
                        operation.addAdditionalProperty(ps.getName(), val);
                        continue;
                    }
                    if (prop instanceof PropertyList) {
                        PropertyList pl = (PropertyList)prop;
                        ArrayList<Object> items = new ArrayList<Object>(pl.getList().size());
                        for (Property p2 : pl.getList()) {
                            PropertySimple ps;
                            if (!(p2 instanceof PropertySimple) || (ps = (PropertySimple)p2).getStringValue() == null) continue;
                            Object val = this.getObjectForPropertyList(ps, pl, op);
                            items.add(val);
                        }
                        operation.addAdditionalProperty(pl.getName(), items);
                        continue;
                    }
                    this.log.error((Object)("PropertyMap for " + prop.getName() + " not yet supported"));
                }
            }
        }
        OperationResult operationResult = new OperationResult();
        Result result = this.getASConnection().execute(operation);
        if (result == null) {
            operationResult.setErrorMessage("Connection was null - is the server running?");
            return operationResult;
        }
        if (!result.isSuccess()) {
            operationResult.setErrorMessage(result.getFailureDescription());
        } else {
            String tmp = result.getResult() == null ? "-none provided by the server-" : result.getResult().toString();
            operationResult.setSimpleResult(tmp);
        }
        return operationResult;
    }

    Object getObjectForProperty(PropertySimple prop, String operationName) {
        ConfigurationDefinition parameterDefinitions = this.getParameterDefinitionsForOperation(operationName);
        if (parameterDefinitions == null) {
            return null;
        }
        PropertyDefinition pd = parameterDefinitions.get(prop.getName());
        if (pd instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple pds = (PropertyDefinitionSimple)pd;
            return this.getObjectForProperty(prop, pds);
        }
        this.log.warn((Object)("Property [" + prop.getName() + "] is not understood yet"));
        return null;
    }

    Object getObjectForPropertyList(PropertySimple prop, PropertyList propertyList, String operationName) {
        PropertyDefinitionList definitionList;
        PropertyDefinition tmp;
        ConfigurationDefinition parameterDefinitions = this.getParameterDefinitionsForOperation(operationName);
        if (parameterDefinitions == null) {
            return null;
        }
        PropertyDefinition def = parameterDefinitions.get(propertyList.getName());
        if (def instanceof PropertyDefinitionList && (tmp = (definitionList = (PropertyDefinitionList)def).getMemberDefinition()) instanceof PropertyDefinitionSimple) {
            return this.getObjectForProperty(prop, (PropertyDefinitionSimple)tmp);
        }
        return null;
    }

    ConfigurationDefinition getParameterDefinitionsForOperation(String operationName) {
        ResourceType type = this.context.getResourceType();
        Set operationDefinitions = type.getOperationDefinitions();
        for (OperationDefinition definition : operationDefinitions) {
            if (!definition.getName().equals(operationName)) continue;
            return definition.getParametersConfigurationDefinition();
        }
        return null;
    }

    Object getObjectForProperty(PropertySimple prop, PropertyDefinitionSimple propDef) {
        PropertySimpleType type = propDef.getType();
        return this.getObjectForProperty(prop, type);
    }

    private Object getObjectForProperty(PropertySimple prop, PropertySimpleType type) {
        switch (type) {
            case STRING: {
                return prop.getStringValue();
            }
            case INTEGER: {
                return prop.getIntegerValue();
            }
            case BOOLEAN: {
                return prop.getBooleanValue();
            }
            case LONG: {
                return prop.getLongValue();
            }
            case FLOAT: {
                return prop.getFloatValue();
            }
            case DOUBLE: {
                return prop.getDoubleValue();
            }
        }
        return prop.getStringValue();
    }

    public void setConnection(ASConnection connection) {
        this.testConnection = connection;
    }

    public void setPath(String path) {
        this.path = path;
        this.address = new Address(path);
    }

    public Address getAddress() {
        return this.address;
    }

    protected String readAttribute(String name) throws Exception {
        return this.readAttribute(this.getAddress(), name);
    }

    protected String readAttribute(Address address, String name) throws Exception {
        return this.readAttribute(address, name, String.class);
    }

    protected <T> T readAttribute(Address address, String name, Class<T> resultType) throws Exception {
        ReadAttribute op = new ReadAttribute(address, name);
        Result res = this.getASConnection().execute(op);
        if (!res.isSuccess()) {
            throw new Exception("Failed to read attribute [" + name + "] of address [" + this.getAddress().getPath() + "] - response: " + res);
        }
        return (T)res.getResult();
    }

    private static class ComplexRequest {
        private String prop;
        private String sub;

        private ComplexRequest(String prop, String sub) {
            this.prop = prop;
            this.sub = sub;
        }

        public String getProp() {
            return this.prop;
        }

        public String getSub() {
            return this.sub;
        }

        public static ComplexRequest create(String requestName) {
            StringTokenizer tokenizer = new StringTokenizer(requestName, ":");
            return new ComplexRequest(tokenizer.nextToken(), tokenizer.nextToken());
        }
    }
}

