/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Remove;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class ConfigurationWriteDelegate
implements ConfigurationFacet {
    public static final String LOGICAL_REMOVED = "__logicalRemoved";
    final Log log = LogFactory.getLog(this.getClass());
    protected Address address;
    protected ASConnection connection;
    protected ConfigurationDefinition configurationDefinition;
    private String namePropLocator;
    private String type;
    private boolean addNewChildren;
    private boolean addDeleteModifiedChildren;
    protected boolean createChildRequested = false;

    public ConfigurationWriteDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        this.configurationDefinition = configDef;
        this.connection = connection;
        this.address = address;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        throw new IllegalAccessException("Please use ConfigurationLoadDelegate");
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration conf = report.getConfiguration();
        CompositeOperation cop = this.updateGenerateOperationFromProperties(conf, this.address);
        Result result = this.connection.execute(cop);
        if (!result.isSuccess()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(result.getFailureDescription());
        } else {
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
    }

    protected CompositeOperation updateGenerateOperationFromProperties(Configuration conf, Address address) {
        CompositeOperation cop = new CompositeOperation();
        for (PropertyDefinition propDef : this.configurationDefinition.getNonGroupedProperties()) {
            this.updateProperty(conf, cop, propDef, address);
        }
        for (PropertyGroupDefinition pgd : this.configurationDefinition.getGroupDefinitions()) {
            String groupName = pgd.getName();
            this.namePropLocator = null;
            if (groupName.startsWith("children:")) {
                this.type = groupName.substring("children:".length());
                if (this.type.contains(":")) {
                    this.namePropLocator = this.type.substring(this.type.indexOf(":") + 1);
                    if (this.namePropLocator.endsWith("+")) {
                        this.namePropLocator = this.namePropLocator.substring(0, this.namePropLocator.length() - 1);
                        this.addNewChildren = true;
                    } else if (this.namePropLocator.endsWith("+-")) {
                        this.namePropLocator = this.namePropLocator.substring(0, this.namePropLocator.length() - 2);
                        this.addNewChildren = true;
                        this.addDeleteModifiedChildren = true;
                    } else {
                        this.addNewChildren = false;
                    }
                } else {
                    this.log.error((Object)("Group name " + groupName + " contains no property name locator "));
                    return cop;
                }
                this.type = this.type.substring(0, this.type.indexOf(":"));
                List definitions = this.configurationDefinition.getPropertiesInGroup(groupName);
                for (PropertyDefinition def : definitions) {
                    this.updateProperty(conf, cop, def, address);
                }
            }
            if (!groupName.startsWith("child:")) continue;
            String subPath = groupName.substring("child:".length());
            if (!subPath.contains("=")) {
                throw new IllegalArgumentException("subPath of 'child:' expression has no =");
            }
            String condition = null;
            boolean groupEnabled = true;
            boolean isEnabledConditionFound = false;
            if (subPath.contains(":")) {
                condition = subPath.substring(subPath.indexOf(58) + 1);
                subPath = subPath.substring(0, subPath.indexOf(58));
            }
            if (condition != null && condition.startsWith("enabled=")) {
                String realValue;
                isEnabledConditionFound = true;
                String tmp = condition.substring("enabled=".length());
                if (!tmp.contains("=")) {
                    throw new IllegalArgumentException("Condition " + condition + " does not have a = between key and value part (" + tmp + ")");
                }
                String key = tmp.substring(0, tmp.indexOf(61));
                String targetValue = tmp.substring(tmp.indexOf(61) + 1);
                PropertySimple conditionProperty = conf.getSimple(key);
                if (conditionProperty != null && (realValue = conditionProperty.getStringValue()) != null && !targetValue.equals(realValue)) {
                    groupEnabled = false;
                }
            }
            Address address1 = new Address(address);
            address1.addSegment(subPath);
            List definitions = this.configurationDefinition.getPropertiesInGroup(groupName);
            if (definitions.size() == 1 && definitions.get(0) instanceof PropertyDefinitionMap) {
                Result res;
                PropertyDefinitionMap definitionMap = (PropertyDefinitionMap)definitions.get(0);
                String mapName = definitionMap.getName();
                boolean isAddEnabled = mapName.endsWith("+");
                if (groupEnabled) {
                    Operation add;
                    ReadResource testOp;
                    if (isAddEnabled && !(res = this.connection.execute(testOp = new ReadResource(address1))).isSuccess() && !(res = this.connection.execute(add = new Operation("add", address1))).isSuccess()) {
                        this.log.error((Object)("Adding of node " + address1 + " failed"));
                    }
                    definitions = definitionMap.getPropertyDefinitions();
                    PropertyMap map = conf.getMap(mapName);
                    for (PropertyDefinition def : definitions) {
                        this.createWriteAttribute(cop, address1, def, map.get(def.getName()));
                    }
                    continue;
                }
                Remove op = new Remove(address1);
                res = this.connection.execute(op);
                continue;
            }
            for (PropertyDefinition def : definitions) {
                this.updateProperty(conf, cop, def, address1);
            }
        }
        return cop;
    }

    private void updateProperty(Configuration conf, CompositeOperation cop, PropertyDefinition propDef, Address baseAddress) {
        if (propDef.isReadOnly()) {
            return;
        }
        String propDefName = propDef.getName();
        if (propDef instanceof PropertyDefinitionList && propDefName.startsWith("*")) {
            ReadChildrenResources op;
            Result tmp;
            propDef = ((PropertyDefinitionList)propDef).getMemberDefinition();
            PropertyList pl = (PropertyList)conf.get(propDefName);
            ArrayList<String> existingPropnames = new ArrayList<String>();
            if (this.addNewChildren && (tmp = this.connection.execute(op = new ReadChildrenResources(baseAddress, this.type))).isSuccess()) {
                Map tmpResMap = (Map)tmp.getResult();
                existingPropnames.addAll(tmpResMap.keySet());
            }
            for (Property prop2 : pl.getList()) {
                this.updateHandlePropertyMapSpecial(cop, (PropertyMap)prop2, (PropertyDefinitionMap)propDef, baseAddress, existingPropnames);
            }
            for (String existingName : existingPropnames) {
                boolean found = false;
                for (Property prop2 : pl.getList()) {
                    PropertyMap propMap2 = (PropertyMap)prop2;
                    if (LOGICAL_REMOVED.equals(propMap2.getErrorMessage())) {
                        found = true;
                        continue;
                    }
                    String itemName = propMap2.getSimple(this.namePropLocator).getStringValue();
                    if (itemName == null) {
                        throw new IllegalArgumentException("Map contains no entry with name [" + this.namePropLocator + "]");
                    }
                    if (!itemName.equals(existingName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Address tmpAddr = new Address(baseAddress);
                tmpAddr.add(this.type, existingName);
                Operation operation = new Operation("remove", tmpAddr);
                cop.addStep(operation);
            }
        } else {
            Property prop = conf.get(propDefName);
            this.createWriteAttribute(cop, baseAddress, propDef, prop);
        }
    }

    private void createWriteAttribute(CompositeOperation cop, Address baseAddress, PropertyDefinition propDef, Property prop) {
        if (prop instanceof PropertySimple && propDef instanceof PropertyDefinitionSimple) {
            this.createWriteAttributePropertySimple(cop, (PropertySimple)prop, (PropertyDefinitionSimple)propDef, baseAddress);
        } else if (prop instanceof PropertyList && propDef instanceof PropertyDefinitionList) {
            this.createWriteAttributePropertyList(cop, (PropertyList)prop, (PropertyDefinitionList)propDef, baseAddress);
        } else if (prop instanceof PropertyMap && propDef instanceof PropertyDefinitionMap) {
            this.createWriteAttributePropertyMap(cop, (PropertyMap)prop, (PropertyDefinitionMap)propDef, baseAddress);
        } else {
            String s = "Property and definition are not matching:\n";
            s = s + "Property: " + prop + "\n";
            s = s + "PropDef : " + propDef;
            throw new IllegalArgumentException(s);
        }
    }

    private void updateHandlePropertyMapSpecial(CompositeOperation cop, PropertyMap prop, PropertyDefinitionMap propDef, Address address, List<String> existingPropNames) {
        if (prop == null) {
            return;
        }
        if (LOGICAL_REMOVED.equals(prop.getErrorMessage())) {
            return;
        }
        Map<String, Object> results = this.prepareSimplePropertyMap(prop, propDef);
        if (prop.get(this.namePropLocator) == null) {
            throw new IllegalArgumentException("There is no element in the map with the name " + this.namePropLocator);
        }
        String key = ((PropertySimple)prop.get(this.namePropLocator)).getStringValue();
        Address addr = new Address(address);
        addr.add(this.type, key);
        if (!this.addNewChildren || existingPropNames.contains(key)) {
            if (this.addDeleteModifiedChildren) {
                Operation operation = new Remove(addr);
                cop.addStep(operation);
                operation = new Operation("add", addr);
                for (Map.Entry<String, Object> entry : results.entrySet()) {
                    String key1 = entry.getKey();
                    Object value = this.getValueWithType(entry, propDef);
                    if (key1.endsWith(":expr")) {
                        key1 = key1.substring(0, key1.indexOf(58));
                        HashMap<String, Object> tmp = new HashMap<String, Object>();
                        tmp.put("EXPRESSION_VALUE", value);
                        operation.addAdditionalProperty(key1, tmp);
                        continue;
                    }
                    operation.addAdditionalProperty(key1, value);
                }
                cop.addStep(operation);
            } else {
                for (Map.Entry<String, Object> entry : results.entrySet()) {
                    WriteAttribute operation;
                    String key1 = entry.getKey();
                    Object value = this.getValueWithType(entry, propDef);
                    if (key1.endsWith(":expr")) {
                        key1 = key1.substring(0, key1.indexOf(58));
                        HashMap<String, Object> tmp = new HashMap<String, Object>();
                        tmp.put("EXPRESSION_VALUE", value);
                        operation = new WriteAttribute(addr, key1, tmp);
                    } else {
                        operation = new WriteAttribute(addr, key1, value);
                    }
                    cop.addStep(operation);
                }
            }
        } else {
            Operation operation = new Operation("add", addr);
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                String key1 = entry.getKey();
                Object value = this.getValueWithType(entry, propDef);
                if (key1.endsWith(":expr")) {
                    key1 = key1.substring(0, key1.indexOf(58));
                    HashMap<String, Object> tmp = new HashMap<String, Object>();
                    tmp.put("EXPRESSION_VALUE", value);
                    operation.addAdditionalProperty(key1, tmp);
                    continue;
                }
                operation.addAdditionalProperty(key1, value);
            }
            cop.addStep(operation);
        }
    }

    private void createWriteAttributePropertySimple(CompositeOperation cop, PropertySimple property, PropertyDefinitionSimple propertyDefinition, Address address) {
        if (property.getStringValue() == null && !propertyDefinition.isRequired()) {
            return;
        }
        if (propertyDefinition.isReadOnly() && !this.createChildRequested) {
            return;
        }
        AbstractMap.SimpleEntry<String, Object> entry = this.preparePropertySimple(property, propertyDefinition);
        WriteAttribute writeAttribute = new WriteAttribute(address, entry.getKey(), entry.getValue());
        cop.addStep(writeAttribute);
    }

    private void createWriteAttributePropertyList(CompositeOperation cop, PropertyList property, PropertyDefinitionList propertyDefinition, Address address) {
        AbstractMap.SimpleEntry<String, List<Object>> entry = this.preparePropertyList(property, propertyDefinition);
        WriteAttribute writeAttribute = new WriteAttribute(address, entry.getKey(), entry.getValue());
        cop.addStep(writeAttribute);
    }

    private void createWriteAttributePropertyMap(CompositeOperation cop, PropertyMap property, PropertyDefinitionMap propertyDefinition, Address address) {
        AbstractMap.SimpleEntry<String, Map<String, Object>> entry = this.preparePropertyMap(property, propertyDefinition);
        WriteAttribute writeAttribute = new WriteAttribute(address, entry.getKey(), entry.getValue());
        cop.addStep(writeAttribute);
    }

    protected AbstractMap.SimpleEntry<String, Object> preparePropertySimple(PropertySimple property, PropertyDefinitionSimple propertyDefinition) {
        AbstractMap.SimpleEntry<String, Object> entry = null;
        String name = this.stripNumberIdentifier(property.getName());
        if (name.endsWith(":expr")) {
            String realName = name.substring(0, name.indexOf(":"));
            if (property.getStringValue() != null) {
                try {
                    if (propertyDefinition.getType().equals((Object)PropertySimpleType.LONG)) {
                        Long num = Long.parseLong(property.getStringValue());
                    } else {
                        Integer num = Integer.parseInt(property.getStringValue());
                    }
                    entry = new AbstractMap.SimpleEntry<String, String>(realName, property.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    HashMap<String, String> expr = new HashMap<String, String>(1);
                    expr.put("EXPRESSION_VALUE", property.getStringValue());
                    entry = new AbstractMap.SimpleEntry<String, HashMap<String, Object>>(realName, expr);
                }
            } else {
                entry = new AbstractMap.SimpleEntry<String, Object>(realName, null);
            }
        } else {
            entry = new AbstractMap.SimpleEntry<String, Object>(name, property.getStringValue());
        }
        return entry;
    }

    protected AbstractMap.SimpleEntry<String, List<Object>> preparePropertyList(PropertyList property, PropertyDefinitionList propertyDefinition) {
        PropertyDefinition memberDef = propertyDefinition.getMemberDefinition();
        List embeddedProps = property.getList();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Property inner : embeddedProps) {
            PropertySimple ps;
            if (memberDef instanceof PropertyDefinitionSimple && (ps = (PropertySimple)inner).getStringValue() != null) {
                values.add(ps.getStringValue());
            }
            if (!(memberDef instanceof PropertyDefinitionMap)) continue;
            Map<String, Object> mapResult = null;
            mapResult = memberDef.getName().endsWith(":collapsed") ? this.prepareCollapsedPropertyMap((PropertyMap)inner, (PropertyDefinitionMap)memberDef) : this.prepareSimplePropertyMap((PropertyMap)inner, (PropertyDefinitionMap)memberDef);
            values.add(mapResult);
        }
        String name = this.stripNumberIdentifier(property.getName());
        return new AbstractMap.SimpleEntry<String, List<Object>>(name, values);
    }

    protected AbstractMap.SimpleEntry<String, Map<String, Object>> preparePropertyMap(PropertyMap property, PropertyDefinitionMap propertyDefinition) {
        Map<String, Object> results;
        String propName = this.stripNumberIdentifier(property.getName());
        if (propName.endsWith(":collapsed")) {
            propName = propName.substring(0, propName.indexOf(58));
            results = this.prepareCollapsedPropertyMap(property, propertyDefinition);
        } else {
            results = this.prepareSimplePropertyMap(property, propertyDefinition);
        }
        return new AbstractMap.SimpleEntry<String, Map<String, Object>>(propName, results);
    }

    protected Map<String, Object> prepareCollapsedPropertyMap(PropertyMap property, PropertyDefinitionMap propertyDefinition) {
        String key = null;
        String value = null;
        for (Map.Entry entry : propertyDefinition.getMap().entrySet()) {
            PropertyDefinition def = (PropertyDefinition)entry.getValue();
            if (!def.getName().contains(":")) {
                throw new IllegalArgumentException("Member names in a :collapsed map must end in :0 and :1");
            }
            Property prop = property.get(def.getName());
            if (prop == null) {
                throw new IllegalArgumentException("Property " + def.getName() + " was null - must not happen");
            }
            PropertySimple ps = (PropertySimple)prop;
            if (def.getName().endsWith(":0")) {
                key = ps.getStringValue();
                continue;
            }
            if (def.getName().endsWith(":1")) {
                value = ps.getStringValue();
                continue;
            }
            throw new IllegalArgumentException("Member names in a :collapsed map must end in :0 and :1");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(key, value);
        return resultMap;
    }

    protected Map<String, Object> prepareSimplePropertyMap(PropertyMap property, PropertyDefinitionMap propertyDefinition) {
        Map memberDefinitions = propertyDefinition.getMap();
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String name : memberDefinitions.keySet()) {
            PropertyDefinition memberDefinition = (PropertyDefinition)memberDefinitions.get(name);
            if (memberDefinition.isReadOnly()) continue;
            if (memberDefinition instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)memberDefinition;
                PropertySimple ps = (PropertySimple)property.get(name);
                if ((ps == null || ps.getStringValue() == null) && !pds.isRequired() || ps == null) continue;
                results.put(name, ps.getStringValue());
                continue;
            }
            this.log.error((Object)(" *** not yet supported *** : " + memberDefinition.getName()));
        }
        return results;
    }

    private Object getValueWithType(Map.Entry<String, Object> entry, PropertyDefinitionMap definitions) {
        Object ret;
        PropertyDefinitionSimple pds = (PropertyDefinitionSimple)definitions.get(entry.getKey());
        if (!(entry.getValue() instanceof String)) {
            return entry.getValue();
        }
        String val = (String)entry.getValue();
        PropertySimpleType type = pds.getType();
        switch (type) {
            case STRING: {
                ret = val;
                break;
            }
            case INTEGER: {
                ret = Integer.valueOf(val);
                break;
            }
            case BOOLEAN: {
                ret = Boolean.valueOf(val);
                break;
            }
            case LONG: {
                ret = Long.valueOf(val);
                break;
            }
            case FLOAT: {
                ret = Float.valueOf(val);
                break;
            }
            case DOUBLE: {
                ret = Double.valueOf(val);
                break;
            }
            default: {
                ret = val;
            }
        }
        return ret;
    }

    private String stripNumberIdentifier(String name) {
        if (name.contains(":")) {
            try {
                Integer.parseInt(name.substring(name.lastIndexOf(58) + 1));
                name = name.substring(0, name.lastIndexOf(58));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }
}

