/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.AbstractMap;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class CreateResourceDelegate
extends ConfigurationWriteDelegate
implements CreateChildResourceFacet {
    public CreateResourceDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        super(configDef, connection, address);
        this.createChildRequested = true;
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        String resourceName;
        report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
        Address createAddress = new Address(this.address);
        String path = report.getPluginConfiguration().getSimpleValue("path", "");
        if (!path.contains("=")) {
            resourceName = report.getUserSpecifiedResourceName();
        } else {
            resourceName = path.substring(path.indexOf(61) + 1);
            path = path.substring(0, path.indexOf(61));
        }
        createAddress.add(path, resourceName);
        Operation op = new Operation("add", createAddress);
        for (Property prop : report.getResourceConfiguration().getProperties()) {
            PropertyDefinitionSimple propertyDefinition;
            AbstractMap.SimpleEntry<String, Object> entry = null;
            boolean isEntryEligible = true;
            if (prop instanceof PropertySimple) {
                PropertySimple propertySimple = (PropertySimple)prop;
                propertyDefinition = this.configurationDefinition.getPropertyDefinitionSimple(propertySimple.getName());
                if (!propertyDefinition.isRequired() && propertySimple.getStringValue() == null) {
                    isEntryEligible = false;
                } else {
                    entry = this.preparePropertySimple(propertySimple, propertyDefinition);
                }
            } else if (prop instanceof PropertyList) {
                PropertyList propertyList = (PropertyList)prop;
                propertyDefinition = this.configurationDefinition.getPropertyDefinitionList(propertyList.getName());
                if (!propertyDefinition.isRequired() && propertyList.getList().size() == 0) {
                    isEntryEligible = false;
                } else {
                    entry = this.preparePropertyList(propertyList, (PropertyDefinitionList)propertyDefinition);
                }
            } else if (prop instanceof PropertyMap) {
                PropertyMap propertyMap = (PropertyMap)prop;
                propertyDefinition = this.configurationDefinition.getPropertyDefinitionMap(propertyMap.getName());
                if (!propertyDefinition.isRequired() && propertyMap.getMap().size() == 0) {
                    isEntryEligible = false;
                } else {
                    entry = this.preparePropertyMap(propertyMap, (PropertyDefinitionMap)propertyDefinition);
                }
            }
            if (!isEntryEligible) continue;
            op.addAdditionalProperty((String)entry.getKey(), entry.getValue());
        }
        Result result = this.connection.execute(op);
        if (result.isSuccess()) {
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceKey(createAddress.getPath());
            report.setResourceName(report.getUserSpecifiedResourceName());
        } else {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage(result.getFailureDescription());
        }
        return report;
    }
}

