/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DatasourceComponent
extends BaseComponent<BaseComponent<?>>
implements OperationFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    private static final String NOTSET = "-notset-";
    private final Log log = LogFactory.getLog(DatasourceComponent.class);

    @Override
    public OperationResult invokeOperation(String operationName, Configuration parameters) throws Exception {
        Operation op;
        OperationResult result = new OperationResult();
        ASConnection connection = this.getASConnection();
        if (operationName.equals("addDriver")) {
            String drivername = parameters.getSimpleValue("driver-name", NOTSET);
            Address theAddress = new Address(this.address);
            theAddress.add("jdbc-driver", drivername);
            op = new Operation("add", theAddress);
            op.addAdditionalProperty("driver-name", drivername);
            op.addAdditionalProperty("deployment-name", parameters.getSimpleValue("deployment-name", NOTSET));
            op.addAdditionalProperty("driver-class-name", parameters.getSimpleValue("driver-class-name", NOTSET));
        } else {
            op = new Operation(operationName, this.address);
        }
        Result res = connection.execute(op);
        if (res.isSuccess()) {
            result.setSimpleResult("Success");
            if ("enable".equals(operationName)) {
                this.context.getAvailabilityContext().enable();
            } else if ("disable".equals(operationName)) {
                this.context.getAvailabilityContext().disable();
            }
        } else {
            result.setErrorMessage(res.getFailureDescription());
        }
        return result;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        CreateResourceReport resourceReport = super.createResource(report);
        if (resourceReport.getStatus() != CreateResourceStatus.SUCCESS) {
            return resourceReport;
        }
        if (report.getResourceType().getName().toLowerCase().contains("xa")) {
            PropertyList listPropertyWrapper = report.getResourceConfiguration().getList("*2");
            List listProperty = listPropertyWrapper.getList();
            String baseAddress = resourceReport.getResourceKey();
            if (!listProperty.isEmpty()) {
                CompositeOperation cop = new CompositeOperation();
                for (Property p : listProperty) {
                    PropertyMap map = (PropertyMap)p;
                    String key = map.getSimpleValue("key", null);
                    String value = map.getSimpleValue("value", null);
                    if (key == null || value == null) continue;
                    Address propertyAddress = new Address(baseAddress);
                    propertyAddress.add("xa-datasource-properties", key);
                    Operation op = new Operation("add", propertyAddress);
                    op.addAdditionalProperty("value", value);
                    cop.addStep(op);
                }
                Result res = this.getASConnection().execute(cop);
                if (!res.isSuccess()) {
                    resourceReport.setErrorMessage("Datasource was added, but setting xa-properties failed: " + res.getFailureDescription());
                    resourceReport.setStatus(CreateResourceStatus.FAILURE);
                }
            }
        }
        return resourceReport;
    }

    void addAdditionalToOp(Operation op, Configuration parameters, String parameterName, boolean optional) {
        String value = parameters.getSimpleValue(parameterName, null);
        if (value == null) {
            if (!optional) {
                throw new IllegalArgumentException("Required parameter [" + parameterName + "] for operation [" + op.getName() + "] is not defined.");
            }
        } else {
            op.addAdditionalProperty(parameterName, value);
        }
    }

    void addRequiredToOp(Operation op, Configuration parameters, String property) {
        this.addAdditionalToOp(op, parameters, property, false);
    }

    void addOptionalToOp(Operation op, Configuration parameters, String property) {
        this.addAdditionalToOp(op, parameters, property, true);
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Operation op = new Operation("disable", this.getAddress());
        Result res = this.getASConnection().execute(op);
        if (!res.isSuccess()) {
            report.setErrorMessage("Was not able to disable the datasource for config changes: " + res.getFailureDescription());
            return;
        }
        super.updateResourceConfiguration(report);
        op = new Operation("enable", this.getAddress());
        res = this.getASConnection().execute(op);
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> metrics = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("connectionAvailable")) {
                report.addData(this.getConnectionAvailable(request));
                continue;
            }
            if (request.getName().equals("max-pool-size")) {
                this.getRCAsMetric(report, request);
                continue;
            }
            if (request.getName().equals("min-pool-size")) {
                this.getRCAsMetric(report, request);
                continue;
            }
            metrics.add(request);
        }
        ReadResource op = new ReadResource(this.address);
        op.includeRuntime(true);
        op.recursive(true);
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (!res.isSuccess()) {
            return;
        }
        HashMap results = new HashMap();
        Map statistics = (Map)res.getResult().get("statistics");
        if (statistics != null) {
            results.putAll((Map)statistics.get("pool"));
            results.putAll((Map)statistics.get("jdbc"));
            for (MeasurementScheduleRequest metric : metrics) {
                String name = metric.getName();
                Object o = results.get(name);
                if (o == null) continue;
                String tmp = (String)o;
                Double val = Double.valueOf(tmp);
                MeasurementDataNumeric data = new MeasurementDataNumeric(metric, val);
                report.addData(data);
            }
        }
    }

    private void getRCAsMetric(MeasurementReport report, MeasurementScheduleRequest request) {
        ReadAttribute op = new ReadAttribute(this.getAddress(), request.getName());
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            String tmp = (String)res.getResult();
            if (tmp == null) {
                tmp = request.getName().equals("max-pool-size") ? "20" : (request.getName().equals("min-pool-size") ? "0" : "-1");
            }
            Double val = Double.valueOf(tmp);
            MeasurementDataNumeric data = new MeasurementDataNumeric(request, val);
            report.addData(data);
        } else {
            this.log.warn((Object)("Could not read [" + request.getName() + "] on " + this.getAddress() + ": " + res.getFailureDescription()));
        }
    }

    private MeasurementDataTrait getConnectionAvailable(MeasurementScheduleRequest request) {
        Operation op = new Operation("test-connection-in-pool", this.getAddress());
        Result res = this.getASConnection().execute(op);
        MeasurementDataTrait trait = new MeasurementDataTrait(request, String.valueOf(res.isSuccess()));
        return trait;
    }
}

