/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.content.FileContentDelegate;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.Base64;
import org.rhq.core.util.ByteUtil;
import org.rhq.core.util.file.JarContentFileInfo;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DeploymentComponent
extends BaseComponent<ResourceComponent<?>>
implements OperationFacet,
ContentFacet {
    private boolean verbose = ASConnection.verbose;
    private File deploymentFile;

    @Override
    public void start(ResourceContext<ResourceComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        super.start(context);
        this.deploymentFile = this.determineDeploymentFile();
    }

    @Override
    public AvailabilityType getAvailability() {
        ReadAttribute op = new ReadAttribute(this.getAddress(), "enabled");
        Result res = this.getASConnection().execute(op);
        if (!res.isSuccess()) {
            return AvailabilityType.DOWN;
        }
        if (res.getResult() == null || !((Boolean)res.getResult()).booleanValue()) {
            return AvailabilityType.DOWN;
        }
        return AvailabilityType.UP;
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("enable")) {
            return this.invokeSimpleOperation("deploy");
        }
        if (name.equals("disable")) {
            return this.invokeSimpleOperation("undeploy");
        }
        if (name.equals("restart")) {
            OperationResult result = this.invokeSimpleOperation("undeploy");
            if (result.getErrorMessage() == null) {
                result = this.invokeSimpleOperation("deploy");
            }
            return result;
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult invokeSimpleOperation(String action) {
        Operation op = new Operation(action, this.getAddress());
        Result res = this.getASConnection().execute(op);
        OperationResult result = new OperationResult();
        if (res.isSuccess()) {
            result.setSimpleResult("Success");
            if ("enable".equals(action)) {
                this.context.getAvailabilityContext().enable();
            }
            if ("disable".equals(action)) {
                this.context.getAvailabilityContext().disable();
            }
        } else {
            result.setErrorMessage(res.getFailureDescription());
        }
        return result;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return new ArrayList<DeployPackageStep>();
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        this.log.info((Object)"Starting deployment..");
        DeployPackagesResponse response = new DeployPackagesResponse();
        if (packages.size() != 1) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Can only deploy one package at a time");
            this.log.warn((Object)"deployPackages can only deploy one package at a time");
        }
        ResourcePackageDetails detail = packages.iterator().next();
        ASUploadConnection uploadConnection = new ASUploadConnection(this.getASConnection());
        OutputStream out = uploadConnection.getOutputStream(detail.getFileName());
        ResourceType resourceType = this.context.getResourceType();
        this.log.info((Object)("trying deployment of" + resourceType.getName() + ", key=" + detail.getKey()));
        contentServices.downloadPackageBits(this.context.getContentContext(), detail.getKey(), out, true);
        JsonNode uploadResult = uploadConnection.finishUpload();
        if (this.verbose) {
            this.log.info((Object)uploadResult);
        }
        if (ASUploadConnection.isErrorReply(uploadResult)) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage(ASUploadConnection.getFailureDescription(uploadResult));
            return response;
        }
        JsonNode resultNode = uploadResult.get("result");
        String hash = resultNode.get("BYTES_VALUE").getTextValue();
        CreateResourceReport report1 = new CreateResourceReport("", resourceType, new Configuration(), new Configuration(), detail);
        try {
            this.redeployOnServer(detail.getKey().getName(), hash);
            response.setOverallRequestResult(ContentResponseResult.SUCCESS);
            DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(detail.getKey(), ContentResponseResult.SUCCESS);
            response.addPackageResponse(packageResponse);
        }
        catch (Exception e) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
        }
        this.log.info((Object)(".. result is " + response));
        return response;
    }

    private void redeployOnServer(String name, String hash) throws Exception {
        Operation op = new Operation("full-replace-deployment", new Address());
        op.addAdditionalProperty("name", name);
        ArrayList content = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
        content.add(contentValues);
        op.addAdditionalProperty("content", content);
        Result result = this.getASConnection().execute(op);
        if (result.isRolledBack()) {
            throw new Exception(result.getFailureDescription());
        }
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        RemovePackagesResponse response = new RemovePackagesResponse(ContentResponseResult.NOT_PERFORMED);
        response.setOverallRequestErrorMessage("Removal of packages backing the deployments is not supported.");
        return response;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        if (this.deploymentFile == null) {
            return Collections.emptySet();
        }
        String name = this.getDeploymentName();
        String sha256 = this.getSHA256(this.deploymentFile);
        String version = DeploymentComponent.getVersion(sha256);
        PackageDetailsKey key = new PackageDetailsKey(name, version, type.getName(), "noarch");
        ResourcePackageDetails details = new ResourcePackageDetails(key);
        details.setDisplayVersion(this.getDisplayVersion(this.deploymentFile));
        details.setFileCreatedDate(null);
        details.setFileName(name);
        details.setFileSize(Long.valueOf(this.deploymentFile.length()));
        details.setInstallationTimestamp(this.deploymentFile.lastModified());
        details.setLocation(this.deploymentFile.getAbsolutePath());
        details.setSHA256(sha256);
        return Collections.singleton(details);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        try {
            return this.deploymentFile == null ? new ByteArrayInputStream(new byte[0]) : new FileInputStream(this.deploymentFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Deployment file seems to have disappeared");
        }
    }

    private File determineDeploymentFile() {
        ReadAttribute op = new ReadAttribute(this.getAddress(), "content");
        Result result = this.getASConnection().execute(op);
        List content = (List)result.getResult();
        if (content == null || content.isEmpty()) {
            this.log.warn((Object)("Could not determine the location of the deployment - the content descriptor wasn't found for deployment" + this.getAddress() + "."));
            return null;
        }
        Boolean archive = (Boolean)((Map)content.get(0)).get("archive");
        if (archive != null && !archive.booleanValue()) {
            this.log.debug((Object)"Exploded deployments not supported for retrieving the content.");
            return null;
        }
        File deploymentFile = null;
        if (((Map)content.get(0)).containsKey("path")) {
            String path = (String)((Map)content.get(0)).get("path");
            String relativeTo = (String)((Map)content.get(0)).get("relative-to");
            deploymentFile = this.getDeploymentFileFromPath(relativeTo, path);
        } else if (((Map)content.get(0)).containsKey("hash")) {
            String base64Hash = (String)((Map)((Map)content.get(0)).get("hash")).get("BYTES_VALUE");
            byte[] hash = Base64.decode((String)base64Hash);
            Address contentPathAddress = new Address("core-service", "server-environment");
            op = new ReadAttribute(contentPathAddress, "content-dir");
            result = this.getASConnection().execute(op);
            String contentPath = (String)result.getResult();
            deploymentFile = this.getDeploymentFileFromHash(hash, contentPath);
        } else {
            this.log.warn((Object)("Failed to determine the deployment file of " + this.getAddress() + " deployment. Neither path nor hash attributes were available."));
        }
        return deploymentFile;
    }

    private File getDeploymentFileFromPath(String relativeTo, String path) {
        if (relativeTo == null || relativeTo.trim().isEmpty()) {
            return new File(path);
        }
        if (relativeTo.startsWith("jboss.server")) {
            relativeTo = relativeTo.substring("jboss.server.".length());
            relativeTo = relativeTo.replace('.', '-');
            ReadAttribute op = new ReadAttribute(new Address("core-service", "server-environment"), relativeTo);
            Result res = this.getASConnection().execute(op);
            relativeTo = (String)res.getResult();
            return new File(relativeTo, path);
        }
        this.log.warn((Object)("Unsupported property used as a base for deployment path specification: " + relativeTo));
        return null;
    }

    private File getDeploymentFileFromHash(byte[] hash, String contentPath) {
        String hashStr = ByteUtil.toHexString((byte[])hash);
        String head = hashStr.substring(0, 2);
        String tail = hashStr.substring(2);
        File hashPath = new File(new File(head, tail), "content");
        return new File(contentPath, hashPath.getPath());
    }

    private String getSHA256(File file) {
        String sha256;
        block2: {
            sha256 = null;
            try {
                FileContentDelegate fileContentDelegate = new FileContentDelegate();
                sha256 = fileContentDelegate.retrieveDeploymentSHA(file, this.context.getResourceDataDirectory());
            }
            catch (Exception iex) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Problem calculating digest of package [" + file.getPath() + "]." + iex.getMessage()));
            }
        }
        return sha256;
    }

    private static String getVersion(String sha256) {
        return "[sha256=" + sha256 + "]";
    }

    private String getDisplayVersion(File file) {
        JarContentFileInfo contentFileInfo = new JarContentFileInfo(file);
        return contentFileInfo.getVersion(null);
    }

    private String getDeploymentName() {
        ReadAttribute op = new ReadAttribute(this.getAddress(), "name");
        Result res = this.getASConnection().execute(op);
        return (String)res.getResult();
    }
}

