/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class HornetQComponent
extends BaseComponent {
    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        Configuration resourceConfiguration = report.getResourceConfiguration();
        PropertyList entries = resourceConfiguration.getList("entries");
        if (entries == null || entries.getList().isEmpty()) {
            report.setErrorMessage("You need to provide at least one JNDI name");
            report.setStatus(CreateResourceStatus.FAILURE);
            return report;
        }
        ResourceType resourceType = report.getResourceType();
        if (resourceType.getName().equals("Connection-Factory")) {
            String discoveryGroup;
            String name;
            int found = 0;
            PropertyMap connector = resourceConfiguration.getMap("connector:collapsed");
            if (connector != null && !(name = connector.getSimpleValue("name:0", "")).isEmpty()) {
                ++found;
            }
            if (!(discoveryGroup = resourceConfiguration.getSimpleValue("discovery-group-name", "")).isEmpty()) {
                ++found;
            }
            if (found == 0 || found == 2) {
                String errorMessage = "You need to provide either a connector name OR a discovery-group-name. You provided ";
                errorMessage = errorMessage + (found == 0 ? "none" : "both");
                report.setErrorMessage(errorMessage);
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
        }
        report = super.createResource(report);
        return report;
    }
}

