/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class HostControllerComponent<T extends ResourceComponent<?>>
extends BaseServerComponent<T>
implements MeasurementFacet,
OperationFacet {
    private static final String DOMAIN_CONFIG_TRAIT = "domain-config-file";
    private static final String HOST_CONFIG_TRAIT = "host-config-file";
    private static final Address ENVIRONMENT_ADDRESS = new Address("host=master,core-service=host-environment");
    private static final Address HOST_ADDRESS = new Address("host=master");

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.DOMAIN;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            if (requestName.equals(DOMAIN_CONFIG_TRAIT) || requestName.equals(HOST_CONFIG_TRAIT)) {
                this.collectConfigTrait(report, request);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        OperationResult operationResult;
        if (name.equals("start")) {
            operationResult = this.startServer();
        } else if (name.equals("restart")) {
            operationResult = this.restartServer(parameters);
        } else if (name.equals("shutdown")) {
            String domainHost = this.pluginConfiguration.getSimpleValue("domainHost", "");
            if (domainHost.isEmpty()) {
                OperationResult result = new OperationResult();
                result.setErrorMessage("No domain host found - can not continue");
                operationResult = result;
            }
            Operation op = new Operation("shutdown", "host", domainHost);
            Result res = this.getASConnection().execute(op);
            operationResult = this.postProcessResult(name, res);
            this.waitUntilDown(operationResult);
        } else {
            operationResult = name.equals("installRhqUser") ? this.installManagementUser(parameters, this.pluginConfiguration) : super.invokeOperation(name, parameters);
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        Operation op;
        Address targetAddress;
        if (report.getPackageDetails() != null) {
            return super.deployContent(report);
        }
        String targetTypeName = report.getResourceType().getName();
        String resourceName = report.getUserSpecifiedResourceName();
        Configuration rc = report.getResourceConfiguration();
        if (targetTypeName.equals("ServerGroup")) {
            PropertySimple jvm;
            targetAddress = new Address();
            targetAddress.add("server-group", resourceName);
            op = new Operation("add", targetAddress);
            String profile = rc.getSimpleValue("profile", "");
            if (profile.isEmpty()) {
                report.setErrorMessage("No profile given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("profile", profile);
            String socketBindingGroup = rc.getSimpleValue("socket-binding-group", "");
            if (socketBindingGroup.isEmpty()) {
                report.setErrorMessage("No socket-binding-group given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("socket-binding-group", socketBindingGroup);
            PropertySimple offset = rc.getSimple("socket-binding-port-offset");
            if (offset != null && offset.getStringValue() != null) {
                op.addAdditionalProperty("socket-binding-port-offset", offset.getIntegerValue());
            }
            if ((jvm = rc.getSimple("jvm")) != null) {
                op.addAdditionalProperty("jvm", jvm.getStringValue());
            }
        } else if (targetTypeName.equals("Managed Server")) {
            String targetHost = rc.getSimpleValue("hostname", null);
            if (targetHost == null) {
                report.setErrorMessage("No domain host given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            targetAddress = new Address("host", targetHost);
            targetAddress.add("server-config", resourceName);
            op = new Operation("add", targetAddress);
            String socketBindingGroup = rc.getSimpleValue("socket-binding-group", "");
            if (socketBindingGroup.isEmpty()) {
                report.setErrorMessage("No socket-binding-group given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("socket-binding-group", socketBindingGroup);
            String autostartS = rc.getSimpleValue("auto-start", "false");
            boolean autoStart = Boolean.valueOf(autostartS);
            op.addAdditionalProperty("auto-start", autoStart);
            String portS = rc.getSimpleValue("socket-binding-port-offset", "0");
            int portOffset = Integer.parseInt(portS);
            op.addAdditionalProperty("socket-binding-port-offset", portOffset);
            String serverGroup = rc.getSimpleValue("group", null);
            if (serverGroup == null) {
                report.setErrorMessage("No server group given");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
            op.addAdditionalProperty("group", serverGroup);
        } else {
            if (targetTypeName.equals("JVM-Definition")) {
                return super.createResource(report);
            }
            throw new IllegalArgumentException("Don't know yet how to create instances of " + targetTypeName);
        }
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            report.setResourceKey(targetAddress.getPath());
            report.setResourceName(resourceName);
            report.setStatus(CreateResourceStatus.SUCCESS);
        } else {
            report.setErrorMessage(res.getFailureDescription());
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setException(res.getRhqThrowable());
        }
        return report;
    }

    @Override
    protected Address getEnvironmentAddress() {
        return ENVIRONMENT_ADDRESS;
    }

    @Override
    protected Address getHostAddress() {
        return HOST_ADDRESS;
    }
}

