/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;

public class LoggerComponent
extends BaseComponent {
    private final Log log = LogFactory.getLog(LoggerComponent.class);

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        Operation op = new Operation(name, this.address);
        Map propertyMap = parameters.getAllProperties();
        for (Map.Entry entry : propertyMap.entrySet()) {
            if (entry.getValue() instanceof PropertySimple) {
                PropertySimple ps = (PropertySimple)entry.getValue();
                op.addAdditionalProperty((String)entry.getKey(), ps.getStringValue());
                continue;
            }
            if (!(entry.getValue() instanceof PropertyList)) continue;
            PropertyList pl = (PropertyList)entry.getValue();
            List props = pl.getList();
            ArrayList<String> objects = new ArrayList<String>(props.size());
            for (Property p : props) {
                PropertySimple ps = (PropertySimple)p;
                objects.add(ps.getStringValue());
            }
            op.addAdditionalProperty((String)entry.getKey(), objects);
        }
        ASConnection conn = this.getASConnection();
        ComplexResult result = conn.executeComplex(op);
        if (result.isSuccess()) {
            return new OperationResult("ok");
        }
        OperationResult failure = new OperationResult();
        failure.setErrorMessage(result.getFailureDescription());
        return failure;
    }
}

