/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ManagedASComponent
extends BaseComponent<HostControllerComponent<?>> {
    private static final String MANAGED_SERVER_TYPE_NAME = "Managed Server";
    private LogFileEventResourceComponentHelper logFileEventDelegate;

    @Override
    public void start(ResourceContext<HostControllerComponent<?>> hostControllerComponentResourceContext) throws InvalidPluginConfigurationException, Exception {
        super.start(hostControllerComponentResourceContext);
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(this.context);
        this.logFileEventDelegate.startLogFileEventPollers();
    }

    @Override
    public void stop() {
        super.stop();
        this.logFileEventDelegate.stopLogFileEventPollers();
    }

    @Override
    public AvailabilityType getAvailability() {
        if (this.context.getResourceType().getName().equals(MANAGED_SERVER_TYPE_NAME)) {
            Result result;
            Address theAddress = new Address();
            String host = this.pluginConfiguration.getSimpleValue("domainHost", "local");
            theAddress.add("host", host);
            theAddress.add("server-config", this.myServerName);
            ReadAttribute getStatus = new ReadAttribute(theAddress, "status");
            try {
                result = this.getASConnection().execute(getStatus);
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage());
                return AvailabilityType.DOWN;
            }
            if (!result.isSuccess()) {
                return AvailabilityType.DOWN;
            }
            String msg = result.getResult().toString();
            if (msg.contains("STARTED")) {
                return AvailabilityType.UP;
            }
            return AvailabilityType.DOWN;
        }
        return super.getAvailability();
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        HashSet<MeasurementScheduleRequest> skmRequests = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest req : requests) {
            if (!req.getName().startsWith("_skm:")) continue;
            skmRequests.add(req);
        }
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("startTime")) {
                String path = this.getPath();
                path = path.replace("server-config", "server");
                Address address = new Address(path);
                address.add("core-service", "platform-mbean");
                address.add("type", "runtime");
                ReadAttribute op = new ReadAttribute(address, "start-time");
                Result res = this.getASConnection().execute(op);
                if (!res.isSuccess()) continue;
                Long startTime = (Long)res.getResult();
                MeasurementDataTrait data = new MeasurementDataTrait(request, new Date(startTime).toString());
                report.addData(data);
                continue;
            }
            if (request.getName().startsWith("_skm:")) continue;
            leftovers.add(request);
        }
        if (skmRequests.size() > 0) {
            Address address = new Address();
            ReadResource op = new ReadResource(address);
            op.includeRuntime(true);
            ComplexResult res = this.getASConnection().executeComplex(op);
            if (res.isSuccess()) {
                Object props = res.getResult();
                for (MeasurementScheduleRequest request : skmRequests) {
                    String requestName = request.getName();
                    String realName = requestName.substring(requestName.indexOf(58) + 1);
                    String val = null;
                    if (props.containsKey(realName)) {
                        val = this.getStringValue(props.get(realName));
                    }
                    if ("null".equals(val)) {
                        if (realName.equals("product-name")) {
                            val = "JBoss AS";
                        } else if (realName.equals("product-version")) {
                            val = this.getStringValue(props.get("release-version"));
                        } else {
                            this.log.debug((Object)("Value for " + realName + " was 'null' and no replacement found"));
                        }
                    }
                    MeasurementDataTrait data = new MeasurementDataTrait(request, val);
                    report.addData(data);
                }
            } else {
                this.log.debug((Object)("getSKMRequests failed: " + res.getFailureDescription()));
            }
        }
        if (!leftovers.isEmpty()) {
            super.getValues(report, leftovers);
        }
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Integer offSet;
        Configuration configuration = super.loadResourceConfiguration();
        String serverPath = this.path;
        try {
            serverPath = serverPath.substring(0, serverPath.indexOf(","));
            serverPath = serverPath.substring(serverPath.indexOf("=") + 1);
        }
        catch (RuntimeException e) {
            throw new Exception("Failed to extract hostname from server path [" + serverPath + "].", e);
        }
        configuration.put((Property)new PropertySimple("hostname", (Object)serverPath));
        ReadResource op = new ReadResource(this.getAddress());
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (res.isSuccess()) {
            Object map = res.getResult();
            String group = (String)map.get("group");
            configuration.put((Property)new PropertySimple("group", (Object)group));
            Map<String, Object> sgMap = this.getServerGroupMap(group);
            String sbGroup = (String)map.get("socket-binding-group");
            if (sbGroup == null) {
                sbGroup = (String)sgMap.get("socket-binding-group");
            }
            configuration.put((Property)new PropertySimple("socket-binding-group", (Object)sbGroup));
            offSet = (Integer)map.get("socket-binding-port-offset");
            if (offSet == null) {
                offSet = 0;
            }
        } else {
            throw new RuntimeException("Could not load configuration from remote server");
        }
        configuration.put((Property)new PropertySimple("socket-binding-port-offset", (Object)offSet));
        return configuration;
    }

    private Map<String, Object> getServerGroupMap(String group) {
        ReadResource op = new ReadResource("server-group", group);
        ComplexResult cr = this.getASConnection().executeComplex(op);
        if (cr.isSuccess()) {
            return cr.getResult();
        }
        return Collections.emptyMap();
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        OperationResult opRes;
        Result res;
        String tmp;
        Operation op = new Operation(name, this.getAddress());
        if (parameters != null && (tmp = parameters.getSimpleValue("blocking", null)) != null) {
            Boolean blocking = Boolean.valueOf(tmp);
            op.addAdditionalProperty("blocking", blocking);
        }
        if ((res = this.getASConnection().execute(op)).isSuccess()) {
            opRes = new OperationResult("successfully invoked [" + name + "]");
        } else {
            opRes = new OperationResult("Operation [" + name + "] failed");
            opRes.setErrorMessage(res.getFailureDescription());
        }
        return opRes;
    }
}

