/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ModClusterComponent
extends BaseComponent
implements OperationFacet,
ConfigurationFacet {
    private static String CONFIG_ADDRESS = ",mod-cluster-config=configuration";

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        Operation op = new Operation(name, this.getAddress());
        OperationResult operationResult = new OperationResult();
        Result result = null;
        if ("list-proxies".equals(name)) {
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                ArrayList container = (ArrayList)result.getResult();
                if (container != null && !container.isEmpty()) {
                    Object type = container.get(0);
                    String values = "";
                    if (type instanceof String) {
                        for (int i = 0; i < container.size(); ++i) {
                            values = values + container.get(i) + ",";
                        }
                        values = values.substring(0, values.length() - 1);
                    } else {
                        values = container.toString();
                    }
                    operationResult.getComplexResults().put((Property)new PropertySimple("proxy-list", (Object)values));
                } else {
                    operationResult.getComplexResults().put((Property)new PropertySimple("proxy-list", (Object)""));
                }
            }
        } else if ("add-proxy".equals(name)) {
            this.addAdditionalToOp(op, parameters, "host", false);
            this.addAdditionalToOp(op, parameters, "port", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("remove-proxy".equals(name)) {
            this.addAdditionalToOp(op, parameters, "host", false);
            this.addAdditionalToOp(op, parameters, "port", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("disable-context".equals(name)) {
            this.addAdditionalToOp(op, parameters, "virtualhost", false);
            this.addAdditionalToOp(op, parameters, "context", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("enable-context".equals(name)) {
            this.addAdditionalToOp(op, parameters, "virtualhost", false);
            this.addAdditionalToOp(op, parameters, "context", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("stop".equals(name)) {
            this.addAdditionalToOp(op, parameters, "waittime", true);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("stop-context".equals(name)) {
            this.addAdditionalToOp(op, parameters, "virtualhost", false);
            this.addAdditionalToOp(op, parameters, "context", false);
            this.addAdditionalToOp(op, parameters, "waittime", true);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("read-proxies-configuration".equals(name)) {
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                ArrayList container = (ArrayList)result.getResult();
                if (container != null && !container.isEmpty()) {
                    Object type = container.get(0);
                    String values = "";
                    if (type instanceof String) {
                        for (int i = 0; i < container.size(); ++i) {
                            values = values + container.get(i) + ",";
                        }
                        values = values.substring(0, values.length() - 1);
                    } else {
                        values = container.toString();
                    }
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-config", (Object)values));
                } else {
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-config", (Object)""));
                }
            }
        } else if ("read-proxies-info".equals(name)) {
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                ArrayList container = (ArrayList)result.getResult();
                if (container != null && !container.isEmpty()) {
                    Object type = container.get(0);
                    String values = "";
                    if (type instanceof String) {
                        for (int i = 0; i < container.size(); ++i) {
                            values = values + container.get(i) + ",";
                        }
                        values = values.substring(0, values.length() - 1);
                    } else {
                        values = container.toString();
                    }
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-info", (Object)values));
                } else {
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-info", (Object)""));
                }
            }
        } else {
            result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        }
        if (!result.isSuccess()) {
            operationResult.setErrorMessage(result.getFailureDescription());
        }
        return operationResult;
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        Address modClusterConfigAddress = new Address(this.key + CONFIG_ADDRESS);
        ConfigurationLoadDelegate delegate = new ConfigurationLoadDelegate(configDef, this.getASConnection(), modClusterConfigAddress);
        Configuration config = delegate.loadResourceConfiguration();
        return config;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        Address modClusterConfigAddress = new Address(this.key + CONFIG_ADDRESS);
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.getASConnection(), modClusterConfigAddress);
        delegate.updateResourceConfiguration(report);
    }

    void addAdditionalToOp(Operation op, Configuration parameters, String parameterName, boolean optional) {
        String value = parameters.getSimpleValue(parameterName, null);
        if (value == null) {
            if (!optional) {
                throw new IllegalArgumentException("Required parameter [" + parameterName + "] for operation [" + op.getName() + "] is not defined.");
            }
        } else {
            op.addAdditionalProperty(parameterName, value);
        }
    }

    @Override
    public Address getAddress() {
        return new Address(this.key);
    }
}

