/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class StandaloneASComponent<T extends ResourceComponent<?>>
extends BaseServerComponent<T>
implements MeasurementFacet,
OperationFacet {
    private static final String SERVER_CONFIG_TRAIT = "config-file";
    private static final Address ENVIRONMENT_ADDRESS = new Address("core-service=server-environment");

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.STANDALONE;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            if (requestName.equals(SERVER_CONFIG_TRAIT)) {
                this.collectConfigTrait(report, request);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("start")) {
            return this.startServer();
        }
        if (name.equals("restart")) {
            return this.restartServer(parameters);
        }
        if (name.equals("installRhqUser")) {
            return this.installManagementUser(parameters, this.pluginConfiguration);
        }
        Operation op = new Operation(name, new Address());
        Result res = this.getASConnection().execute(op);
        OperationResult operationResult = this.postProcessResult(name, res);
        if (name.equals("shutdown")) {
            this.waitUntilDown(operationResult);
        }
        if (name.equals("reload")) {
            this.waitUntilReloaded(operationResult);
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    private void waitUntilReloaded(OperationResult operationResult) {
        boolean reloaded = false;
        int count = 0;
        while (!reloaded) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            Result res = this.getASConnection().execute(op);
            if (res.isSuccess() && !res.isReloadRequired()) {
                reloaded = true;
            } else if (count > 20) {
                operationResult.setErrorMessage("Was not able to reload the server");
                return;
            }
            ++count;
        }
        this.log.debug((Object)("waitUntilReloaded: Used " + count + " delay round(s) to reload"));
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration config = report.getConfiguration();
        PropertyList propertyList = config.getList("*3");
        for (Property property : propertyList.getList()) {
            PropertyMap map = (PropertyMap)property;
            String ro = map.getSimpleValue("read-only", "false");
            if (!Boolean.parseBoolean(ro)) continue;
            map.setErrorMessage("__logicalRemoved");
        }
        super.updateResourceConfiguration(report);
    }

    @Override
    protected Address getEnvironmentAddress() {
        return ENVIRONMENT_ADDRESS;
    }

    @Override
    protected Address getHostAddress() {
        return this.getAddress();
    }
}

