/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class SubsystemDiscovery
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        String parentPath;
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING, true);
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        ASConnection connection = parentComponent.getASConnection();
        Configuration config = context.getDefaultPluginConfiguration();
        String confPath = config.getSimpleValue("path", "");
        if (confPath == null || confPath.isEmpty()) {
            this.log.error((Object)("Path plugin config is null for ResourceType [" + context.getResourceType().getName() + "]."));
            return details;
        }
        boolean lookForChildren = false;
        if (!confPath.contains("=")) {
            lookForChildren = true;
        }
        if ((parentPath = parentComponent.getPath()) == null || parentPath.isEmpty()) {
            parentPath = "";
        }
        String path = parentPath;
        PropertySimple managedRuntimeProp = config.getSimple("managedRuntime");
        if (managedRuntimeProp != null && managedRuntimeProp.getBooleanValue() != null && managedRuntimeProp.getBooleanValue().booleanValue() && path.startsWith("host=")) {
            path = path.replaceAll(",server-config=", ",server=");
            parentPath = parentPath.replaceAll(",server-config=", ",server=");
        }
        if (Boolean.getBoolean("as7plugin.verbose")) {
            this.log.info((Object)("total path: [" + path + "]"));
        }
        if (lookForChildren) {
            ArrayList<String> subTypes = new ArrayList<String>();
            if (confPath.contains("|")) {
                subTypes.addAll(Arrays.asList(confPath.split("\\|")));
            } else {
                subTypes.add(confPath);
            }
            Iterator i$ = subTypes.iterator();
            while (i$.hasNext()) {
                Address addr = new Address(parentPath);
                String cpath = (String)i$.next();
                Result result = connection.execute(new ReadChildrenNames(addr, cpath));
                if (!result.isSuccess()) continue;
                List subsystems = (List)result.getResult();
                for (String val : subsystems) {
                    String resKey;
                    String newPath = cpath + "=" + val;
                    Configuration config2 = context.getDefaultPluginConfiguration();
                    if (path == null || path.isEmpty()) {
                        resKey = newPath;
                    } else {
                        if (path.startsWith(",")) {
                            path = path.substring(1);
                        }
                        resKey = path + "," + cpath + "=" + val;
                    }
                    PropertySimple pathProp = new PropertySimple("path", (Object)resKey);
                    config2.put((Property)pathProp);
                    DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), resKey, val, null, context.getResourceType().getDescription(), config2, null);
                    details.add(detail);
                }
            }
        } else {
            Result result;
            if ((path = path + "," + confPath).startsWith(",")) {
                path = path.substring(1);
            }
            if ((result = connection.execute(new ReadResource(new Address(path)))).isSuccess()) {
                String resKey = path;
                String name = resKey.substring(resKey.lastIndexOf("=") + 1);
                Configuration config2 = context.getDefaultPluginConfiguration();
                PropertySimple pathProp = new PropertySimple("path", (Object)path);
                config2.put((Property)pathProp);
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), path, name, null, context.getResourceType().getDescription(), config2, null);
                details.add(detail);
            }
        }
        return details;
    }
}

