/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class WebRuntimeComponent
extends BaseComponent<BaseComponent<?>> {
    private static final String RESPONSE_TIME_METRIC = "responseTime";
    private ResponseTimeLogParser responseTimeLogParser;

    @Override
    public void start(ResourceContext<BaseComponent<?>> resourceContext) throws InvalidPluginConfigurationException, Exception {
        super.start(resourceContext);
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        ResponseTimeConfiguration responseTimeConfig = new ResponseTimeConfiguration(pluginConfig);
        File logFile = responseTimeConfig.getLogFile();
        if (logFile == null) {
            logFile = this.findLogFile();
        }
        if (logFile != null) {
            this.responseTimeLogParser = new ResponseTimeLogParser(logFile);
            this.responseTimeLogParser.setExcludes(responseTimeConfig.getExcludes());
            this.responseTimeLogParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        Iterator<MeasurementScheduleRequest> iterator = requests.iterator();
        while (iterator.hasNext()) {
            MeasurementScheduleRequest request = iterator.next();
            if (!request.getName().equals(RESPONSE_TIME_METRIC)) continue;
            iterator.remove();
            if (this.responseTimeLogParser != null) {
                try {
                    CallTimeData callTimeData = new CallTimeData(request);
                    this.responseTimeLogParser.parseLog(callTimeData);
                    report.addData(callTimeData);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to retrieve call-time metric 'responseTime' for " + this.context.getResourceType() + " Resource with key [" + this.context.getResourceKey() + "]."), (Throwable)e);
                }
                break;
            }
            this.log.error((Object)("The 'responseTime' metric is enabled for " + this.context.getResourceType() + " Resource with key [" + this.context.getResourceKey() + "], but no value is defined for the '" + "responseTimeLogFile" + "' connection property."));
            break;
        }
        super.getValues(report, requests);
    }

    private File findLogFile() {
        File logFile = null;
        ServerPluginConfiguration serverPluginConfig = this.getServerComponent().getServerPluginConfiguration();
        File logDir = serverPluginConfig.getLogDir();
        if (logDir != null && logDir.isDirectory()) {
            try {
                String contextRoot;
                String virtualHost = this.readAttribute("virtual-host");
                if (virtualHost != null && (contextRoot = this.readAttribute("context-root")) != null) {
                    String logFileName = String.format("%s_%s_rt.log", virtualHost, contextRoot);
                    logFile = new File(logDir, logFileName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return logFile;
    }
}

