/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class ASUploadConnection {
    private static final String HTTP_SCHEME = "http";
    private static final int SOCKET_CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_READ_TIMEOUT = 60000;
    private static final String TRIGGER_AUTH_URL_PATH = "/management";
    private static final String UPLOAD_URL_PATH = "/management/add-content";
    private static final int FILE_POST_MAX_LOGGABLE_RESPONSE_LENGTH = 2048;
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EMPTY_JSON_TREE = "{}";
    private static final String JSON_NODE_FAILURE_DESCRIPTION = "failure-description";
    private static final String JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT = "FailureDescription: -input was null-";
    private static final String JSON_NODE_OUTCOME = "outcome";
    private static final String JSON_NODE_OUTCOME_VALUE_FAILED = "failed";
    private static final Log log = LogFactory.getLog(ASUploadConnection.class);
    private String scheme = "http";
    private String host;
    private int port;
    private UsernamePasswordCredentials credentials;
    private String fileName;
    private int timeout;
    private File cacheFile;
    private BufferedOutputStream cacheOutputStream;

    @Deprecated
    public ASUploadConnection(String host, int port, String user, String password) {
        this(host, port, user, password, null);
    }

    public ASUploadConnection(String host, int port, String user, String password, String fileName) {
        if (host == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (StringUtil.isBlank((String)fileName)) {
            throw new IllegalArgumentException("Filename cannot be blank");
        }
        this.host = host;
        this.port = port;
        if (user != null && password != null) {
            this.credentials = new UsernamePasswordCredentials(user, password);
        }
        this.fileName = fileName;
        this.timeout = 60000;
    }

    @Deprecated
    public ASUploadConnection(ASConnection asConnection) {
        this(asConnection.getHost(), asConnection.getPort(), asConnection.getUser(), asConnection.getPassword(), null);
    }

    public ASUploadConnection(ASConnection asConnection, String fileName) {
        this(asConnection.getHost(), asConnection.getPort(), asConnection.getUser(), asConnection.getPassword(), fileName);
    }

    public static ASUploadConnection newInstanceForServerPluginConfiguration(ServerPluginConfiguration pluginConfig, String fileName) {
        return new ASUploadConnection(pluginConfig.getHostname(), pluginConfig.getPort(), pluginConfig.getUser(), pluginConfig.getPassword(), fileName);
    }

    @Deprecated
    public OutputStream getOutputStream(String fileName) {
        this.fileName = fileName;
        return this.getOutputStream();
    }

    public OutputStream getOutputStream() {
        try {
            this.cacheFile = File.createTempFile(this.getClass().getSimpleName(), ".cache");
            this.cacheOutputStream = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            return this.cacheOutputStream;
        }
        catch (IOException e) {
            log.error((Object)("Could not create outputstream for " + this.fileName), (Throwable)e);
            return null;
        }
    }

    public void cancelUpload() {
        this.closeQuietly(this.cacheOutputStream);
        this.deleteCacheFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode finishUpload() {
        if (this.fileName == null) {
            throw new IllegalStateException("Upload fileName is null");
        }
        this.closeQuietly(this.cacheOutputStream);
        SimpleHttpConnectionManager httpConnectionManager = new SimpleHttpConnectionManager();
        HttpClient client = new HttpClient((HttpConnectionManager)httpConnectionManager);
        if (this.credentialsProvided()) {
            client.getState().setCredentials(new AuthScope(this.host, this.port, AuthScope.ANY_REALM), (Credentials)this.credentials);
        }
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(this.timeout);
        String triggerAuthURL = this.scheme + "://" + this.host + ":" + this.port + TRIGGER_AUTH_URL_PATH;
        GetMethod triggerAuthGET = new GetMethod(triggerAuthURL);
        try {
            client.executeMethod((HttpMethod)triggerAuthGET);
        }
        catch (Exception ignore) {
        }
        finally {
            triggerAuthGET.releaseConnection();
        }
        String uploadURL = this.scheme + "://" + this.host + ":" + this.port + UPLOAD_URL_PATH;
        PostMethod filePOST = new PostMethod(uploadURL);
        try {
            Part[] parts = new Part[]{new FilePart(this.fileName, this.cacheFile)};
            filePOST.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePOST.getParams()));
            int responseCode = client.executeMethod((HttpMethod)filePOST);
            if (responseCode != 200) {
                this.logUploadDoesNotEndWithHttpOkStatus(filePOST, responseCode);
                JsonNode jsonNode = null;
                return jsonNode;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            InputStream responseBodyAsStream = filePOST.getResponseBodyAsStream();
            if (responseBodyAsStream == null) {
                log.warn((Object)"POST request has no response body");
                JsonNode jsonNode = objectMapper.readTree(EMPTY_JSON_TREE);
                return jsonNode;
            }
            JsonNode jsonNode = objectMapper.readTree(responseBodyAsStream);
            return jsonNode;
        }
        catch (Exception e) {
            log.error((Object)e);
            JsonNode jsonNode = null;
            return jsonNode;
        }
        finally {
            filePOST.releaseConnection();
            httpConnectionManager.closeIdleConnections(0L);
            this.deleteCacheFile();
        }
    }

    public static String getFailureDescription(JsonNode jsonNode) {
        if (jsonNode == null) {
            return JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT;
        }
        JsonNode node = jsonNode.findValue(JSON_NODE_FAILURE_DESCRIPTION);
        if (node == null) {
            return JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT;
        }
        return node.getValueAsText();
    }

    public static boolean isErrorReply(JsonNode jsonNode) {
        if (jsonNode == null) {
            return true;
        }
        if (jsonNode.has(JSON_NODE_OUTCOME)) {
            String outcome = null;
            try {
                JsonNode outcomeNode = jsonNode.findValue(JSON_NODE_OUTCOME);
                outcome = outcomeNode.getTextValue();
                if (outcome.equals(JSON_NODE_OUTCOME_VALUE_FAILED)) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                return true;
            }
        }
        return false;
    }

    private boolean credentialsProvided() {
        return this.credentials != null;
    }

    private void logUploadDoesNotEndWithHttpOkStatus(PostMethod filePOST, int responseCode) {
        StringBuilder logMessageBuilder = new StringBuilder("File upload failed: ").append(HttpStatus.getStatusText((int)responseCode));
        if (filePOST.getResponseContentLength() > 0L && filePOST.getResponseContentLength() < 2048L) {
            try {
                String responseBodyAsString = filePOST.getResponseBodyAsString();
                logMessageBuilder.append(SYSTEM_LINE_SEPARATOR).append(responseBodyAsString);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        log.warn((Object)logMessageBuilder.toString());
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteCacheFile() {
        if (this.cacheFile != null) {
            this.cacheFile.delete();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

