/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.util.ParentDefinedJMXServerNamingUtility;

public class EmbeddedJMXServerDiscoveryComponent
implements ResourceDiscoveryComponent<JMXComponent<?>> {
    private static final String RESOURCE_KEY = "JVM";
    private static final String JAVA_VERSION_SYSPROP = "java.version";
    private final Log log = LogFactory.getLog(EmbeddedJMXServerDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context) throws Exception {
        EmsBean runtimeMBean = this.getRuntimeMXBean(context);
        if (runtimeMBean == null) {
            return Collections.emptySet();
        }
        String name = ParentDefinedJMXServerNamingUtility.getJVMName(context);
        String version = EmbeddedJMXServerDiscoveryComponent.getSystemProperty(runtimeMBean, JAVA_VERSION_SYSPROP);
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        pluginConfig.put((Property)new PropertySimple("type", (Object)"PARENT"));
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(context.getResourceType(), RESOURCE_KEY, name, version, context.getResourceType().getDescription(), pluginConfig, null);
        return Collections.singleton(resourceDetails);
    }

    @Nullable
    private EmsBean getRuntimeMXBean(ResourceDiscoveryContext<JMXComponent<?>> context) {
        EmsConnection emsConnection = ((JMXComponent)context.getParentResourceComponent()).getEmsConnection();
        if (emsConnection == null) {
            this.log.debug((Object)("Parent EMS connection is null for [" + context.getParentResourceContext().getResourceKey() + "] " + context.getParentResourceContext().getResourceType() + " JVM."));
            return null;
        }
        emsConnection.refresh();
        EmsBean runtimeMBean = emsConnection.getBean("java.lang:type=Runtime");
        if (runtimeMBean == null) {
            this.log.debug((Object)("MBean [java.lang:type=Runtime] not found for [" + context.getParentResourceContext().getResourceKey() + "] " + context.getParentResourceContext().getResourceType() + " JVM."));
        }
        return runtimeMBean;
    }

    private static String getSystemProperty(EmsBean runtimeMBean, String propertyName) throws Exception {
        EmsAttribute systemPropertiesAttribute = runtimeMBean.getAttribute("systemProperties");
        Object tabularDataObj = systemPropertiesAttribute.refresh();
        Method getMethod = tabularDataObj.getClass().getMethod("get", Class.forName("[Ljava.lang.Object;"));
        Object compositeDataObj = getMethod.invoke(tabularDataObj, new Object[]{new Object[]{propertyName}});
        getMethod = compositeDataObj.getClass().getMethod("get", String.class);
        String version = (String)getMethod.invoke(compositeDataObj, "value");
        return version;
    }
}

