/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.util.ConnectionProviderFactory;

public class JMXServerComponent<T extends ResourceComponent<?>>
implements JMXComponent<T> {
    private static final Log log = LogFactory.getLog(JMXServerComponent.class);
    private volatile EmsConnection connection;
    private volatile ConnectionProvider connectionProvider;
    ResourceContext context;

    public void start(ResourceContext context) throws Exception {
        this.context = context;
        log.debug((Object)("Starting connection to " + context.getResourceType() + "[" + context.getResourceKey() + "]..."));
        try {
            this.internalStart();
        }
        catch (Exception e) {
            if (e.getCause() instanceof SecurityException) {
                throw new InvalidPluginConfigurationException("Failed to authenticate to managed JVM - principal and/or credentials connection properties are not set correctly.");
            }
            log.warn((Object)("Failed to connect to " + context.getResourceType() + "[" + context.getResourceKey() + "]."), (Throwable)e);
        }
    }

    protected void internalStart() throws Exception {
        Configuration pluginConfig = this.context.getPluginConfiguration();
        String connectionTypeDescriptorClassName = pluginConfig.getSimple("type").getStringValue();
        if ("PARENT".equals(connectionTypeDescriptorClassName)) {
            this.connection = ((JMXComponent)this.context.getParentResourceComponent()).getEmsConnection();
            this.connectionProvider = this.connection.getConnectionProvider();
        } else {
            this.connectionProvider = ConnectionProviderFactory.createConnectionProvider(pluginConfig, this.context.getNativeProcess(), this.context.getTemporaryDirectory());
            this.connection = this.connectionProvider.connect();
            this.connection.loadSynchronous(false);
        }
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                log.error((Object)("Error closing EMS connection: " + e));
            }
            this.connection = null;
        }
    }

    @Override
    public EmsConnection getEmsConnection() {
        this.reconnectIfDisconnected();
        return this.connection;
    }

    public AvailabilityType getAvailability() {
        this.reconnectIfDisconnected();
        return this.connectionProvider != null && this.connectionProvider.isConnected() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    protected ResourceContext getResourceContext() {
        return this.context;
    }

    private synchronized void reconnectIfDisconnected() {
        if (this.connectionProvider == null || !this.connectionProvider.isConnected()) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    log.debug((Object)("Unable to close existing EmsConnection for " + this.context.getResourceType() + "[" + this.context.getResourceKey() + "] due to error: " + e));
                }
            }
            try {
                this.internalStart();
            }
            catch (Exception e) {
                log.debug((Object)("Unable to reconnect to " + this.context.getResourceType() + "[" + this.context.getResourceKey() + "] due to error: " + e));
            }
        }
    }
}

