/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.kickstart;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;

public class KickstartServerComponent
implements ResourceComponent,
OperationFacet {
    private final Log log = LogFactory.getLog(KickstartServerComponent.class);
    private ResourceContext resourceContext;

    public void start(ResourceContext context) {
        this.resourceContext = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public OperationResult invokeOperation(String name, Configuration configuration) {
        OperationResult res = new OperationResult();
        if (name.equals("installGuest")) {
            this.log.info((Object)"Installing a Guest");
            String command = "/usr/bin/koan";
            String virtName = configuration.getSimpleValue("name", "Guest " + System.currentTimeMillis());
            String profile = configuration.getSimpleValue("profile", "profile");
            String server = configuration.getSimpleValue("server", "localhost");
            String[] argsString = new String[]{"--virt", "--server", server, "--profile", profile, "--virt-name", virtName};
            ProcessExecutionResults pr = this.execute(command, argsString);
            if (pr.getExitCode() > 0) {
                this.log.error((Object)("Error executing command: " + this.buildCommandString(command, argsString)));
                res.setErrorMessage(pr.getCapturedOutput());
            } else {
                res.setSimpleResult(pr.getCapturedOutput());
            }
        }
        return res;
    }

    public ProcessExecutionResults execute(String process, String ... args) {
        List<String> argsList = Arrays.asList(args);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Executing command " + this.buildCommandString(process, args)));
        }
        ProcessExecution pe = new ProcessExecution(process);
        pe.setCaptureOutput(true);
        pe.setCheckExecutableExists(true);
        pe.setArguments(Arrays.asList(args));
        ProcessExecutionResults pr = this.resourceContext.getSystemInformation().executeProcess(pe);
        this.log.debug((Object)("Result " + pr.getExitCode()));
        return pr;
    }

    private String buildCommandString(String process, String ... argsList) {
        String argsString = process;
        for (String arg : argsList) {
            argsString = argsString + " " + arg;
        }
        return process;
    }
}

