/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.kickstart;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;

public class KickstartDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog(KickstartDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        SystemInfo sysinfo = context.getSystemInformation();
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        if (OperatingSystemType.LINUX == sysinfo.getOperatingSystemType() && this.packageExists(sysinfo, "koan")) {
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), "Kickstart", "Kickstart", "1", "Koan Kickstart Engine", null, null);
            set.add(detail);
        }
        return set;
    }

    public boolean packageExists(SystemInfo sysinfo, String packageName) {
        boolean exists = false;
        ProcessExecution pe = new ProcessExecution("/bin/rpm");
        pe.setCaptureOutput(true);
        pe.setCheckExecutableExists(true);
        pe.setArguments(Arrays.asList("-qa", packageName));
        ProcessExecutionResults pr = sysinfo.executeProcess(pe);
        if (pr.getExitCode() == 0) {
            String output = pr.getCapturedOutput();
            exists = output.contains(packageName);
        }
        return exists;
    }
}

