/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.plugins.netservices.util.StringUtil;

class HTTPNetServiceComponentConfiguration {
    private URL endPointUrl;
    private HttpMethod httpMethod;
    private Pattern responseValidationPattern;
    private ProxyMode proxyMode;
    private String proxyHost;
    private int proxyPort;

    HTTPNetServiceComponentConfiguration(URL endPointUrl, HttpMethod httpMethod, Pattern responseValidationPattern, ProxyMode proxyMode, String proxyHost, int proxyPort) {
        this.endPointUrl = endPointUrl;
        this.httpMethod = httpMethod;
        this.responseValidationPattern = responseValidationPattern;
        this.proxyMode = proxyMode;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    static HTTPNetServiceComponentConfiguration createComponentConfiguration(Configuration pluginConfig) {
        ProxyMode proxyMode;
        URL endPointUrl = null;
        String configUrl = pluginConfig.getSimpleValue("url", "");
        if (StringUtil.isBlank(configUrl)) {
            throw new InvalidPluginConfigurationException("Endpoint URL is not defined");
        }
        try {
            endPointUrl = new URL(configUrl);
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginConfigurationException(configUrl + " is not a valid URL");
        }
        String protocol = endPointUrl.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new InvalidPluginConfigurationException(configUrl + "does not point to an http(s) resource");
        }
        HttpMethod httpMethod = null;
        String configMethod = pluginConfig.getSimpleValue("method", "");
        try {
            httpMethod = HttpMethod.valueOf(configMethod);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPluginConfigurationException("Invalid http method: " + configMethod);
        }
        Pattern responseValidationPattern = null;
        String configValidateResponsePattern = pluginConfig.getSimpleValue("validateResponsePattern");
        if (configValidateResponsePattern != null) {
            if (httpMethod.equals((Object)HttpMethod.HEAD)) {
                throw new InvalidPluginConfigurationException("Cannot validate response content with HEAD request");
            }
            try {
                responseValidationPattern = Pattern.compile(configValidateResponsePattern);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidPluginConfigurationException("Invalid pattern: " + configValidateResponsePattern);
            }
        }
        String configProxyMode = pluginConfig.getSimpleValue("proxyMode", ProxyMode.NONE.name());
        try {
            proxyMode = ProxyMode.valueOf(configProxyMode);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPluginConfigurationException("Invalid proxy mode: " + configProxyMode);
        }
        String proxyHost = pluginConfig.getSimpleValue("proxyHost", "");
        String configProxyPort = pluginConfig.getSimpleValue("proxyPort", "");
        int proxyPort = -1;
        switch (proxyMode) {
            case MANUAL: {
                if (StringUtil.isBlank(proxyHost)) {
                    throw new InvalidPluginConfigurationException("In '" + ProxyMode.MANUAL.name() + "' proxy mode the " + "proxyHost" + " property must be set");
                }
                if (StringUtil.isBlank(configProxyPort)) {
                    throw new InvalidPluginConfigurationException("In '" + ProxyMode.MANUAL.name() + "' proxy mode the " + "proxyPort" + " property must be set");
                }
                try {
                    proxyPort = Integer.parseInt(configProxyPort);
                }
                catch (NumberFormatException e) {
                    throw new InvalidPluginConfigurationException(configProxyPort + " is not a number");
                }
                if (proxyPort >= 1 && proxyPort <= 65535) break;
                throw new InvalidPluginConfigurationException(configProxyPort + " is not a valid port number");
            }
        }
        return new HTTPNetServiceComponentConfiguration(endPointUrl, httpMethod, responseValidationPattern, proxyMode, proxyHost, proxyPort);
    }

    URL getEndPointUrl() {
        return this.endPointUrl;
    }

    HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    Pattern getResponseValidationPattern() {
        return this.responseValidationPattern;
    }

    ProxyMode getProxyMode() {
        return this.proxyMode;
    }

    String getProxyHost() {
        return this.proxyHost;
    }

    int getProxyPort() {
        return this.proxyPort;
    }

    static enum ProxyMode {
        NONE,
        SYS_PROPS,
        MANUAL;

    }

    static enum HttpMethod {
        GET,
        HEAD;

    }
}

