/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.io.IOException;
import java.net.ProxySelector;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.netservices.HTTPNetServiceComponentConfiguration;
import org.rhq.plugins.netservices.util.StringUtil;

public class HTTPNetServiceComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(HTTPNetServiceComponent.class);
    private Configuration pluginConfig;
    private HTTPNetServiceComponentConfiguration componentConfig;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.pluginConfig = resourceContext.getPluginConfiguration();
        this.componentConfig = HTTPNetServiceComponentConfiguration.createComponentConfiguration(this.pluginConfig);
    }

    public void stop() {
        this.pluginConfig = null;
        this.componentConfig = null;
    }

    public AvailabilityType getAvailability() {
        try {
            return this.getValuesOrAvailability(null, null) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        this.getValuesOrAvailability(report, metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getValuesOrAvailability(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        HttpGet method;
        BasicClientConnectionManager httpConnectionManager = new BasicClientConnectionManager();
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager);
        String userName = this.pluginConfig.getSimpleValue("user", "");
        if (StringUtil.isNotBlank(userName)) {
            String password = this.pluginConfig.getSimpleValue("password", "");
            String realm = this.pluginConfig.getSimpleValue("realm", AuthScope.ANY_REALM);
            client.getCredentialsProvider().setCredentials(new AuthScope(this.componentConfig.getEndPointUrl().getHost(), this.componentConfig.getEndPointUrl().getPort(), realm), (Credentials)new UsernamePasswordCredentials(userName, password));
        }
        switch (this.componentConfig.getHttpMethod()) {
            case GET: {
                method = new HttpGet(this.componentConfig.getEndPointUrl().toExternalForm());
                break;
            }
            case HEAD: {
                method = new HttpHead(this.componentConfig.getEndPointUrl().toExternalForm());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported http method: '" + (Object)((Object)this.componentConfig.getHttpMethod()) + "'");
            }
        }
        Boolean followRedirects = this.pluginConfig.getSimple("followRedirects").getBooleanValue();
        HttpParams httpParams = client.getParams();
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)(followRedirects == null ? false : followRedirects));
        switch (this.componentConfig.getProxyMode()) {
            case MANUAL: {
                HttpHost proxy = new HttpHost(this.componentConfig.getProxyHost(), this.componentConfig.getProxyPort());
                httpParams.setParameter("http.route.default-proxy", (Object)proxy);
                break;
            }
            case SYS_PROPS: {
                ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
                client.setRoutePlanner((HttpRoutePlanner)routePlanner);
                break;
            }
        }
        try {
            long start = System.nanoTime();
            HttpResponse response = client.execute((HttpUriRequest)method);
            long connectTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            int responseCode = response.getStatusLine().getStatusCode();
            boolean success = this.pluginConfig.getSimple("validateResponseCode").getBooleanValue() == false || responseCode >= 200 && responseCode <= 299;
            success = success && (this.componentConfig.getResponseValidationPattern() == null || this.componentConfig.getResponseValidationPattern().matcher(this.getResponseBody(response)).find());
            long readTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            Header dateHeader = response.getFirstHeader("Date");
            Date contentDate = dateHeader == null ? null : DateUtils.parseDate((String)dateHeader.getValue());
            HttpEntity entity = response.getEntity();
            if (metrics != null) {
                for (MeasurementScheduleRequest request : metrics) {
                    if (request.getName().equals("connectTime")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(connectTime)));
                        continue;
                    }
                    if (request.getName().equals("readTime")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(readTime)));
                        continue;
                    }
                    if (request.getName().equals("contentLength")) {
                        if (entity == null) continue;
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(entity.getContentLength())));
                        continue;
                    }
                    if (!request.getName().equals("contentAge") || contentDate == null) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(System.currentTimeMillis() - contentDate.getTime())));
                }
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)e);
            }
        }
        finally {
            method.abort();
            client.getConnectionManager().shutdown();
        }
        return false;
    }

    private String getResponseBody(HttpResponse response) throws IOException {
        HttpEntity httpResponseEntity = response.getEntity();
        return httpResponseEntity == null ? "" : EntityUtils.toString((HttpEntity)httpResponseEntity);
    }

    public static final class ConfigKeys {
        public static final String URL = "url";
        public static final String USER = "user";
        public static final String PASSWORD = "password";
        public static final String REALM = "realm";
        public static final String METHOD = "method";
        public static final String FOLOW_REDIRECTS = "followRedirects";
        public static final String VALIDATE_RESPONSE_CODE = "validateResponseCode";
        public static final String VALIDATE_RESPONSE_PATTERN = "validateResponsePattern";
        public static final String PROXY_MODE = "proxyMode";
        public static final String PROXY_HOST = "proxyHost";
        public static final String PROXY_PORT = "proxyPort";

        private ConfigKeys() {
        }
    }
}

