/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.platform.PlatformComponent;
import org.rhq.plugins.platform.win.Win32EventLogDelegate;
import org.rhq.plugins.platform.win.WindowsSoftwareDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsPlatformComponent
extends PlatformComponent
implements ContentFacet {
    private Win32EventLogDelegate eventLogDelegate;

    @Override
    public void start(ResourceContext context) {
        super.start(context);
        if (context.getPluginConfiguration().getSimple("eventTrackingEnabled").getBooleanValue().booleanValue()) {
            this.eventLogDelegate = new Win32EventLogDelegate(context.getPluginConfiguration());
            this.eventLogDelegate.open();
            context.getEventContext().registerEventPoller((EventPoller)this.eventLogDelegate, 60);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.eventLogDelegate != null) {
            this.resourceContext.getEventContext().unregisterEventPoller(this.eventLogDelegate.getEventType());
            this.eventLogDelegate.close();
        }
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return new WindowsSoftwareDelegate().discoverInstalledSoftware(type);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }
}

