/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.ProcessComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDiscoveryComponent
implements ResourceDiscoveryComponent {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        SystemInfo systemInformation = resourceDiscoveryContext.getSystemInformation();
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>();
        List configs = resourceDiscoveryContext.getPluginConfigurations();
        for (Configuration config : configs) {
            ProcessInfo processInfo = ProcessComponent.getProcessForConfiguration(config, systemInformation);
            String type = config.getSimpleValue("type", "pidFile");
            String resourceKey = config.getSimpleValue(type, null);
            if (resourceKey == null || resourceKey.length() == 0) {
                throw new InvalidPluginConfigurationException("Invalid type [" + type + "] value [" + resourceKey + "]");
            }
            ResourceType resourceType = resourceDiscoveryContext.getResourceType();
            String resourceName = processInfo.getBaseName();
            String resourceVersion = null;
            String resourceDescription = null;
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, resourceVersion, resourceDescription, config, processInfo);
            results.add(detail);
        }
        return results;
    }
}

