/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.Set;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.CpuInformation;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuComponent
implements ResourceComponent<PlatformComponent>,
MeasurementFacet {
    private CpuInformation cpuInformation = null;

    public void start(ResourceContext<PlatformComponent> resourceContext) {
        if (resourceContext.getSystemInformation().isNative()) {
            this.cpuInformation = resourceContext.getSystemInformation().getCpu(Integer.parseInt(resourceContext.getResourceKey()));
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        if (this.cpuInformation != null) {
            this.cpuInformation.refresh();
            return this.cpuInformation.isEnabled() ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        return AvailabilityType.UP;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        if (this.cpuInformation != null) {
            this.cpuInformation.refresh();
            Cpu cpu = null;
            CpuPerc cpuPerc = null;
            CpuInfo cpuInfo = null;
            for (MeasurementScheduleRequest request : metrics) {
                Object o;
                Number num;
                String property = request.getName();
                if (property.startsWith("Cpu.")) {
                    Long longValue;
                    if (cpu == null) {
                        cpu = this.cpuInformation.getCpu();
                    }
                    if ((longValue = (Long)ObjectUtil.lookupAttributeProperty((Object)cpu, (String)(property = property.substring(property.indexOf(".") + 1)))) == null || longValue == -1L) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(longValue.doubleValue())));
                    continue;
                }
                if (property.startsWith("CpuPerc.")) {
                    if (cpuPerc == null) {
                        cpuPerc = this.cpuInformation.getCpuPercentage();
                    }
                    if ((num = (Number)ObjectUtil.lookupAttributeProperty((Object)cpuPerc, (String)(property = property.substring(property.indexOf(".") + 1)))) == null) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(num.doubleValue())));
                    continue;
                }
                if (property.startsWith("CpuInfo.")) {
                    if (cpuInfo == null) {
                        cpuInfo = this.cpuInformation.getCpuInfo();
                    }
                    if ((num = (Number)ObjectUtil.lookupAttributeProperty((Object)cpuInfo, (String)(property = property.substring(property.indexOf(".") + 1)))) == null) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(num.doubleValue())));
                    continue;
                }
                if (!property.startsWith("CpuTrait.")) continue;
                if (cpuInfo == null) {
                    cpuInfo = this.cpuInformation.getCpuInfo();
                }
                if ((o = ObjectUtil.lookupAttributeProperty((Object)cpuInfo, (String)(property = property.substring(property.indexOf(".") + 1)))) == null) continue;
                String res = "model".equals(property) || "vendor".equals(property) ? (String)o : String.valueOf(o);
                report.addData(new MeasurementDataTrait(request, res));
            }
        }
    }
}

