/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemoveIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.platform.LinuxDistroInfo;
import org.rhq.plugins.platform.PlatformComponent;
import org.rhq.plugins.platform.SyslogFileEventLogDelegate;
import org.rhq.plugins.platform.SyslogListenerEventLogDelegate;
import org.rhq.plugins.platform.SyslogProcessor;
import org.rhq.plugins.platform.content.RpmPackageDiscoveryDelegate;
import org.rhq.plugins.platform.content.yum.PluginContext;
import org.rhq.plugins.platform.content.yum.YumProxy;
import org.rhq.plugins.platform.content.yum.YumServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxPlatformComponent
extends PlatformComponent
implements ContentFacet {
    private static final String DISTRO_TRAIT_NAME_PREFIX = "distro.";
    private static final String TRAIT_DISTRO_NAME = "distro.name";
    private static final String TRAIT_DISTRO_VERSION = "distro.version";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_LOGS = "logs";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_ENABLED = "logTrackingEnabled";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_INCLUDES_REGEX = "logTrackingIncludesPattern";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_MIN_SEV = "logTrackingMinimumSeverity";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_PARSER_REGEX = "logTrackingParserRegex";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_DATETIME_FORMAT = "logTrackingDateTimeFormat";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_TYPE = "logTrackingType";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_PORT = "logTrackingPort";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_BIND_ADDR = "logTrackingBindAddress";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_FILE_PATH = "logTrackingFilePath";
    private final Log log = LogFactory.getLog(LinuxPlatformComponent.class);
    private ContentContext contentContext;
    private YumServer yumServer = new YumServer();
    private YumProxy yumProxy = new YumProxy();
    private boolean enableContentDiscovery = false;
    private boolean enableInternalYumServer = false;
    private List<SyslogListenerEventLogDelegate> listenerEventDelegates;
    private List<SyslogFileEventLogDelegate> fileEventDelegates;

    @Override
    public void start(ResourceContext context) {
        Boolean bool;
        Boolean bool2;
        super.start(context);
        Configuration pluginConfiguration = context.getPluginConfiguration();
        PropertySimple contentProp = pluginConfiguration.getSimple("enableContentDiscovery");
        this.enableContentDiscovery = contentProp != null ? ((bool2 = contentProp.getBooleanValue()) != null ? bool2 : false) : false;
        PropertySimple yumProp = pluginConfiguration.getSimple("enableInternalYumServer");
        this.enableInternalYumServer = yumProp != null ? ((bool = yumProp.getBooleanValue()) != null ? bool : false) : false;
        if (this.enableContentDiscovery) {
            RpmPackageDiscoveryDelegate.setSystemInfo(this.resourceContext.getSystemInformation());
            RpmPackageDiscoveryDelegate.checkExecutables();
        }
        this.startWithContentContext(context.getContentContext());
        PropertyList logs = pluginConfiguration.getList(PLUGIN_CONFIG_EVENT_TRACKING_LOGS);
        if (logs != null && logs.getList() != null && logs.getList().size() > 0) {
            for (Property logProp : logs.getList()) {
                try {
                    SyslogProcessor delegate;
                    PropertyMap singleLog = (PropertyMap)logProp;
                    if (!singleLog.getSimple(PLUGIN_CONFIG_EVENT_TRACKING_ENABLED).getBooleanValue().booleanValue()) continue;
                    if (this.getEventTrackingType(singleLog) == EventTrackingType.listener) {
                        delegate = new SyslogListenerEventLogDelegate(context, singleLog);
                        if (this.listenerEventDelegates == null) {
                            this.listenerEventDelegates = new ArrayList<SyslogListenerEventLogDelegate>();
                        }
                        this.listenerEventDelegates.add((SyslogListenerEventLogDelegate)delegate);
                        continue;
                    }
                    if (this.getEventTrackingType(singleLog) != EventTrackingType.file) continue;
                    delegate = new SyslogFileEventLogDelegate(context, singleLog);
                    if (this.fileEventDelegates == null) {
                        this.fileEventDelegates = new ArrayList<SyslogFileEventLogDelegate>();
                    }
                    this.fileEventDelegates.add((SyslogFileEventLogDelegate)delegate);
                }
                catch (Exception e) {
                    this.log.debug((Object)("Failed to prepare for event log [" + logProp + "]"), (Throwable)e);
                }
            }
        }
    }

    private EventTrackingType getEventTrackingType(PropertyMap logConfiguration) {
        EventTrackingType typeEnum;
        String type = logConfiguration.getSimpleValue(PLUGIN_CONFIG_EVENT_TRACKING_TYPE, EventTrackingType.file.name());
        try {
            typeEnum = EventTrackingType.valueOf(type.toLowerCase());
        }
        catch (Exception e) {
            typeEnum = EventTrackingType.file;
            this.log.warn((Object)("event tracking type is invalid [" + type + "], defaulting to: " + (Object)((Object)typeEnum)));
        }
        return typeEnum;
    }

    @Override
    public void stop() {
        this.shutdownSyslogDelegates();
        try {
            this.yumServer.halt();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to shutdown the yum server", (Throwable)e);
        }
        super.stop();
    }

    private void shutdownSyslogDelegates() {
        if (this.listenerEventDelegates != null) {
            for (SyslogListenerEventLogDelegate syslogListenerEventLogDelegate : this.listenerEventDelegates) {
                try {
                    syslogListenerEventLogDelegate.shutdown();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to shutdown a syslog listener", (Throwable)e);
                }
            }
            this.listenerEventDelegates.clear();
        }
        if (this.fileEventDelegates != null) {
            for (SyslogFileEventLogDelegate syslogFileEventLogDelegate : this.fileEventDelegates) {
                try {
                    syslogFileEventLogDelegate.shutdown();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to shutdown a syslog file poller", (Throwable)e);
                }
            }
            this.fileEventDelegates.clear();
        }
    }

    private void startWithContentContext(ContentContext context) {
        if (this.enableInternalYumServer) {
            int port = this.yumPort();
            this.log.debug((Object)("yum port=[" + port + "]"));
            this.contentContext = context;
            try {
                PluginContext yumContext = new PluginContext(port, this.resourceContext, context);
                this.yumServer.start(yumContext);
                this.yumProxy.init(this.resourceContext);
            }
            catch (Exception e) {
                this.log.error((Object)"Start failed:", (Throwable)e);
            }
        } else {
            this.log.info((Object)"Internal yum server is disabled.");
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        Set<ResourcePackageDetails> detailsSet = new HashSet<ResourcePackageDetails>();
        if (this.enableContentDiscovery && type.getName().equals("rpm")) {
            try {
                detailsSet = RpmPackageDiscoveryDelegate.discoverPackages(type);
            }
            catch (IOException e) {
                this.log.error((Object)"Error while trying to discover RPMs", (Throwable)e);
            }
        }
        return detailsSet;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        try {
            DeployPackagesResponse result = new DeployPackagesResponse(ContentResponseResult.SUCCESS);
            ArrayList<String> pkgs = new ArrayList<String>();
            for (ResourcePackageDetails p : packages) {
                String pkgInfo = p.getName();
                String version = p.getVersion();
                if (version != null && !"".equals(version)) {
                    pkgInfo = pkgInfo + "-" + version;
                }
                this.log.info((Object)("Adding <" + pkgInfo + "> to list of packages to deploy, original package object was: " + p));
                pkgs.add(pkgInfo);
                result.addPackageResponse(new DeployIndividualPackageResponse(p.getKey(), ContentResponseResult.SUCCESS));
            }
            this.yumProxy.install(pkgs);
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)"Install packages failed", (Throwable)e);
            return new DeployPackagesResponse(ContentResponseResult.FAILURE);
        }
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        try {
            RemovePackagesResponse result = new RemovePackagesResponse(ContentResponseResult.SUCCESS);
            ArrayList<String> pkgs = new ArrayList<String>();
            for (ResourcePackageDetails p : packages) {
                pkgs.add(p.getName());
                result.addPackageResponse(new RemoveIndividualPackageResponse(p.getKey(), ContentResponseResult.SUCCESS));
            }
            this.yumProxy.remove(pkgs);
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)"Remove packages failed", (Throwable)e);
            return new RemovePackagesResponse(ContentResponseResult.FAILURE);
        }
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metricRequests) {
        super.getValues(report, metricRequests);
        for (MeasurementScheduleRequest metricRequest : metricRequests) {
            if (!metricRequest.getName().startsWith(DISTRO_TRAIT_NAME_PREFIX)) continue;
            report.addData(this.getDistroTrait(metricRequest));
        }
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("cleanYumMetadataCache".equals(name)) {
            if (this.yumServer.isStarted()) {
                this.log.info((Object)"Cleaning yum metadata");
                this.yumServer.cleanMetadata();
                this.yumProxy.cleanMetadata();
                return new OperationResult();
            }
            throw new UnsupportedOperationException("Internal yum server is disabled, this operation is a no-op");
        }
        return super.invokeOperation(name, parameters);
    }

    private MeasurementDataTrait getDistroTrait(MeasurementScheduleRequest metricRequest) {
        MeasurementDataTrait trait = new MeasurementDataTrait(metricRequest, "?");
        if (metricRequest.getName().equals(TRAIT_DISTRO_NAME)) {
            trait.setValue(LinuxDistroInfo.getInstance().getName());
        } else if (metricRequest.getName().equals(TRAIT_DISTRO_VERSION)) {
            trait.setValue(LinuxDistroInfo.getInstance().getVersion());
        } else {
            this.log.error((Object)("Being asked to collect an unknown Linux distro trait: " + metricRequest.getName()));
        }
        return trait;
    }

    private int yumPort() {
        PropertySimple p = this.resourceContext.getPluginConfiguration().getSimple("yumPort");
        return p != null ? p.getIntegerValue() : 9080;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventTrackingType {
        listener,
        file;

    }
}

