/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Swap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SigarAccess;
import org.rhq.core.system.SystemInfo;

public class PlatformComponent
implements ResourceComponent,
ConfigurationFacet,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(PlatformComponent.class);
    private static final String NATIVE_INDICATOR = "Native.";
    private static final String TRAIT_INDICATOR = "Trait.";
    private static final String TRAIT_HOSTNAME = "Trait.hostname";
    private static final String TRAIT_OSNAME = "Trait.osname";
    private static final String TRAIT_OSVERSION = "Trait.osversion";
    private static final String TRAIT_ARCH = "Trait.sysarch";
    protected ResourceContext resourceContext;
    private SystemInfo sysinfo;

    public void start(ResourceContext context) {
        this.resourceContext = context;
        this.sysinfo = context.getSystemInformation();
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public Configuration loadResourceConfiguration() {
        Configuration config = new Configuration();
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setErrorMessage("Cannot update platform resource configuration - it is read only");
        report.setStatus(ConfigurationUpdateStatus.FAILURE);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        SystemInfo info = this.resourceContext.getSystemInformation();
        boolean isNative = info.isNative();
        Mem platformMemoryInfo = null;
        Swap platformSwapInfo = null;
        CpuPerc cpuPerc = null;
        try {
            cpuPerc = SigarAccess.getSigar().getCpuPerc();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (MeasurementScheduleRequest request : metrics) {
            Number num;
            String property = request.getName();
            if (property.startsWith(NATIVE_INDICATOR)) {
                if (!isNative) continue;
                property = property.substring(NATIVE_INDICATOR.length());
            }
            if (property.startsWith(TRAIT_INDICATOR)) {
                report.addData(this.getMeasurementDataTrait(request));
                continue;
            }
            if (property.startsWith("MemoryInfo.")) {
                if (platformMemoryInfo == null) {
                    platformMemoryInfo = info.getMemoryInfo();
                }
                property = property.substring(property.indexOf(".") + 1);
                double memoryValue = ((Number)this.getObjectProperty(platformMemoryInfo, property)).doubleValue();
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(memoryValue)));
                continue;
            }
            if (property.startsWith("SwapInfo.")) {
                if (platformSwapInfo == null) {
                    platformSwapInfo = info.getSwapInfo();
                }
                if (platformSwapInfo == null) continue;
                property = property.substring(property.indexOf(".") + 1);
                double swapValue = ((Number)this.getObjectProperty(platformSwapInfo, property)).doubleValue();
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(swapValue)));
                continue;
            }
            if (!property.startsWith("CpuPerc.") || cpuPerc == null || (num = (Number)ObjectUtil.lookupAttributeProperty((Object)cpuPerc, (String)(property = property.substring(property.indexOf(".") + 1)))) == null) continue;
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(num.doubleValue())));
        }
    }

    private Object getObjectProperty(Object object, String name) {
        block3: {
            try {
                BeanInfo info = Introspector.getBeanInfo(object.getClass());
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    if (!pd.getName().equals(name)) continue;
                    return pd.getReadMethod().invoke(object, new Object[0]);
                }
            }
            catch (Exception skip) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)skip);
            }
        }
        return Double.NaN;
    }

    private MeasurementDataTrait getMeasurementDataTrait(MeasurementScheduleRequest request) {
        String name = request.getName();
        MeasurementDataTrait trait = new MeasurementDataTrait(request, "?");
        try {
            if (TRAIT_HOSTNAME.indexOf(name) > -1) {
                trait.setValue(this.sysinfo.getHostname());
            } else if (TRAIT_OSNAME.indexOf(name) > -1) {
                trait.setValue(this.sysinfo.getOperatingSystemName());
            } else if (TRAIT_OSVERSION.indexOf(name) > -1) {
                trait.setValue(this.sysinfo.getOperatingSystemVersion());
            } else if (TRAIT_ARCH.indexOf(name) > -1) {
                trait.setValue(this.sysinfo.getSystemArchitecture());
            } else {
                this.log.error((Object)("Being asked to collect an unknown trait measurement: " + name));
            }
        }
        catch (Exception skip) {
            this.log.debug((Object)skip);
        }
        return trait;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("discovery".equals(name)) {
            Boolean detailed = parameters.getSimple("detailedDiscovery").getBooleanValue();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            String results = (String)mbs.invoke(new ObjectName("rhq.pc:type=PluginContainer"), "executeDiscovery", new Object[]{detailed}, new String[]{Boolean.class.getName()});
            return new OperationResult(results);
        }
        if ("viewProcessList".equals(name)) {
            OperationResult result = new OperationResult();
            List processes = this.resourceContext.getSystemInformation().getAllProcesses();
            PropertyList processList = new PropertyList("processList");
            for (ProcessInfo process : processes) {
                PropertyMap pm = new PropertyMap("process");
                pm.put((Property)new PropertySimple("pid", (Object)process.getPid()));
                pm.put((Property)new PropertySimple("name", (Object)process.getBaseName()));
                pm.put((Property)new PropertySimple("size", process.getMemory() != null ? Long.valueOf(process.getMemory().getSize()) : "0"));
                pm.put((Property)new PropertySimple("userTime", process.getTime() != null ? Long.valueOf(process.getTime().getUser()) : "0"));
                pm.put((Property)new PropertySimple("kernelTime", process.getTime() != null ? Long.valueOf(process.getTime().getSys()) : "0"));
                processList.add((Property)pm);
            }
            result.getComplexResults().put((Property)processList);
            return result;
        }
        throw new UnsupportedOperationException("Operation [" + name + "] not supported on " + this.resourceContext.getResourceType() + ".");
    }
}

