/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;

public class RpmPackageDiscoveryDelegate {
    private static SystemInfo systemInfo;
    private static String rpmExecutable;

    public static void checkExecutables() {
        ProcessExecution processExecution = new ProcessExecution("/usr/bin/which");
        processExecution.setArguments(new String[]{"rpm"});
        processExecution.setCaptureOutput(true);
        ProcessExecutionResults executionResults = systemInfo.executeProcess(processExecution);
        String capturedOutput = executionResults.getCapturedOutput();
        rpmExecutable = capturedOutput == null || "".equals(capturedOutput) ? null : capturedOutput.trim();
    }

    public static void setSystemInfo(SystemInfo systemInfo) {
        RpmPackageDiscoveryDelegate.systemInfo = systemInfo;
    }

    public static Set<ResourcePackageDetails> discoverPackages(PackageType type) throws IOException {
        String rpmName;
        Log log = LogFactory.getLog(RpmPackageDiscoveryDelegate.class);
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        if (rpmExecutable == null) {
            return packages;
        }
        ProcessExecution listRpmsProcess = new ProcessExecution(rpmExecutable);
        listRpmsProcess.setArguments(new String[]{"-qa"});
        listRpmsProcess.setCaptureOutput(true);
        ProcessExecutionResults executionResults = systemInfo.executeProcess(listRpmsProcess);
        String capturedOutput = executionResults.getCapturedOutput();
        if (capturedOutput == null) {
            return packages;
        }
        BufferedReader rpmNameReader = new BufferedReader(new StringReader(capturedOutput));
        while ((rpmName = rpmNameReader.readLine()) != null) {
            String name = null;
            String version = null;
            String architectureName = null;
            try {
                String descriptionTemp;
                ProcessExecution rpmQuery = new ProcessExecution(rpmExecutable);
                rpmQuery.setArguments(new String[]{"-q", "--qf", "%{NAME}\\n%{VERSION}.%{RELEASE}\\n%{ARCH}\\n%{INSTALLTIME}\\n%{FILEMD5S}\\n%{GROUP}\\n%{FILENAMES}\\n%{SIZE}\\n%{LICENSE}\\n%{DESCRIPTION}", rpmName});
                rpmQuery.setCaptureOutput(true);
                ProcessExecutionResults rpmDataResults = systemInfo.executeProcess(rpmQuery);
                String rpmData = rpmDataResults.getCapturedOutput();
                BufferedReader rpmDataReader = new BufferedReader(new StringReader(rpmData));
                name = rpmDataReader.readLine();
                version = rpmDataReader.readLine();
                architectureName = rpmDataReader.readLine();
                String installTimeString = rpmDataReader.readLine();
                String md5 = rpmDataReader.readLine();
                String category = rpmDataReader.readLine();
                String fileName = rpmDataReader.readLine();
                String sizeString = rpmDataReader.readLine();
                String license = rpmDataReader.readLine();
                StringBuffer description = new StringBuffer();
                while ((descriptionTemp = rpmDataReader.readLine()) != null) {
                    description.append(descriptionTemp);
                }
                Long fileSize = null;
                if (sizeString != null) {
                    try {
                        fileSize = Long.parseLong(sizeString);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Could not parse file size: " + sizeString));
                    }
                }
                Long installTime = null;
                if (installTimeString != null) {
                    try {
                        installTime = Long.parseLong(installTimeString);
                        installTime = installTime * 1000L;
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)"Could not parse package install time");
                    }
                }
                if (fileName == null || fileName.equals("")) continue;
                PackageDetailsKey key = new PackageDetailsKey(name, version, "rpm", architectureName);
                ResourcePackageDetails packageDetails = new ResourcePackageDetails(key);
                packageDetails.setClassification(category);
                packageDetails.setDisplayName(name);
                packageDetails.setFileName(fileName);
                if (!md5.startsWith("00000000000000000000000000000000")) {
                    if (md5.length() <= 32) {
                        packageDetails.setMD5(md5);
                    } else {
                        packageDetails.setSHA256(md5);
                    }
                }
                packageDetails.setFileSize(fileSize);
                packageDetails.setLicenseName(license);
                packageDetails.setLongDescription(description.toString());
                packageDetails.setInstallationTimestamp(installTime.longValue());
                packages.add(packageDetails);
            }
            catch (Exception e) {
                log.error((Object)("Error creating resource package. RPM Name: " + rpmName + " Version: " + version + " Architecture: " + architectureName));
            }
        }
        return packages;
    }
}

