/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.platform.PlatformComponent;
import org.rhq.plugins.platform.SyslogFileEventLogDelegate;
import org.rhq.plugins.platform.SyslogListenerEventLogDelegate;
import org.rhq.plugins.platform.SyslogProcessor;

public class PosixPlatformComponent
extends PlatformComponent {
    private final Log log = LogFactory.getLog(PosixPlatformComponent.class);
    protected List<SyslogListenerEventLogDelegate> listenerEventDelegates;
    protected List<SyslogFileEventLogDelegate> fileEventDelegates;
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_LOGS = "logs";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_ENABLED = "logTrackingEnabled";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_INCLUDES_REGEX = "logTrackingIncludesPattern";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_MIN_SEV = "logTrackingMinimumSeverity";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_PARSER_REGEX = "logTrackingParserRegex";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_DATETIME_FORMAT = "logTrackingDateTimeFormat";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_TYPE = "logTrackingType";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_PORT = "logTrackingPort";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_BIND_ADDR = "logTrackingBindAddress";
    public static final String PLUGIN_CONFIG_EVENT_TRACKING_FILE_PATH = "logTrackingFilePath";

    @Override
    public void start(ResourceContext context) {
        super.start(context);
        Configuration pluginConfiguration = context.getPluginConfiguration();
        PropertyList logs = pluginConfiguration.getList(PLUGIN_CONFIG_EVENT_TRACKING_LOGS);
        if (logs != null && logs.getList() != null && logs.getList().size() > 0) {
            for (Property logProp : logs.getList()) {
                try {
                    SyslogProcessor delegate;
                    PropertyMap singleLog = (PropertyMap)logProp;
                    if (!singleLog.getSimple(PLUGIN_CONFIG_EVENT_TRACKING_ENABLED).getBooleanValue().booleanValue()) continue;
                    if (this.getEventTrackingType(singleLog) == EventTrackingType.listener) {
                        delegate = new SyslogListenerEventLogDelegate(context, singleLog);
                        if (this.listenerEventDelegates == null) {
                            this.listenerEventDelegates = new ArrayList<SyslogListenerEventLogDelegate>();
                        }
                        this.listenerEventDelegates.add((SyslogListenerEventLogDelegate)delegate);
                        continue;
                    }
                    if (this.getEventTrackingType(singleLog) != EventTrackingType.file) continue;
                    delegate = new SyslogFileEventLogDelegate(context, singleLog);
                    if (this.fileEventDelegates == null) {
                        this.fileEventDelegates = new ArrayList<SyslogFileEventLogDelegate>();
                    }
                    this.fileEventDelegates.add((SyslogFileEventLogDelegate)delegate);
                }
                catch (Exception e) {
                    this.log.debug((Object)("Failed to prepare for event log [" + logProp + "]"), (Throwable)e);
                }
            }
        }
    }

    private EventTrackingType getEventTrackingType(PropertyMap logConfiguration) {
        EventTrackingType typeEnum;
        String type = logConfiguration.getSimpleValue(PLUGIN_CONFIG_EVENT_TRACKING_TYPE, EventTrackingType.file.name());
        try {
            typeEnum = EventTrackingType.valueOf(type.toLowerCase());
        }
        catch (Exception e) {
            typeEnum = EventTrackingType.file;
            this.log.warn((Object)("event tracking type is invalid [" + type + "], defaulting to: " + (Object)((Object)typeEnum)));
        }
        return typeEnum;
    }

    protected void shutdownSyslogDelegates() {
        if (this.listenerEventDelegates != null) {
            for (SyslogListenerEventLogDelegate syslogListenerEventLogDelegate : this.listenerEventDelegates) {
                try {
                    syslogListenerEventLogDelegate.shutdown();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to shutdown a syslog listener", (Throwable)e);
                }
            }
            this.listenerEventDelegates.clear();
        }
        if (this.fileEventDelegates != null) {
            for (SyslogFileEventLogDelegate syslogFileEventLogDelegate : this.fileEventDelegates) {
                try {
                    syslogFileEventLogDelegate.shutdown();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to shutdown a syslog file poller", (Throwable)e);
                }
            }
            this.fileEventDelegates.clear();
        }
    }

    @Override
    public void stop() {
        this.shutdownSyslogDelegates();
        super.stop();
    }

    protected static enum EventTrackingType {
        listener,
        file;

    }
}

